/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.lucene;

import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.search.lucene.IndexAccessor;
import com.liferay.portal.search.lucene.LuceneFields;
import com.liferay.portal.search.lucene.LuceneHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.util.Version;

public class LuceneHelperUtil {
    private static LuceneHelper _luceneHelper;

    public static void addDate(Document doc, String field, Date value) {
        doc.add((Fieldable)LuceneFields.getDate(field, value));
    }

    public static void addDocument(long companyId, Document document) throws IOException {
        LuceneHelperUtil.getLuceneHelper().addDocument(companyId, document);
    }

    public static void addExactTerm(BooleanQuery booleanQuery, String field, boolean value) {
        LuceneHelperUtil.addExactTerm(booleanQuery, field, String.valueOf(value));
    }

    public static void addExactTerm(BooleanQuery booleanQuery, String field, double value) {
        LuceneHelperUtil.addExactTerm(booleanQuery, field, String.valueOf(value));
    }

    public static void addExactTerm(BooleanQuery booleanQuery, String field, int value) {
        LuceneHelperUtil.addExactTerm(booleanQuery, field, String.valueOf(value));
    }

    public static void addExactTerm(BooleanQuery booleanQuery, String field, long value) {
        LuceneHelperUtil.addExactTerm(booleanQuery, field, String.valueOf(value));
    }

    public static void addExactTerm(BooleanQuery booleanQuery, String field, short value) {
        LuceneHelperUtil.addExactTerm(booleanQuery, field, String.valueOf(value));
    }

    public static void addExactTerm(BooleanQuery booleanQuery, String field, String value) {
        LuceneHelperUtil.getLuceneHelper().addExactTerm(booleanQuery, field, value);
    }

    public static void addNumericRangeTerm(BooleanQuery booleanQuery, String field, int startValue, int endValue) {
        LuceneHelperUtil.getLuceneHelper().addNumericRangeTerm(booleanQuery, field, startValue, endValue);
    }

    public static void addNumericRangeTerm(BooleanQuery booleanQuery, String field, Integer startValue, Integer endValue) {
        LuceneHelperUtil.getLuceneHelper().addNumericRangeTerm(booleanQuery, field, startValue, endValue);
    }

    public static void addNumericRangeTerm(BooleanQuery booleanQuery, String field, long startValue, long endValue) {
        LuceneHelperUtil.getLuceneHelper().addNumericRangeTerm(booleanQuery, field, startValue, endValue);
    }

    public static void addNumericRangeTerm(BooleanQuery booleanQuery, String field, Long startValue, Long endValue) {
        LuceneHelperUtil.getLuceneHelper().addNumericRangeTerm(booleanQuery, field, startValue, endValue);
    }

    public static void addNumericRangeTerm(BooleanQuery booleanQuery, String field, short startValue, short endValue) {
        LuceneHelperUtil.getLuceneHelper().addNumericRangeTerm(booleanQuery, field, Long.valueOf(startValue), Long.valueOf(endValue));
    }

    public static void addNumericRangeTerm(BooleanQuery booleanQuery, String field, Short startValue, Short endValue) {
        LuceneHelperUtil.getLuceneHelper().addNumericRangeTerm(booleanQuery, field, GetterUtil.getLong((Object)startValue), GetterUtil.getLong((Object)endValue));
    }

    public static void addRangeTerm(BooleanQuery booleanQuery, String field, int startValue, int endValue) {
        LuceneHelperUtil.getLuceneHelper().addRangeTerm(booleanQuery, field, String.valueOf(startValue), String.valueOf(endValue));
    }

    public static void addRangeTerm(BooleanQuery booleanQuery, String field, Integer startValue, Integer endValue) {
        LuceneHelperUtil.getLuceneHelper().addRangeTerm(booleanQuery, field, String.valueOf(startValue), String.valueOf(endValue));
    }

    public static void addRangeTerm(BooleanQuery booleanQuery, String field, long startValue, long endValue) {
        LuceneHelperUtil.getLuceneHelper().addRangeTerm(booleanQuery, field, String.valueOf(startValue), String.valueOf(endValue));
    }

    public static void addRangeTerm(BooleanQuery booleanQuery, String field, Long startValue, Long endValue) {
        LuceneHelperUtil.getLuceneHelper().addRangeTerm(booleanQuery, field, String.valueOf(startValue), String.valueOf(endValue));
    }

    public static void addRangeTerm(BooleanQuery booleanQuery, String field, short startValue, short endValue) {
        LuceneHelperUtil.getLuceneHelper().addRangeTerm(booleanQuery, field, String.valueOf(startValue), String.valueOf(endValue));
    }

    public static void addRangeTerm(BooleanQuery booleanQuery, String field, Short startValue, Short endValue) {
        LuceneHelperUtil.getLuceneHelper().addRangeTerm(booleanQuery, field, String.valueOf(startValue), String.valueOf(endValue));
    }

    public static void addRangeTerm(BooleanQuery booleanQuery, String field, String startValue, String endValue) {
        LuceneHelperUtil.getLuceneHelper().addRangeTerm(booleanQuery, field, startValue, endValue);
    }

    public static void addRequiredTerm(BooleanQuery booleanQuery, String field, boolean value) {
        LuceneHelperUtil.addRequiredTerm(booleanQuery, field, String.valueOf(value));
    }

    public static void addRequiredTerm(BooleanQuery booleanQuery, String field, double value) {
        LuceneHelperUtil.addRequiredTerm(booleanQuery, field, String.valueOf(value));
    }

    public static void addRequiredTerm(BooleanQuery booleanQuery, String field, int value) {
        LuceneHelperUtil.addRequiredTerm(booleanQuery, field, String.valueOf(value));
    }

    public static void addRequiredTerm(BooleanQuery booleanQuery, String field, long value) {
        LuceneHelperUtil.addRequiredTerm(booleanQuery, field, String.valueOf(value));
    }

    public static void addRequiredTerm(BooleanQuery booleanQuery, String field, short value) {
        LuceneHelperUtil.addRequiredTerm(booleanQuery, field, String.valueOf(value));
    }

    public static void addRequiredTerm(BooleanQuery booleanQuery, String field, String value) {
        LuceneHelperUtil.addRequiredTerm(booleanQuery, field, value, false);
    }

    public static void addRequiredTerm(BooleanQuery booleanQuery, String field, String value, boolean like) {
        LuceneHelperUtil.getLuceneHelper().addRequiredTerm(booleanQuery, field, value, like);
    }

    public static void addRequiredTerm(BooleanQuery booleanQuery, String field, String[] values, boolean like) {
        LuceneHelperUtil.getLuceneHelper().addRequiredTerm(booleanQuery, field, values, like);
    }

    public static void addTerm(BooleanQuery booleanQuery, String field, long value) {
        LuceneHelperUtil.addTerm(booleanQuery, field, String.valueOf(value));
    }

    public static void addTerm(BooleanQuery booleanQuery, String field, String value) {
        LuceneHelperUtil.addTerm(booleanQuery, field, value, false);
    }

    public static void addTerm(BooleanQuery booleanQuery, String field, String value, boolean like) {
        LuceneHelperUtil.getLuceneHelper().addTerm(booleanQuery, field, value, like);
    }

    public static void addTerm(BooleanQuery booleanQuery, String field, String value, boolean like, BooleanClauseOccur booleanClauseOccur) {
        LuceneHelperUtil.getLuceneHelper().addTerm(booleanQuery, field, value, like, booleanClauseOccur);
    }

    public static void addTerm(BooleanQuery booleanQuery, String field, String[] values, boolean like) {
        LuceneHelperUtil.getLuceneHelper().addTerm(booleanQuery, field, values, like);
    }

    public static void cleanUp(IndexSearcher indexSearcher) {
        LuceneHelperUtil.getLuceneHelper().cleanUp(indexSearcher);
    }

    public static int countScoredFieldNames(Query query, String[] fieldNames) {
        return LuceneHelperUtil.getLuceneHelper().countScoredFieldNames(query, fieldNames);
    }

    public static void delete(long companyId) {
        LuceneHelperUtil.getLuceneHelper().delete(companyId);
    }

    public static void deleteDocuments(long companyId, Term term) throws IOException {
        LuceneHelperUtil.getLuceneHelper().deleteDocuments(companyId, term);
    }

    public static void dumpIndex(long companyId, OutputStream outputStream) throws IOException {
        LuceneHelperUtil.getLuceneHelper().dumpIndex(companyId, outputStream);
    }

    public static Analyzer getAnalyzer() {
        return LuceneHelperUtil.getLuceneHelper().getAnalyzer();
    }

    public static IndexAccessor getIndexAccessor(long companyId) {
        return LuceneHelperUtil.getLuceneHelper().getIndexAccessor(companyId);
    }

    public static long getLastGeneration(long companyId) {
        return LuceneHelperUtil.getLuceneHelper().getLastGeneration(companyId);
    }

    public static InputStream getLoadIndexesInputStreamFromCluster(long companyId, Address bootupAddress) throws SystemException {
        return LuceneHelperUtil.getLuceneHelper().getLoadIndexesInputStreamFromCluster(companyId, bootupAddress);
    }

    public static LuceneHelper getLuceneHelper() {
        return _luceneHelper;
    }

    public static Set<String> getQueryTerms(Query query) {
        return LuceneHelperUtil.getLuceneHelper().getQueryTerms(query);
    }

    public static IndexSearcher getSearcher(long companyId, boolean readOnly) throws IOException {
        return LuceneHelperUtil.getLuceneHelper().getSearcher(companyId, readOnly);
    }

    public static String getSnippet(Query query, String field, String s) throws IOException {
        SimpleHTMLFormatter formatter = new SimpleHTMLFormatter("", "");
        return LuceneHelperUtil.getSnippet(query, field, s, (Formatter)formatter);
    }

    public static String getSnippet(Query query, String field, String s, Formatter formatter) throws IOException {
        return LuceneHelperUtil.getSnippet(query, field, s, 3, 80, "...", formatter);
    }

    public static String getSnippet(Query query, String field, String s, int maxNumFragments, int fragmentLength, String fragmentSuffix, Formatter formatter) throws IOException {
        return LuceneHelperUtil.getLuceneHelper().getSnippet(query, field, s, maxNumFragments, fragmentLength, fragmentSuffix, formatter);
    }

    public static Version getVersion() {
        return LuceneHelperUtil.getLuceneHelper().getVersion();
    }

    public static boolean isLoadIndexFromClusterEnabled() {
        return LuceneHelperUtil.getLuceneHelper().isLoadIndexFromClusterEnabled();
    }

    public static void loadIndex(long companyId, InputStream inputStream) throws IOException {
        LuceneHelperUtil.getLuceneHelper().loadIndex(companyId, inputStream);
    }

    public static void loadIndexesFromCluster(long companyId) throws SystemException {
        LuceneHelperUtil.getLuceneHelper().loadIndexesFromCluster(companyId);
    }

    public static void shutdown() {
        LuceneHelperUtil.getLuceneHelper().shutdown();
    }

    public static void shutdown(long companyId) {
        LuceneHelperUtil.getLuceneHelper().shutdown(companyId);
    }

    public static void startup(long companyId) {
        LuceneHelperUtil.getLuceneHelper().startup(companyId);
    }

    public static void updateDocument(long companyId, Term term, Document document) throws IOException {
        LuceneHelperUtil.getLuceneHelper().updateDocument(companyId, term, document);
    }

    public void setLuceneHelper(LuceneHelper luceneHelper) {
        _luceneHelper = luceneHelper;
    }
}

