/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.lucene;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.resiliency.spi.SPIUtil;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.search.lucene.IndexAccessor;
import com.liferay.portal.search.lucene.LuceneHelperUtil;
import com.liferay.portal.search.lucene.dump.DumpIndexDeletionPolicy;
import com.liferay.portal.search.lucene.dump.IndexCommitSerializationUtil;
import com.liferay.portal.util.ClassLoaderUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LimitTokenCountAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LogMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.RAMDirectory;

public class IndexAccessorImpl
implements IndexAccessor {
    private static final String _LUCENE_STORE_TYPE_FILE = "file";
    private static final String _LUCENE_STORE_TYPE_JDBC = "jdbc";
    private static final String _LUCENE_STORE_TYPE_RAM = "ram";
    private static Log _log = LogFactoryUtil.getLog(IndexAccessorImpl.class);
    private volatile int _batchCount;
    private Lock _commitLock = new ReentrantLock();
    private long _companyId;
    private DumpIndexDeletionPolicy _dumpIndexDeletionPolicy = new DumpIndexDeletionPolicy();
    private IndexWriter _indexWriter;
    private Map<String, Directory> _ramDirectories = new ConcurrentHashMap<String, Directory>();

    public IndexAccessorImpl(long companyId) {
        this._companyId = companyId;
        if (!SPIUtil.isSPI()) {
            this._checkLuceneDir();
            this._initIndexWriter();
            this._initCommitScheduler();
        }
    }

    @Override
    public void addDocument(Document document) throws IOException {
        if (SearchEngineUtil.isIndexReadOnly()) {
            return;
        }
        this._write(null, document);
    }

    @Override
    public void addDocuments(Collection<Document> documents) throws IOException {
        try {
            for (Document document : documents) {
                this._indexWriter.addDocument(document);
            }
            ++this._batchCount;
        }
        finally {
            this._commit();
        }
    }

    @Override
    public void close() {
        if (SPIUtil.isSPI()) {
            return;
        }
        try {
            this._indexWriter.close();
        }
        catch (Exception e2) {
            _log.error((Object)("Closing Lucene writer failed for " + this._companyId), (Throwable)e2);
        }
    }

    @Override
    public void delete() {
        if (SearchEngineUtil.isIndexReadOnly()) {
            return;
        }
        this._deleteDirectory();
    }

    @Override
    public void deleteDocuments(Term term) throws IOException {
        if (SearchEngineUtil.isIndexReadOnly()) {
            return;
        }
        try {
            this._indexWriter.deleteDocuments(term);
            ++this._batchCount;
        }
        finally {
            this._commit();
        }
    }

    @Override
    public void dumpIndex(OutputStream outputStream) throws IOException {
        this._dumpIndexDeletionPolicy.dump(outputStream, this._indexWriter, this._commitLock);
    }

    @Override
    public long getCompanyId() {
        return this._companyId;
    }

    @Override
    public long getLastGeneration() {
        return this._dumpIndexDeletionPolicy.getLastGeneration();
    }

    @Override
    public Directory getLuceneDir() {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Lucene store type " + PropsValues.LUCENE_STORE_TYPE));
        }
        if (PropsValues.LUCENE_STORE_TYPE.equals(_LUCENE_STORE_TYPE_FILE)) {
            return this._getLuceneDirFile();
        }
        if (PropsValues.LUCENE_STORE_TYPE.equals(_LUCENE_STORE_TYPE_JDBC)) {
            throw new IllegalArgumentException("Store type JDBC is no longer supported in favor of SOLR");
        }
        if (PropsValues.LUCENE_STORE_TYPE.equals(_LUCENE_STORE_TYPE_RAM)) {
            return this._getLuceneDirRam();
        }
        throw new RuntimeException("Invalid store type " + PropsValues.LUCENE_STORE_TYPE);
    }

    @Override
    public void loadIndex(InputStream inputStream) throws IOException {
        IndexSearcher indexSearcher;
        IndexReader indexReader;
        FSDirectory tempDirectory;
        File tempFile;
        block3: {
            tempFile = FileUtil.createTempFile();
            tempDirectory = FSDirectory.open((File)tempFile);
            IndexCommitSerializationUtil.deserializeIndex(inputStream, (Directory)tempDirectory);
            this._deleteDirectory();
            indexReader = IndexReader.open((Directory)tempDirectory, (boolean)false);
            indexSearcher = new IndexSearcher(indexReader);
            try {
                ScoreDoc[] scoreDocs;
                TopDocs topDocs = indexSearcher.search((Query)new MatchAllDocsQuery(), indexReader.numDocs());
                ScoreDoc[] scoreDocArray = scoreDocs = topDocs.scoreDocs;
                int n = scoreDocs.length;
                int n2 = 0;
                while (n2 < n) {
                    ScoreDoc scoreDoc = scoreDocArray[n2];
                    Document document = indexSearcher.doc(scoreDoc.doc);
                    this.addDocument(document);
                    ++n2;
                }
            }
            catch (IllegalArgumentException iae) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Object)iae.getMessage());
            }
        }
        indexSearcher.close();
        indexReader.flush();
        indexReader.close();
        tempDirectory.close();
        FileUtil.deltree((File)tempFile);
    }

    @Override
    public void updateDocument(Term term, Document document) throws IOException {
        if (SearchEngineUtil.isIndexReadOnly()) {
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing " + document));
        }
        this._write(term, document);
    }

    private void _checkLuceneDir() {
        if (SearchEngineUtil.isIndexReadOnly()) {
            return;
        }
        try {
            Directory directory = this.getLuceneDir();
            if (IndexWriter.isLocked((Directory)directory)) {
                IndexWriter.unlock((Directory)directory);
            }
        }
        catch (Exception e2) {
            _log.error((Object)("Check Lucene directory failed for " + this._companyId), (Throwable)e2);
        }
    }

    private void _commit() throws IOException {
        if (PropsValues.LUCENE_COMMIT_BATCH_SIZE == 0 || PropsValues.LUCENE_COMMIT_BATCH_SIZE <= this._batchCount) {
            this._doCommit();
        }
    }

    private void _deleteDirectory() {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Lucene store type " + PropsValues.LUCENE_STORE_TYPE));
        }
        if (PropsValues.LUCENE_STORE_TYPE.equals(_LUCENE_STORE_TYPE_FILE)) {
            this._deleteFile();
        } else {
            if (PropsValues.LUCENE_STORE_TYPE.equals(_LUCENE_STORE_TYPE_JDBC)) {
                throw new IllegalArgumentException("Store type JDBC is no longer supported in favor of SOLR");
            }
            if (PropsValues.LUCENE_STORE_TYPE.equals(_LUCENE_STORE_TYPE_RAM)) {
                this._deleteRam();
            } else {
                throw new RuntimeException("Invalid store type " + PropsValues.LUCENE_STORE_TYPE);
            }
        }
    }

    private void _deleteFile() {
        block2: {
            String path = this._getPath();
            try {
                this._indexWriter.deleteAll();
                this._indexWriter.commit();
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)("Could not delete index in directory " + path));
            }
        }
    }

    private void _deleteRam() {
    }

    private void _doCommit() throws IOException {
        if (this._indexWriter != null) {
            this._commitLock.lock();
            try {
                this._indexWriter.commit();
            }
            finally {
                this._commitLock.unlock();
            }
        }
        this._batchCount = 0;
    }

    private FSDirectory _getDirectory(String path) throws IOException {
        if (PropsValues.LUCENE_STORE_TYPE_FILE_FORCE_MMAP) {
            return new MMapDirectory(new File(path));
        }
        return FSDirectory.open((File)new File(path));
    }

    private Directory _getLuceneDirFile() {
        FSDirectory directory;
        block4: {
            directory = null;
            String path = this._getPath();
            try {
                directory = this._getDirectory(path);
            }
            catch (IOException iOException) {
                if (directory == null) break block4;
                try {
                    directory.close();
                }
                catch (Exception exception) {}
            }
        }
        return directory;
    }

    private Directory _getLuceneDirRam() {
        String path = this._getPath();
        Directory directory = this._ramDirectories.get(path);
        if (directory == null) {
            directory = new RAMDirectory();
            this._ramDirectories.put(path, directory);
        }
        return directory;
    }

    private MergePolicy _getMergePolicy() throws Exception {
        ClassLoader classLoader = ClassLoaderUtil.getPortalClassLoader();
        MergePolicy mergePolicy = (MergePolicy)InstanceFactory.newInstance((ClassLoader)classLoader, (String)PropsValues.LUCENE_MERGE_POLICY);
        if (mergePolicy instanceof LogMergePolicy) {
            LogMergePolicy logMergePolicy = (LogMergePolicy)mergePolicy;
            logMergePolicy.setMergeFactor(PropsValues.LUCENE_MERGE_FACTOR);
        }
        return mergePolicy;
    }

    private String _getPath() {
        return PropsValues.LUCENE_DIR.concat(String.valueOf(this._companyId)).concat("/");
    }

    private void _initCommitScheduler() {
        if (PropsValues.LUCENE_COMMIT_BATCH_SIZE <= 0 || PropsValues.LUCENE_COMMIT_TIME_INTERVAL <= 0) {
            return;
        }
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    if (IndexAccessorImpl.this._batchCount > 0) {
                        IndexAccessorImpl.this._doCommit();
                    }
                }
                catch (IOException ioe) {
                    _log.error((Object)"Could not run scheduled commit", (Throwable)ioe);
                }
            }
        };
        scheduledExecutorService.scheduleWithFixedDelay(runnable, 0L, PropsValues.LUCENE_COMMIT_TIME_INTERVAL, TimeUnit.MILLISECONDS);
    }

    private void _initIndexWriter() {
        try {
            LimitTokenCountAnalyzer analyzer = new LimitTokenCountAnalyzer(LuceneHelperUtil.getAnalyzer(), PropsValues.LUCENE_ANALYZER_MAX_TOKENS);
            IndexWriterConfig indexWriterConfig = new IndexWriterConfig(LuceneHelperUtil.getVersion(), (Analyzer)analyzer);
            indexWriterConfig.setIndexDeletionPolicy((IndexDeletionPolicy)this._dumpIndexDeletionPolicy);
            indexWriterConfig.setMergePolicy(this._getMergePolicy());
            indexWriterConfig.setRAMBufferSizeMB((double)PropsValues.LUCENE_BUFFER_SIZE);
            this._indexWriter = new IndexWriter(this.getLuceneDir(), indexWriterConfig);
            if (!IndexReader.indexExists((Directory)this.getLuceneDir())) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Creating missing index");
                }
                this._doCommit();
            }
        }
        catch (Exception e2) {
            _log.error((Object)("Initializing Lucene writer failed for " + this._companyId), (Throwable)e2);
        }
    }

    private void _write(Term term, Document document) throws IOException {
        try {
            if (term != null) {
                this._indexWriter.updateDocument(term, document);
            } else {
                this._indexWriter.addDocument(document);
            }
            ++this._batchCount;
        }
        finally {
            this._commit();
        }
    }
}

