/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search;

import com.liferay.portal.NoSuchResourceException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchPermissionChecker;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.UniqueList;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.UserGroupRole;
import com.liferay.portal.security.permission.AdvancedPermissionChecker;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerBag;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.security.permission.ResourceBlockIdsBag;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.ResourceBlockLocalServiceUtil;
import com.liferay.portal.service.ResourceBlockPermissionLocalServiceUtil;
import com.liferay.portal.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.UserGroupRoleLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SearchPermissionCheckerImpl
implements SearchPermissionChecker {
    private static Log _log = LogFactoryUtil.getLog(SearchPermissionCheckerImpl.class);

    public void addPermissionFields(long companyId, Document document) {
        try {
            long groupId = GetterUtil.getLong((String)document.get("groupId"));
            String className = document.get("entryClassName");
            boolean relatedEntry = GetterUtil.getBoolean((String)document.get("relatedEntry"));
            if (relatedEntry) {
                long classNameId = GetterUtil.getLong((String)document.get("classNameId"));
                className = PortalUtil.getClassName((long)classNameId);
            }
            if (Validator.isNull((String)className)) {
                return;
            }
            String classPK = document.get("rootEntryClassPK");
            if (Validator.isNull((String)classPK)) {
                classPK = document.get("entryClassPK");
            }
            if (relatedEntry) {
                classPK = document.get("classPK");
            }
            if (Validator.isNull((String)classPK)) {
                return;
            }
            Indexer indexer = IndexerRegistryUtil.getIndexer((String)className);
            if (!indexer.isPermissionAware()) {
                return;
            }
            this.doAddPermissionFields_6(companyId, groupId, className, classPK, document);
        }
        catch (NoSuchResourceException noSuchResourceException) {
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    public Query getPermissionQuery(long companyId, long[] groupIds, long userId, String className, Query query, SearchContext searchContext) {
        try {
            query = this.doGetPermissionQuery(companyId, groupIds, userId, className, query, searchContext);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        return query;
    }

    public void updatePermissionFields(String resourceName, String resourceClassPK) {
        try {
            this.doUpdatePermissionFields(resourceName, resourceClassPK);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    protected void addRequiredMemberRole(Group group, BooleanQuery permissionQuery) throws Exception {
        if (group.isOrganization()) {
            Role organizationUserRole = RoleLocalServiceUtil.getRole((long)group.getCompanyId(), (String)"Organization User");
            permissionQuery.addTerm("groupRoleId", String.valueOf(group.getGroupId()) + "-" + organizationUserRole.getRoleId());
        }
        if (group.isSite()) {
            Role siteMemberRole = RoleLocalServiceUtil.getRole((long)group.getCompanyId(), (String)"Site Member");
            permissionQuery.addTerm("groupRoleId", String.valueOf(group.getGroupId()) + "-" + siteMemberRole.getRoleId());
        }
    }

    protected void doAddPermissionFields_6(long companyId, long groupId, String className, String classPK, Document doc) throws Exception {
        Group group = null;
        if (groupId > 0L) {
            group = GroupLocalServiceUtil.getGroup((long)groupId);
        }
        List roles = ListUtil.copy((List)ResourceActionsUtil.getRoles((long)companyId, (Group)group, (String)className, null));
        if (groupId > 0L) {
            List teamRoles = RoleLocalServiceUtil.getTeamRoles((long)groupId);
            roles.addAll(teamRoles);
        }
        long[] roleIdsArray = new long[roles.size()];
        int i2 = 0;
        while (i2 < roleIdsArray.length) {
            Role role = (Role)roles.get(i2);
            roleIdsArray[i2] = role.getRoleId();
            ++i2;
        }
        boolean[] hasResourcePermissions = null;
        if (ResourceBlockLocalServiceUtil.isSupported((String)className)) {
            ResourceBlockIdsBag resourceBlockIdsBag = ResourceBlockLocalServiceUtil.getResourceBlockIdsBag((long)companyId, (long)groupId, (String)className, (long[])roleIdsArray);
            long actionId = ResourceBlockLocalServiceUtil.getActionId((String)className, (String)"VIEW");
            List resourceBlockIds = resourceBlockIdsBag.getResourceBlockIds(actionId);
            hasResourcePermissions = new boolean[roleIdsArray.length];
            Iterator iterator = resourceBlockIds.iterator();
            while (iterator.hasNext()) {
                long resourceBlockId = (Long)iterator.next();
                int i3 = 0;
                while (i3 < roleIdsArray.length) {
                    int count = ResourceBlockPermissionLocalServiceUtil.getResourceBlockPermissionsCount((long)resourceBlockId, (long)roleIdsArray[i3]);
                    hasResourcePermissions[i3] = count > 0;
                    ++i3;
                }
            }
        } else {
            hasResourcePermissions = ResourcePermissionLocalServiceUtil.hasResourcePermissions((long)companyId, (String)className, (int)4, (String)classPK, (long[])roleIdsArray, (String)"VIEW");
        }
        ArrayList<Long> roleIds = new ArrayList<Long>();
        ArrayList<String> groupRoleIds = new ArrayList<String>();
        int i4 = 0;
        while (i4 < hasResourcePermissions.length) {
            if (hasResourcePermissions[i4]) {
                Role role = (Role)roles.get(i4);
                if (role.getType() == 3 || role.getType() == 2) {
                    groupRoleIds.add(String.valueOf(groupId) + "-" + role.getRoleId());
                } else {
                    roleIds.add(role.getRoleId());
                }
            }
            ++i4;
        }
        doc.addKeyword("roleId", roleIds.toArray(new Long[roleIds.size()]));
        doc.addKeyword("groupRoleId", groupRoleIds.toArray(new String[groupRoleIds.size()]));
    }

    protected Query doGetPermissionQuery(long companyId, long[] groupIds, long userId, String className, Query query, SearchContext searchContext) throws Exception {
        Indexer indexer = IndexerRegistryUtil.getIndexer((String)className);
        if (!indexer.isPermissionAware()) {
            return query;
        }
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        AdvancedPermissionChecker advancedPermissionChecker = null;
        if (permissionChecker != null && permissionChecker instanceof AdvancedPermissionChecker) {
            advancedPermissionChecker = (AdvancedPermissionChecker)permissionChecker;
        }
        if (advancedPermissionChecker == null) {
            return query;
        }
        PermissionCheckerBag permissionCheckerBag = this.getPermissionCheckerBag(advancedPermissionChecker, userId);
        if (permissionCheckerBag == null) {
            return query;
        }
        UniqueList groups = new UniqueList();
        UniqueList roles = new UniqueList();
        Object userGroupRoles = new UniqueList();
        HashMap<Long, List<Role>> groupIdsToRoles = new HashMap<Long, List<Role>>();
        roles.addAll(permissionCheckerBag.getRoles());
        if (ArrayUtil.isEmpty((long[])groupIds)) {
            groups.addAll(GroupLocalServiceUtil.getUserGroups((long)userId, (boolean)true));
            groups.addAll(permissionCheckerBag.getGroups());
            userGroupRoles = UserGroupRoleLocalServiceUtil.getUserGroupRoles((long)userId);
        } else {
            groups.addAll(permissionCheckerBag.getGroups());
            long[] lArray = groupIds;
            int n = groupIds.length;
            int n2 = 0;
            while (n2 < n) {
                long groupId = lArray[n2];
                if (GroupLocalServiceUtil.hasUserGroup((long)userId, (long)groupId)) {
                    Group group = GroupLocalServiceUtil.getGroup((long)groupId);
                    groups.add(group);
                }
                userGroupRoles.addAll(UserGroupRoleLocalServiceUtil.getUserGroupRoles((long)userId, (long)groupId));
                userGroupRoles.addAll(UserGroupRoleLocalServiceUtil.getUserGroupRolesByUserUserGroupAndGroup((long)userId, (long)groupId));
                ++n2;
            }
        }
        if (advancedPermissionChecker.isSignedIn()) {
            roles.add(RoleLocalServiceUtil.getRole((long)companyId, (String)"Guest"));
        }
        for (Group group : groups) {
            PermissionCheckerBag userBag = advancedPermissionChecker.getUserBag(userId, group.getGroupId());
            List groupRoles = userBag.getRoles();
            groupIdsToRoles.put(group.getGroupId(), groupRoles);
            roles.addAll(groupRoles);
        }
        return this.doGetPermissionQuery_6(companyId, groupIds, userId, className, query, searchContext, advancedPermissionChecker, (List<Group>)groups, (List<Role>)roles, (List<UserGroupRole>)userGroupRoles, groupIdsToRoles);
    }

    protected Query doGetPermissionQuery_6(long companyId, long[] groupIds, long userId, String className, Query query, SearchContext searchContext, AdvancedPermissionChecker advancedPermissionChecker, List<Group> groups, List<Role> roles, List<UserGroupRole> userGroupRoles, Map<Long, List<Role>> groupIdsToRoles) throws Exception {
        BooleanQuery permissionQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
        if (userId > 0L) {
            permissionQuery.addTerm("userId", userId);
        }
        BooleanQuery groupsQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
        BooleanQuery rolesQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
        for (Role role : roles) {
            String roleName = role.getName();
            if (roleName.equals("Administrator")) {
                return query;
            }
            if (ResourcePermissionLocalServiceUtil.hasResourcePermission((long)companyId, (String)className, (int)1, (String)String.valueOf(companyId), (long)role.getRoleId(), (String)"VIEW")) {
                return query;
            }
            if (role.getType() == 1 && ResourcePermissionLocalServiceUtil.hasResourcePermission((long)companyId, (String)className, (int)3, (String)String.valueOf(0L), (long)role.getRoleId(), (String)"VIEW")) {
                return query;
            }
            for (Group group : groups) {
                List<Role> groupRoles;
                if (ResourcePermissionLocalServiceUtil.hasResourcePermission((long)companyId, (String)className, (int)2, (String)String.valueOf(group.getGroupId()), (long)role.getRoleId(), (String)"VIEW")) {
                    groupsQuery.addTerm("groupId", group.getGroupId());
                }
                if (role.getType() != 1 && ResourcePermissionLocalServiceUtil.hasResourcePermission((long)companyId, (String)className, (int)3, (String)String.valueOf(0L), (long)role.getRoleId(), (String)"VIEW") && (groupRoles = groupIdsToRoles.get(group.getGroupId())).contains(role)) {
                    groupsQuery.addTerm("groupId", group.getGroupId());
                }
                if (!group.isSite() || role.getName().equals("Site Member") || role.getType() != 2) continue;
                rolesQuery.addTerm("groupRoleId", String.valueOf(group.getGroupId()) + "-" + role.getRoleId());
            }
            rolesQuery.addTerm("roleId", role.getRoleId());
        }
        for (Group group : groups) {
            this.addRequiredMemberRole(group, rolesQuery);
        }
        for (UserGroupRole userGroupRole : userGroupRoles) {
            rolesQuery.addTerm("groupRoleId", String.valueOf(userGroupRole.getGroupId()) + "-" + userGroupRole.getRoleId());
        }
        if (groupsQuery.hasClauses()) {
            permissionQuery.add((Query)groupsQuery, BooleanClauseOccur.SHOULD);
        }
        if (rolesQuery.hasClauses()) {
            permissionQuery.add((Query)rolesQuery, BooleanClauseOccur.SHOULD);
        }
        BooleanQuery fullQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
        fullQuery.add(query, BooleanClauseOccur.MUST);
        fullQuery.add((Query)permissionQuery, BooleanClauseOccur.MUST);
        return fullQuery;
    }

    protected void doUpdatePermissionFields(String resourceName, String resourceClassPK) throws Exception {
        Indexer indexer = IndexerRegistryUtil.getIndexer((String)resourceName);
        if (indexer != null) {
            indexer.reindex(resourceName, GetterUtil.getLong((String)resourceClassPK));
        }
    }

    protected PermissionCheckerBag getPermissionCheckerBag(AdvancedPermissionChecker advancedPermissionChecker, long userId) throws Exception {
        if (!advancedPermissionChecker.isSignedIn()) {
            return advancedPermissionChecker.getGuestUserBag();
        }
        return advancedPermissionChecker.getUserBag(userId, 0L);
    }
}

