/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scripting.javascript;

import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.SingleVMPoolUtil;
import com.liferay.portal.kernel.scripting.BaseScriptingExecutor;
import com.liferay.portal.kernel.scripting.ScriptingException;
import com.liferay.portal.kernel.util.AggregateClassLoader;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.scripting.javascript.JavaScriptClassVisibilityChecker;
import com.liferay.portal.util.ClassLoaderUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.mozilla.javascript.ClassShutter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JavaScriptExecutor
extends BaseScriptingExecutor {
    private static final String _CACHE_NAME = JavaScriptExecutor.class.getName();
    private static final String _LANGUAGE = "javascript";
    private PortalCache<String, Script> _portalCache = SingleVMPoolUtil.getCache((String)_CACHE_NAME);

    public void clearCache() {
        this._portalCache.removeAll();
    }

    public Map<String, Object> eval(Set<String> allowedClasses, Map<String, Object> inputObjects, Set<String> outputNames, String script, ClassLoader ... classLoaders) throws ScriptingException {
        Script compiledScript = this.getCompiledScript(script, classLoaders);
        try {
            Context context = Context.enter();
            ScriptableObject scriptable = context.initStandardObjects();
            if (ArrayUtil.isNotEmpty((Object[])classLoaders)) {
                ClassLoader aggregateClassLoader = AggregateClassLoader.getAggregateClassLoader((ClassLoader)ClassLoaderUtil.getPortalClassLoader(), (ClassLoader[])classLoaders);
                context.setApplicationClassLoader(aggregateClassLoader);
            }
            for (Map.Entry<String, Object> entry : inputObjects.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                ScriptableObject.putProperty((Scriptable)scriptable, (String)key, (Object)Context.javaToJS((Object)value, (Scriptable)scriptable));
            }
            if (allowedClasses != null) {
                context.setClassShutter((ClassShutter)new JavaScriptClassVisibilityChecker(allowedClasses));
            }
            compiledScript.exec(context, (Scriptable)scriptable);
            if (outputNames == null) {
                return null;
            }
            HashMap<String, Object> outputObjects = new HashMap<String, Object>();
            for (String outputName : outputNames) {
                outputObjects.put(outputName, ScriptableObject.getProperty((Scriptable)scriptable, (String)outputName));
            }
            HashMap<String, Object> hashMap = outputObjects;
            return hashMap;
        }
        catch (Exception e2) {
            throw new ScriptingException(String.valueOf(e2.getMessage()) + "\n\n", (Throwable)e2);
        }
        finally {
            Context.exit();
        }
    }

    public String getLanguage() {
        return _LANGUAGE;
    }

    protected Script getCompiledScript(String script, ClassLoader ... classLoaders) {
        String key = String.valueOf(script.hashCode());
        Script compiledScript = (Script)this._portalCache.get((Serializable)((Object)key));
        if (compiledScript != null) {
            return compiledScript;
        }
        try {
            Context context = Context.enter();
            if (ArrayUtil.isNotEmpty((Object[])classLoaders)) {
                ClassLoader aggregateClassLoader = AggregateClassLoader.getAggregateClassLoader((ClassLoader)ClassLoaderUtil.getPortalClassLoader(), (ClassLoader[])classLoaders);
                context.setApplicationClassLoader(aggregateClassLoader);
            }
            compiledScript = context.compileString(script, "script", 0, null);
        }
        finally {
            Context.exit();
        }
        this._portalCache.put((Serializable)((Object)key), (Object)compiledScript);
        return compiledScript;
    }
}

