/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scheduler;

import com.liferay.portal.cluster.ClusterableContextThreadLocal;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.bean.IdentifiableBean;
import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.cluster.AddressSerializerUtil;
import com.liferay.portal.kernel.cluster.BaseClusterResponseCallback;
import com.liferay.portal.kernel.cluster.ClusterEvent;
import com.liferay.portal.kernel.cluster.ClusterEventListener;
import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterInvokeAcceptor;
import com.liferay.portal.kernel.cluster.ClusterInvokeThreadLocal;
import com.liferay.portal.kernel.cluster.ClusterNodeResponse;
import com.liferay.portal.kernel.cluster.ClusterNodeResponses;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.cluster.ClusterResponseCallback;
import com.liferay.portal.kernel.cluster.Clusterable;
import com.liferay.portal.kernel.cluster.FutureClusterResponses;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.proxy.ProxyModeThreadLocal;
import com.liferay.portal.kernel.scheduler.SchedulerEngine;
import com.liferay.portal.kernel.scheduler.SchedulerEngineClusterManager;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelperUtil;
import com.liferay.portal.kernel.scheduler.SchedulerException;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerFactoryUtil;
import com.liferay.portal.kernel.scheduler.TriggerState;
import com.liferay.portal.kernel.scheduler.TriggerType;
import com.liferay.portal.kernel.scheduler.messaging.SchedulerResponse;
import com.liferay.portal.kernel.servlet.PluginContextLifecycleThreadLocal;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.model.Lock;
import com.liferay.portal.service.LockLocalServiceUtil;
import com.liferay.portal.util.PropsValues;
import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ClusterSchedulerEngine
implements IdentifiableBean,
SchedulerEngine,
SchedulerEngineClusterManager {
    @BeanReference(name="com.liferay.portal.scheduler.ClusterSchedulerEngineService")
    protected SchedulerEngine schedulerEngine;
    private static final String _LOCK_CLASS_NAME = SchedulerEngine.class.getName();
    private static final String _PLUGIN_READY = "plugin.ready";
    private static final String _PORTAL_READY = "portal.ready";
    private static Log _log = LogFactoryUtil.getLog(ClusterSchedulerEngine.class);
    private static MethodKey _getScheduledJobMethodKey = new MethodKey(SchedulerEngineHelperUtil.class, "getScheduledJob", new Class[]{String.class, String.class, StorageType.class});
    private static MethodKey _getScheduledJobsMethodKey1 = new MethodKey(SchedulerEngineHelperUtil.class, "getScheduledJobs", new Class[0]);
    private static MethodKey _getScheduledJobsMethodKey2 = new MethodKey(SchedulerEngineHelperUtil.class, "getScheduledJobs", new Class[]{String.class, StorageType.class});
    private static MethodKey _getScheduledJobsMethodKey3 = new MethodKey(SchedulerEngineHelperUtil.class, "getScheduledJobs", new Class[]{StorageType.class});
    private String _beanIdentifier;
    private ClusterEventListener _clusterEventListener;
    private volatile String _localClusterNodeAddress;
    private volatile boolean _master;
    private Map<String, ObjectValuePair<SchedulerResponse, TriggerState>> _memoryClusteredJobs = new ConcurrentHashMap<String, ObjectValuePair<SchedulerResponse, TriggerState>>();
    private boolean _portalReady;
    private java.util.concurrent.locks.Lock _readLock;
    private SchedulerEngine _schedulerEngine;
    private java.util.concurrent.locks.Lock _writeLock;

    public static SchedulerEngine createClusterSchedulerEngine(SchedulerEngine schedulerEngine) {
        if (PropsValues.CLUSTER_LINK_ENABLED && PropsValues.SCHEDULER_ENABLED) {
            schedulerEngine = new ClusterSchedulerEngine(schedulerEngine);
        }
        return schedulerEngine;
    }

    public ClusterSchedulerEngine(SchedulerEngine schedulerEngine) {
        this._schedulerEngine = schedulerEngine;
    }

    @Clusterable(acceptor=SchedulerClusterInvokeAcceptor.class)
    public void delete(String groupName) throws SchedulerException {
        boolean memoryClusteredSlaveJob = this.isMemoryClusteredSlaveJob(groupName);
        this._readLock.lock();
        try {
            if (memoryClusteredSlaveJob) {
                this.removeMemoryClusteredJobs(groupName);
            } else {
                this._schedulerEngine.delete(groupName);
            }
        }
        finally {
            this._readLock.unlock();
        }
        this.setClusterableThreadLocal(groupName);
    }

    @Clusterable(acceptor=SchedulerClusterInvokeAcceptor.class)
    public void delete(String jobName, String groupName) throws SchedulerException {
        boolean memoryClusteredSlaveJob = this.isMemoryClusteredSlaveJob(groupName);
        this._readLock.lock();
        try {
            if (memoryClusteredSlaveJob) {
                this._memoryClusteredJobs.remove(this.getFullName(jobName, groupName));
            } else {
                this._schedulerEngine.delete(jobName, groupName);
            }
        }
        finally {
            this._readLock.unlock();
        }
        this.setClusterableThreadLocal(groupName);
    }

    public String getBeanIdentifier() {
        return this._beanIdentifier;
    }

    public SchedulerResponse getScheduledJob(String jobName, String groupName) throws SchedulerException {
        String masterAddressString;
        ObjectValuePair<String, StorageType> objectValuePair = this.resolveGroupName(groupName);
        StorageType storageType = (StorageType)objectValuePair.getValue();
        if (storageType.equals((Object)StorageType.MEMORY_CLUSTERED) && !this._localClusterNodeAddress.equals(masterAddressString = this.getMasterAddressString(false))) {
            return (SchedulerResponse)this.callMaster(masterAddressString, _getScheduledJobMethodKey, jobName, objectValuePair.getKey(), storageType);
        }
        this._readLock.lock();
        try {
            SchedulerResponse schedulerResponse = this._schedulerEngine.getScheduledJob(jobName, groupName);
            return schedulerResponse;
        }
        finally {
            this._readLock.unlock();
        }
    }

    public List<SchedulerResponse> getScheduledJobs() throws SchedulerException {
        String masterAddressString = this.getMasterAddressString(false);
        if (!this._localClusterNodeAddress.equals(masterAddressString)) {
            return (List)this.callMaster(masterAddressString, _getScheduledJobsMethodKey1, new Object[0]);
        }
        this._readLock.lock();
        try {
            List list = this._schedulerEngine.getScheduledJobs();
            return list;
        }
        finally {
            this._readLock.unlock();
        }
    }

    public List<SchedulerResponse> getScheduledJobs(String groupName) throws SchedulerException {
        String masterAddressString;
        ObjectValuePair<String, StorageType> objectValuePair = this.resolveGroupName(groupName);
        StorageType storageType = (StorageType)objectValuePair.getValue();
        if (storageType.equals((Object)StorageType.MEMORY_CLUSTERED) && !this._localClusterNodeAddress.equals(masterAddressString = this.getMasterAddressString(false))) {
            return (List)this.callMaster(masterAddressString, _getScheduledJobsMethodKey2, objectValuePair.getKey(), storageType);
        }
        this._readLock.lock();
        try {
            List list = this._schedulerEngine.getScheduledJobs(groupName);
            return list;
        }
        finally {
            this._readLock.unlock();
        }
    }

    public void initialize() throws SchedulerException {
        try {
            ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
            this._readLock = readWriteLock.readLock();
            this._writeLock = readWriteLock.writeLock();
            this._localClusterNodeAddress = AddressSerializerUtil.serialize((Address)ClusterExecutorUtil.getLocalClusterNodeAddress());
            this._clusterEventListener = new MemorySchedulerClusterEventListener();
            ClusterExecutorUtil.addClusterEventListener((ClusterEventListener)this._clusterEventListener);
            String masterAddressString = this.getMasterAddressString(false);
            if (!this._localClusterNodeAddress.equals(masterAddressString)) {
                List schedulerResponses = (List)this.callMaster(masterAddressString, _getScheduledJobsMethodKey3, StorageType.MEMORY_CLUSTERED);
                this.initMemoryClusteredJobs(schedulerResponses);
            }
        }
        catch (Exception e2) {
            throw new SchedulerException("Unable to initialize scheduler", (Throwable)e2);
        }
    }

    @Clusterable(acceptor=SchedulerClusterInvokeAcceptor.class)
    public void pause(String groupName) throws SchedulerException {
        boolean memoryClusteredSlaveJob = this.isMemoryClusteredSlaveJob(groupName);
        this._readLock.lock();
        try {
            if (memoryClusteredSlaveJob) {
                this.updateMemoryClusteredJobs(groupName, TriggerState.PAUSED);
            } else {
                this._schedulerEngine.pause(groupName);
            }
        }
        finally {
            this._readLock.unlock();
        }
        this.setClusterableThreadLocal(groupName);
    }

    @Clusterable(acceptor=SchedulerClusterInvokeAcceptor.class)
    public void pause(String jobName, String groupName) throws SchedulerException {
        boolean memoryClusteredSlaveJob = this.isMemoryClusteredSlaveJob(groupName);
        this._readLock.lock();
        try {
            if (memoryClusteredSlaveJob) {
                this.updateMemoryClusteredJob(jobName, groupName, TriggerState.PAUSED);
            } else {
                this._schedulerEngine.pause(jobName, groupName);
            }
        }
        finally {
            this._readLock.unlock();
        }
        this.setClusterableThreadLocal(groupName);
    }

    @Clusterable(acceptor=SchedulerClusterInvokeAcceptor.class)
    public void resume(String groupName) throws SchedulerException {
        boolean memoryClusteredSlaveJob = this.isMemoryClusteredSlaveJob(groupName);
        this._readLock.lock();
        try {
            if (memoryClusteredSlaveJob) {
                this.updateMemoryClusteredJobs(groupName, TriggerState.NORMAL);
            } else {
                this._schedulerEngine.resume(groupName);
            }
        }
        finally {
            this._readLock.unlock();
        }
        this.setClusterableThreadLocal(groupName);
    }

    @Clusterable(acceptor=SchedulerClusterInvokeAcceptor.class)
    public void resume(String jobName, String groupName) throws SchedulerException {
        boolean memoryClusteredSlaveJob = this.isMemoryClusteredSlaveJob(groupName);
        this._readLock.lock();
        try {
            if (memoryClusteredSlaveJob) {
                this.updateMemoryClusteredJob(jobName, groupName, TriggerState.NORMAL);
            } else {
                this._schedulerEngine.resume(jobName, groupName);
            }
        }
        finally {
            this._readLock.unlock();
        }
        this.setClusterableThreadLocal(groupName);
    }

    @Clusterable(acceptor=SchedulerClusterInvokeAcceptor.class)
    public void schedule(Trigger trigger, String description, String destinationName, Message message) throws SchedulerException {
        String groupName = trigger.getGroupName();
        String jobName = trigger.getJobName();
        boolean memoryClusteredSlaveJob = this.isMemoryClusteredSlaveJob(groupName);
        this._readLock.lock();
        try {
            if (memoryClusteredSlaveJob) {
                SchedulerResponse schedulerResponse = new SchedulerResponse();
                schedulerResponse.setDescription(description);
                schedulerResponse.setDestinationName(destinationName);
                schedulerResponse.setGroupName(groupName);
                schedulerResponse.setJobName(jobName);
                schedulerResponse.setMessage(message);
                schedulerResponse.setTrigger(trigger);
                this._memoryClusteredJobs.put(this.getFullName(jobName, groupName), (ObjectValuePair<SchedulerResponse, TriggerState>)new ObjectValuePair((Object)schedulerResponse, (Object)TriggerState.NORMAL));
            } else {
                this._schedulerEngine.schedule(trigger, description, destinationName, message);
            }
        }
        finally {
            this._readLock.unlock();
        }
        this.setClusterableThreadLocal(groupName);
    }

    public void setBeanIdentifier(String beanIdentifier) {
        this._beanIdentifier = beanIdentifier;
    }

    public void shutdown() throws SchedulerException {
        this._portalReady = false;
        try {
            ClusterExecutorUtil.removeClusterEventListener((ClusterEventListener)this._clusterEventListener);
            LockLocalServiceUtil.unlock((String)_LOCK_CLASS_NAME, (String)_LOCK_CLASS_NAME, (String)this._localClusterNodeAddress);
        }
        catch (Exception e2) {
            throw new SchedulerException("Unable to shutdown scheduler", (Throwable)e2);
        }
        this._schedulerEngine.shutdown();
    }

    public void start() throws SchedulerException {
        this._schedulerEngine.start();
        this._portalReady = true;
    }

    @Clusterable(acceptor=SchedulerClusterInvokeAcceptor.class)
    public void suppressError(String jobName, String groupName) throws SchedulerException {
        boolean memoryClusteredSlaveJob = this.isMemoryClusteredSlaveJob(groupName);
        if (!memoryClusteredSlaveJob) {
            this._readLock.lock();
            try {
                this._schedulerEngine.suppressError(jobName, groupName);
            }
            finally {
                this._readLock.unlock();
            }
        }
        this.setClusterableThreadLocal(groupName);
    }

    @Clusterable(acceptor=SchedulerClusterInvokeAcceptor.class)
    public void unschedule(String groupName) throws SchedulerException {
        boolean memoryClusteredSlaveJob = this.isMemoryClusteredSlaveJob(groupName);
        this._readLock.lock();
        try {
            if (memoryClusteredSlaveJob) {
                this.removeMemoryClusteredJobs(groupName);
            } else {
                this._schedulerEngine.unschedule(groupName);
            }
        }
        finally {
            this._readLock.unlock();
        }
        this.setClusterableThreadLocal(groupName);
    }

    @Clusterable(acceptor=SchedulerClusterInvokeAcceptor.class)
    public void unschedule(String jobName, String groupName) throws SchedulerException {
        boolean memoryClusteredSlaveJob = this.isMemoryClusteredSlaveJob(groupName);
        this._readLock.lock();
        try {
            if (memoryClusteredSlaveJob) {
                this._memoryClusteredJobs.remove(this.getFullName(jobName, groupName));
            } else {
                this._schedulerEngine.unschedule(jobName, groupName);
            }
        }
        finally {
            this._readLock.unlock();
        }
        this.setClusterableThreadLocal(groupName);
    }

    @Clusterable(acceptor=SchedulerClusterInvokeAcceptor.class)
    public void update(Trigger trigger) throws SchedulerException {
        String jobName = trigger.getJobName();
        String groupName = trigger.getGroupName();
        boolean memoryClusteredSlaveJob = this.isMemoryClusteredSlaveJob(groupName);
        this._readLock.lock();
        try {
            if (memoryClusteredSlaveJob) {
                boolean updated = false;
                for (ObjectValuePair<SchedulerResponse, TriggerState> memoryClusteredJob : this._memoryClusteredJobs.values()) {
                    SchedulerResponse schedulerResponse = (SchedulerResponse)memoryClusteredJob.getKey();
                    if (!jobName.equals(schedulerResponse.getJobName()) || !groupName.equals(schedulerResponse.getGroupName())) continue;
                    schedulerResponse.setTrigger(trigger);
                    updated = true;
                    break;
                }
                if (!updated) {
                    throw new SchedulerException("Unable to update trigger for memory clustered job");
                }
            } else {
                this._schedulerEngine.update(trigger);
            }
        }
        finally {
            this._readLock.unlock();
        }
        this.setClusterableThreadLocal(groupName);
    }

    public Lock updateMemorySchedulerClusterMaster() throws SchedulerException {
        this.getMasterAddressString(false);
        return null;
    }

    protected <T> T callMaster(String masterAddressString, MethodKey methodKey, Object ... arguments) throws SchedulerException {
        MethodHandler methodHandler = new MethodHandler(methodKey, arguments);
        Address address = AddressSerializerUtil.deserialize((String)masterAddressString);
        ClusterRequest clusterRequest = ClusterRequest.createUnicastRequest((MethodHandler)methodHandler, (Address[])new Address[]{address});
        try {
            FutureClusterResponses futureClusterResponses = ClusterExecutorUtil.execute((ClusterRequest)clusterRequest);
            ClusterNodeResponses clusterNodeResponses = futureClusterResponses.get(20L, TimeUnit.SECONDS);
            ClusterNodeResponse clusterNodeResponse = clusterNodeResponses.getClusterResponse(address);
            return (T)clusterNodeResponse.getResult();
        }
        catch (Exception e2) {
            throw new SchedulerException("Unable to load scheduled jobs from cluster node " + address.getDescription(), (Throwable)e2);
        }
    }

    protected String getFullName(String jobName, String groupName) {
        return groupName.concat(".").concat(jobName);
    }

    protected String getMasterAddressString(boolean asynchronous) throws SchedulerException {
        String owner = null;
        while (true) {
            try {
                Lock lock;
                Address address;
                do {
                    lock = null;
                } while (!ClusterExecutorUtil.isClusterNodeAlive((Address)(address = AddressSerializerUtil.deserialize((String)(owner = (lock = owner == null ? LockLocalServiceUtil.lock((String)_LOCK_CLASS_NAME, (String)_LOCK_CLASS_NAME, (String)this._localClusterNodeAddress) : LockLocalServiceUtil.lock((String)_LOCK_CLASS_NAME, (String)_LOCK_CLASS_NAME, owner, (String)this._localClusterNodeAddress)).getOwner())))));
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)"Unable to obtain memory scheduler cluster lock. Trying again.");
                continue;
            }
            break;
        }
        boolean master = this._localClusterNodeAddress.equals(owner);
        if (master == this._master) {
            return owner;
        }
        if (master) {
            this.slaveToMaster();
        } else {
            this.masterToSlave(owner, asynchronous);
        }
        return owner;
    }

    protected void initMemoryClusteredJobs(List<SchedulerResponse> schedulerResponses) throws Exception {
        for (SchedulerResponse schedulerResponse : schedulerResponses) {
            Trigger oldTrigger = schedulerResponse.getTrigger();
            String jobName = schedulerResponse.getJobName();
            String groupName = SchedulerEngineHelperUtil.namespaceGroupName((String)schedulerResponse.getGroupName(), (StorageType)StorageType.MEMORY_CLUSTERED);
            Trigger newTrigger = TriggerFactoryUtil.buildTrigger((TriggerType)oldTrigger.getTriggerType(), (String)jobName, (String)groupName, (Date)oldTrigger.getStartDate(), (Date)oldTrigger.getEndDate(), (Object)oldTrigger.getTriggerContent());
            schedulerResponse.setTrigger(newTrigger);
            TriggerState triggerState = SchedulerEngineHelperUtil.getJobState((SchedulerResponse)schedulerResponse);
            Message message = schedulerResponse.getMessage();
            message.remove("JOB_STATE");
            this._memoryClusteredJobs.put(this.getFullName(jobName, groupName), (ObjectValuePair<SchedulerResponse, TriggerState>)new ObjectValuePair((Object)schedulerResponse, (Object)triggerState));
        }
    }

    protected boolean isMemoryClusteredSlaveJob(String groupName) throws SchedulerException {
        ObjectValuePair<String, StorageType> objectValuePair = this.resolveGroupName(groupName);
        StorageType storageType = (StorageType)objectValuePair.getValue();
        if (!storageType.equals((Object)StorageType.MEMORY_CLUSTERED)) {
            return false;
        }
        String masterAddressString = this.getMasterAddressString(false);
        return !this._localClusterNodeAddress.equals(masterAddressString);
    }

    protected void masterToSlave(String masterAddressString, boolean asynchronous) throws SchedulerException {
        if (asynchronous) {
            MethodHandler methodHandler = new MethodHandler(_getScheduledJobsMethodKey3, new Object[]{StorageType.MEMORY_CLUSTERED});
            Address address = AddressSerializerUtil.deserialize((String)masterAddressString);
            ClusterRequest clusterRequest = ClusterRequest.createUnicastRequest((MethodHandler)methodHandler, (Address[])new Address[]{address});
            try {
                ClusterExecutorUtil.execute((ClusterRequest)clusterRequest, (ClusterResponseCallback)new MemorySchedulerClusterResponseCallback(address), (long)20L, (TimeUnit)TimeUnit.SECONDS);
                return;
            }
            catch (Exception e2) {
                throw new SchedulerException("Unable to load scheduled jobs from cluster node " + address.getDescription(), (Throwable)e2);
            }
        }
        List schedulerResponses = (List)this.callMaster(masterAddressString, _getScheduledJobsMethodKey3, StorageType.MEMORY_CLUSTERED);
        this._doMasterToSlave(schedulerResponses);
    }

    protected void removeMemoryClusteredJobs(String groupName) {
        Set<Map.Entry<String, ObjectValuePair<SchedulerResponse, TriggerState>>> memoryClusteredJobs = this._memoryClusteredJobs.entrySet();
        Iterator<Map.Entry<String, ObjectValuePair<SchedulerResponse, TriggerState>>> itr = memoryClusteredJobs.iterator();
        while (itr.hasNext()) {
            Map.Entry<String, ObjectValuePair<SchedulerResponse, TriggerState>> entry = itr.next();
            ObjectValuePair<SchedulerResponse, TriggerState> memoryClusteredJob = entry.getValue();
            SchedulerResponse schedulerResponse = (SchedulerResponse)memoryClusteredJob.getKey();
            if (!groupName.equals(schedulerResponse.getGroupName())) continue;
            itr.remove();
        }
    }

    protected ObjectValuePair<String, StorageType> resolveGroupName(String groupName) {
        int index = groupName.indexOf(35);
        String storageTypeString = groupName.substring(0, index);
        StorageType storageType = StorageType.valueOf((String)storageTypeString);
        String orginalGroupName = groupName.substring(index + 1);
        return new ObjectValuePair((Object)orginalGroupName, (Object)storageType);
    }

    protected void setClusterableThreadLocal(String groupName) {
        ObjectValuePair<String, StorageType> objectValuePair = this.resolveGroupName(groupName);
        ClusterableContextThreadLocal.putThreadLocalContext("STORAGE_TYPE", (Serializable)objectValuePair.getValue());
        ClusterableContextThreadLocal.putThreadLocalContext(_PORTAL_READY, Boolean.valueOf(this._portalReady));
        boolean pluginReady = true;
        if (PluginContextLifecycleThreadLocal.isInitializing() || PluginContextLifecycleThreadLocal.isDestroying()) {
            pluginReady = false;
        }
        ClusterableContextThreadLocal.putThreadLocalContext(_PLUGIN_READY, Boolean.valueOf(pluginReady));
    }

    protected void slaveToMaster() throws SchedulerException {
        boolean forceSync = ProxyModeThreadLocal.isForceSync();
        ProxyModeThreadLocal.setForceSync((boolean)true);
        this._writeLock.lock();
        try {
            for (ObjectValuePair<SchedulerResponse, TriggerState> memoryClusteredJob : this._memoryClusteredJobs.values()) {
                SchedulerResponse schedulerResponse = (SchedulerResponse)memoryClusteredJob.getKey();
                this._schedulerEngine.schedule(schedulerResponse.getTrigger(), schedulerResponse.getDescription(), schedulerResponse.getDestinationName(), schedulerResponse.getMessage());
                TriggerState triggerState = (TriggerState)memoryClusteredJob.getValue();
                if (!triggerState.equals((Object)TriggerState.PAUSED)) continue;
                this._schedulerEngine.pause(schedulerResponse.getJobName(), schedulerResponse.getGroupName());
            }
            this._memoryClusteredJobs.clear();
        }
        finally {
            ProxyModeThreadLocal.setForceSync((boolean)forceSync);
            this._master = true;
            this._writeLock.unlock();
        }
    }

    protected void updateMemoryClusteredJob(String jobName, String groupName, TriggerState triggerState) {
        ObjectValuePair<SchedulerResponse, TriggerState> memoryClusteredJob = this._memoryClusteredJobs.get(this.getFullName(jobName, groupName));
        if (memoryClusteredJob != null) {
            memoryClusteredJob.setValue((Object)triggerState);
        }
    }

    protected void updateMemoryClusteredJobs(String groupName, TriggerState triggerState) {
        for (ObjectValuePair<SchedulerResponse, TriggerState> memoryClusteredJob : this._memoryClusteredJobs.values()) {
            SchedulerResponse schedulerResponse = (SchedulerResponse)memoryClusteredJob.getKey();
            if (!groupName.equals(schedulerResponse.getGroupName())) continue;
            memoryClusteredJob.setValue((Object)triggerState);
        }
    }

    private void _doMasterToSlave(List<SchedulerResponse> schedulerResponses) throws SchedulerException {
        this._writeLock.lock();
        try {
            try {
                for (SchedulerResponse schedulerResponse : this._schedulerEngine.getScheduledJobs()) {
                    if (StorageType.MEMORY_CLUSTERED != schedulerResponse.getStorageType()) continue;
                    String groupName = StorageType.MEMORY_CLUSTERED.toString();
                    groupName = groupName.concat("#").concat(schedulerResponse.getGroupName());
                    this._schedulerEngine.delete(schedulerResponse.getJobName(), groupName);
                }
                this.initMemoryClusteredJobs(schedulerResponses);
                if (_log.isInfoEnabled()) {
                    _log.info((Object)"Switched current node from master to slave");
                }
            }
            catch (Exception e2) {
                throw new SchedulerException((Throwable)e2);
            }
        }
        finally {
            this._master = false;
            this._writeLock.unlock();
        }
    }

    private class MemorySchedulerClusterEventListener
    implements ClusterEventListener {
        private MemorySchedulerClusterEventListener() {
        }

        public void processClusterEvent(ClusterEvent clusterEvent) {
            try {
                ClusterSchedulerEngine.this.getMasterAddressString(true);
            }
            catch (Exception e2) {
                _log.error((Object)"Unable to update memory scheduler cluster lock", (Throwable)e2);
            }
        }
    }

    private class MemorySchedulerClusterResponseCallback
    extends BaseClusterResponseCallback {
        private Address _address;

        public MemorySchedulerClusterResponseCallback(Address address) {
            this._address = address;
        }

        public void callback(ClusterNodeResponses clusterNodeResponses) {
            try {
                ClusterNodeResponse clusterNodeResponse = clusterNodeResponses.getClusterResponse(this._address);
                List schedulerResponses = (List)clusterNodeResponse.getResult();
                ClusterSchedulerEngine.this._doMasterToSlave(schedulerResponses);
            }
            catch (Exception e2) {
                _log.error((Object)("Unable to load memory clustered jobs from cluster node " + this._address.getDescription()), (Throwable)e2);
            }
        }

        public void processTimeoutException(TimeoutException timeoutException) {
            _log.error((Object)("Unable to load memory clustered jobs from cluster node " + this._address.getDescription()), (Throwable)timeoutException);
        }
    }

    private static class SchedulerClusterInvokeAcceptor
    implements ClusterInvokeAcceptor {
        private SchedulerClusterInvokeAcceptor() {
        }

        public boolean accept(Map<String, Serializable> context) {
            if (ClusterInvokeThreadLocal.isEnabled()) {
                return true;
            }
            StorageType storageType = (StorageType)context.get("STORAGE_TYPE");
            boolean portalReady = (Boolean)context.get(ClusterSchedulerEngine._PORTAL_READY);
            boolean pluginReady = (Boolean)context.get(ClusterSchedulerEngine._PLUGIN_READY);
            return !storageType.equals((Object)StorageType.PERSISTED) && portalReady && pluginReady;
        }
    }
}

