/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.cmis.model;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.model.User;
import com.liferay.portal.repository.cmis.CMISRepository;
import com.liferay.portal.repository.cmis.model.CMISModel;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.CMISRepositoryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFolderLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.permission.DLFolderPermission;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Session;

public class CMISFolder
extends CMISModel
implements Folder {
    private static Log _log = LogFactoryUtil.getLog(CMISFolder.class);
    private org.apache.chemistry.opencmis.client.api.Folder _cmisFolder;
    private CMISRepository _cmisRepository;
    private long _folderId;
    private String _uuid;

    public CMISFolder(CMISRepository cmisRepository, String uuid, long folderId, org.apache.chemistry.opencmis.client.api.Folder cmisFolder) {
        this._cmisRepository = cmisRepository;
        this._uuid = uuid;
        this._folderId = folderId;
        this._cmisFolder = cmisFolder;
    }

    public Object clone() {
        CMISFolder cmisFolder = new CMISFolder(this._cmisRepository, this._uuid, this._folderId, this._cmisFolder);
        cmisFolder.setCompanyId(this.getCompanyId());
        cmisFolder.setFolderId(this.getFolderId());
        cmisFolder.setGroupId(this.getGroupId());
        try {
            cmisFolder.setParentFolder(this.getParentFolder());
        }
        catch (Exception exception) {}
        cmisFolder.setPrimaryKey(this.getPrimaryKey());
        return cmisFolder;
    }

    public boolean containsPermission(PermissionChecker permissionChecker, String actionId) throws SystemException {
        if (this._cmisFolder.isRootFolder() && (actionId.equals("DELETE") || actionId.equals("UPDATE"))) {
            try {
                Folder folder = DLAppLocalServiceUtil.getMountFolder((long)this.getRepositoryId());
                DLFolder dlFolder = DLFolderLocalServiceUtil.getFolder((long)folder.getFolderId());
                return DLFolderPermission.contains(permissionChecker, dlFolder, actionId);
            }
            catch (PortalException pe) {
                throw new SystemException((Throwable)pe);
            }
        }
        return this.containsPermission((CmisObject)this._cmisFolder, actionId);
    }

    public List<Long> getAncestorFolderIds() throws PortalException, SystemException {
        ArrayList<Long> folderIds = new ArrayList<Long>();
        CMISFolder folder = this;
        while (!folder.isRoot()) {
            folder = folder.getParentFolder();
            folderIds.add(folder.getFolderId());
        }
        return folderIds;
    }

    public List<Folder> getAncestors() throws PortalException, SystemException {
        ArrayList<Folder> folders = new ArrayList<Folder>();
        CMISFolder folder = this;
        while (!folder.isRoot()) {
            folder = folder.getParentFolder();
            folders.add(folder);
        }
        return folders;
    }

    public Map<String, Serializable> getAttributes() {
        return new HashMap<String, Serializable>();
    }

    @Override
    public long getCompanyId() {
        return this._cmisRepository.getCompanyId();
    }

    public Date getCreateDate() {
        GregorianCalendar calendar = this._cmisFolder.getCreationDate();
        if (calendar != null) {
            return calendar.getTime();
        }
        return new Date();
    }

    public long getFolderId() {
        return this._folderId;
    }

    public long getGroupId() {
        return this._cmisRepository.getGroupId();
    }

    public Date getLastPostDate() {
        return this.getModifiedDate();
    }

    public Object getModel() {
        return this._cmisFolder;
    }

    public Class<?> getModelClass() {
        return CMISFolder.class;
    }

    @Override
    public String getModelClassName() {
        return CMISFolder.class.getName();
    }

    public Date getModifiedDate() {
        GregorianCalendar calendar = this._cmisFolder.getLastModificationDate();
        if (calendar != null) {
            return calendar.getTime();
        }
        return new Date();
    }

    public String getName() {
        if (this._cmisFolder.isRootFolder()) {
            try {
                Folder folder = DLAppLocalServiceUtil.getMountFolder((long)this.getRepositoryId());
                return folder.getName();
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
            }
        }
        return this._cmisFolder.getName();
    }

    @Override
    public Folder getParentFolder() throws PortalException, SystemException {
        Folder parentFolder = null;
        try {
            parentFolder = super.getParentFolder();
            if (parentFolder != null) {
                return parentFolder;
            }
        }
        catch (Exception exception) {}
        if (this._cmisFolder.isRootFolder()) {
            Folder folder = DLAppLocalServiceUtil.getMountFolder((long)this.getRepositoryId());
            parentFolder = folder.getParentFolder();
        } else {
            String path = this._cmisFolder.getPath();
            if ((path = path.substring(0, path.lastIndexOf(47))).length() == 0) {
                path = "/";
            }
            Session session = (Session)CMISRepositoryLocalServiceUtil.getSession((long)this.getRepositoryId());
            CmisObject parentCmisFolder = session.getObjectByPath(path);
            parentFolder = CMISRepositoryLocalServiceUtil.toFolder((long)this.getRepositoryId(), (Object)parentCmisFolder);
        }
        this.setParentFolder(parentFolder);
        return parentFolder;
    }

    public long getParentFolderId() {
        try {
            Folder parentFolder = this.getParentFolder();
            if (parentFolder != null) {
                return parentFolder.getFolderId();
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        return 0L;
    }

    @Override
    public long getPrimaryKey() {
        return this._folderId;
    }

    public Serializable getPrimaryKeyObj() {
        return Long.valueOf(this.getPrimaryKey());
    }

    public long getRepositoryId() {
        return this._cmisRepository.getRepositoryId();
    }

    public StagedModelType getStagedModelType() {
        return new StagedModelType(Folder.class);
    }

    public long getUserId() {
        User user = this.getUser(this._cmisFolder.getCreatedBy());
        if (user == null) {
            return 0L;
        }
        return user.getUserId();
    }

    public String getUserName() {
        User user = this.getUser(this._cmisFolder.getCreatedBy());
        if (user == null) {
            return "";
        }
        return user.getFullName();
    }

    public String getUserUuid() {
        User user = this.getUser(this._cmisFolder.getCreatedBy());
        try {
            return user.getUserUuid();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getUuid() {
        return this._uuid;
    }

    public boolean hasInheritableLock() {
        return false;
    }

    public boolean hasLock() {
        return false;
    }

    public boolean isDefaultRepository() {
        return false;
    }

    public boolean isEscapedModel() {
        return false;
    }

    public boolean isLocked() {
        return false;
    }

    public boolean isMountPoint() {
        return false;
    }

    public boolean isRoot() {
        return this.getParentFolderId() == 0L;
    }

    public boolean isSupportsLocking() {
        return true;
    }

    public boolean isSupportsMetadata() {
        return false;
    }

    public boolean isSupportsMultipleUpload() {
        return false;
    }

    public boolean isSupportsShortcuts() {
        return false;
    }

    public boolean isSupportsSocial() {
        return false;
    }

    public boolean isSupportsSubscribing() {
        return false;
    }

    public void setCompanyId(long companyId) {
        this._cmisRepository.setCompanyId(companyId);
    }

    public void setCreateDate(Date date) {
    }

    public void setFolderId(long folderId) {
        this._folderId = folderId;
    }

    public void setGroupId(long groupId) {
        this._cmisRepository.setGroupId(groupId);
    }

    public void setModifiedDate(Date date) {
    }

    public void setPrimaryKey(long primaryKey) {
        this.setFolderId(primaryKey);
    }

    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        this.setPrimaryKey((Long)primaryKeyObj);
    }

    public void setUserId(long userId) {
    }

    public void setUserName(String userName) {
    }

    public void setUserUuid(String userUuid) {
    }

    public void setUuid(String uuid) {
    }

    public Folder toEscapedModel() {
        return this;
    }

    public Folder toUnescapedModel() {
        return this;
    }

    @Override
    protected CMISRepository getCmisRepository() {
        return this._cmisRepository;
    }
}

