/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.cmis;

import com.liferay.portal.NoSuchRepositoryEntryException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.RepositoryException;
import com.liferay.portal.kernel.repository.cmis.BaseCmisRepository;
import com.liferay.portal.kernel.repository.cmis.CMISRepositoryHandler;
import com.liferay.portal.kernel.repository.cmis.search.CMISSearchQueryBuilderUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.HitsImpl;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.servlet.PortalSessionThreadLocal;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TransientValue;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Lock;
import com.liferay.portal.model.RepositoryEntry;
import com.liferay.portal.repository.cmis.SessionImpl;
import com.liferay.portal.repository.cmis.model.CMISFileEntry;
import com.liferay.portal.repository.cmis.model.CMISFileVersion;
import com.liferay.portal.repository.cmis.model.CMISFolder;
import com.liferay.portal.repository.cmis.model.CMISModel;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.service.RepositoryEntryLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.persistence.RepositoryEntryUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.DuplicateFileException;
import com.liferay.portlet.documentlibrary.DuplicateFolderNameException;
import com.liferay.portlet.documentlibrary.FileNameException;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.NoSuchFileVersionException;
import com.liferay.portlet.documentlibrary.NoSuchFolderException;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.persistence.DLFolderUtil;
import com.liferay.portlet.documentlibrary.util.comparator.RepositoryModelCreateDateComparator;
import com.liferay.portlet.documentlibrary.util.comparator.RepositoryModelModifiedDateComparator;
import com.liferay.portlet.documentlibrary.util.comparator.RepositoryModelNameComparator;
import com.liferay.portlet.documentlibrary.util.comparator.RepositoryModelSizeComparator;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.FileableCmisObject;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.runtime.ObjectIdImpl;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.RepositoryCapabilities;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.CapabilityQuery;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.Base64;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;

public class CMISRepository
extends BaseCmisRepository {
    private static final int _DELETE_DEEP = -1;
    private static final int _DELETE_NONE = 0;
    private static Log _log = LogFactoryUtil.getLog(CMISRepository.class);
    private static ThreadLocal<Map<Long, List<FileEntry>>> _fileEntriesCache = new AutoResetThreadLocal(CMISRepository.class + "._fileEntriesCache", new HashMap());
    private static ThreadLocal<Map<Long, List<Object>>> _foldersAndFileEntriesCache = new AutoResetThreadLocal(CMISRepository.class + "._foldersAndFileEntriesCache", new HashMap());
    private static ThreadLocal<Map<Long, List<Folder>>> _foldersCache = new AutoResetThreadLocal(CMISRepository.class + "._foldersCache", new HashMap());
    private CMISRepositoryHandler _cmisRepositoryHandler;
    private String _sessionKey;

    public CMISRepository(CMISRepositoryHandler cmisRepositoryHandler) {
        this._cmisRepositoryHandler = cmisRepositoryHandler;
    }

    public FileEntry addFileEntry(long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, InputStream is, long size, ServiceContext serviceContext) throws PortalException, SystemException {
        if (Validator.isNull((String)title)) {
            if (size == 0L) {
                throw new FileNameException();
            }
            title = sourceFileName;
        }
        try {
            Session session = this.getSession();
            this.validateTitle(session, folderId, title);
            org.apache.chemistry.opencmis.client.api.Folder cmisFolder = this.getCmisFolder(session, folderId);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("cmis:name", title);
            properties.put("cmis:objectTypeId", BaseTypeId.CMIS_DOCUMENT.value());
            ContentStreamImpl contentStream = new ContentStreamImpl(title, BigInteger.valueOf(size), mimeType, is);
            return this.toFileEntry(cmisFolder.createDocument(properties, (ContentStream)contentStream, null));
        }
        catch (PortalException pe) {
            throw pe;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e2) {
            this.processException(e2);
            throw new RepositoryException((Throwable)e2);
        }
    }

    public Folder addFolder(long parentFolderId, String title, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            Session session = this.getSession();
            this.validateTitle(session, parentFolderId, title);
            org.apache.chemistry.opencmis.client.api.Folder cmisFolder = this.getCmisFolder(session, parentFolderId);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("cmis:name", title);
            properties.put("cmis:objectTypeId", BaseTypeId.CMIS_FOLDER.value());
            return this.toFolder(cmisFolder.createFolder(properties));
        }
        catch (PortalException pe) {
            throw pe;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e2) {
            this.processException(e2);
            throw new RepositoryException((Throwable)e2);
        }
    }

    public FileVersion cancelCheckOut(long fileEntryId) throws SystemException {
        Document draftDocument = null;
        try {
            Session session = this.getSession();
            String versionSeriesId = this.toFileEntryId(fileEntryId);
            Document document = (Document)session.getObject(versionSeriesId);
            document.refresh();
            String versionSeriesCheckedOutId = document.getVersionSeriesCheckedOutId();
            if (Validator.isNotNull((String)versionSeriesCheckedOutId)) {
                draftDocument = (Document)session.getObject(versionSeriesCheckedOutId);
                draftDocument.cancelCheckOut();
                document = (Document)session.getObject(versionSeriesId);
                document.refresh();
            }
        }
        catch (Exception e2) {
            _log.error((Object)("Unable to cancel checkout for file entry with {fileEntryId=" + fileEntryId + "}"), (Throwable)e2);
        }
        if (draftDocument != null) {
            return this.toFileVersion(draftDocument);
        }
        return null;
    }

    public void checkInFileEntry(long fileEntryId, boolean major, String changeLog, ServiceContext serviceContext) {
        try {
            this.clearManualCheckInRequired(fileEntryId, serviceContext);
            Session session = this.getSession();
            String versionSeriesId = this.toFileEntryId(fileEntryId);
            Document document = (Document)session.getObject(versionSeriesId);
            document.refresh();
            String versionSeriesCheckedOutId = document.getVersionSeriesCheckedOutId();
            if (Validator.isNotNull((String)versionSeriesCheckedOutId)) {
                if (!this.isSupportsMinorVersions()) {
                    major = true;
                }
                document = (Document)session.getObject(versionSeriesCheckedOutId);
                document.checkIn(major, null, null, changeLog);
                document = (Document)session.getObject(versionSeriesId);
                document.refresh();
            }
        }
        catch (Exception e2) {
            _log.error((Object)("Unable to check in file entry with {fileEntryId=" + fileEntryId + "}"), (Throwable)e2);
        }
    }

    public void checkInFileEntry(long fileEntryId, String lockUuid, ServiceContext serviceContext) {
        this.checkInFileEntry(fileEntryId, false, "", serviceContext);
    }

    public FileEntry checkOutFileEntry(long fileEntryId, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            this.setManualCheckInRequired(fileEntryId, serviceContext);
            Session session = this.getSession();
            String versionSeriesId = this.toFileEntryId(fileEntryId);
            Document document = (Document)session.getObject(versionSeriesId);
            document.refresh();
            document.checkOut();
            document = (Document)session.getObject(versionSeriesId);
            document.refresh();
        }
        catch (Exception e2) {
            _log.error((Object)("Unable checkout file entry with {fileEntryId=" + fileEntryId + "}"), (Throwable)e2);
        }
        return this.getFileEntry(fileEntryId);
    }

    public FileEntry checkOutFileEntry(long fileEntryId, String owner, long expirationTime, ServiceContext serviceContext) {
        throw new UnsupportedOperationException();
    }

    public FileEntry copyFileEntry(long groupId, long fileEntryId, long destFolderId, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            Session session = this.getSession();
            Document document = this.getDocument(session, fileEntryId);
            this.validateTitle(session, destFolderId, document.getName());
            String destFolderObjectId = this.toFolderId(session, destFolderId);
            Document newDocument = document.copy((ObjectId)new ObjectIdImpl(destFolderObjectId));
            return this.toFileEntry(newDocument);
        }
        catch (CmisObjectNotFoundException confe) {
            throw new NoSuchFolderException("No CMIS folder with {folderId=" + destFolderId + "}", (Throwable)confe);
        }
        catch (PortalException pe) {
            throw pe;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e2) {
            this.processException(e2);
            throw new RepositoryException((Throwable)e2);
        }
    }

    public void deleteFileEntry(long fileEntryId) throws PortalException, SystemException {
        try {
            Session session = this.getSession();
            Document document = this.getDocument(session, fileEntryId);
            this.deleteMappedFileEntry(document);
            document.deleteAllVersions();
        }
        catch (PortalException pe) {
            throw pe;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e2) {
            this.processException(e2);
            throw new RepositoryException((Throwable)e2);
        }
    }

    public void deleteFolder(long folderId) throws PortalException, SystemException {
        try {
            Session session = this.getSession();
            org.apache.chemistry.opencmis.client.api.Folder cmisFolder = this.getCmisFolder(session, folderId);
            this.deleteMappedFolder(cmisFolder);
            cmisFolder.deleteTree(true, UnfileObject.DELETE, false);
        }
        catch (PortalException pe) {
            throw pe;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e2) {
            this.processException(e2);
            throw new RepositoryException((Throwable)e2);
        }
    }

    public List<FileEntry> getFileEntries(long folderId, int start, int end, OrderByComparator obc) throws SystemException {
        List<FileEntry> fileEntries = this.getFileEntries(folderId);
        return this.subList(fileEntries, start, end, obc);
    }

    public List<FileEntry> getFileEntries(long folderId, long fileEntryTypeId, int start, int end, OrderByComparator obc) {
        return new ArrayList<FileEntry>();
    }

    public List<FileEntry> getFileEntries(long folderId, String[] mimeTypes, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        Map<Long, List<FileEntry>> fileEntriesCache = _fileEntriesCache.get();
        List<FileEntry> fileEntries = fileEntriesCache.get(folderId);
        if (fileEntries == null || mimeTypes != null) {
            fileEntries = new ArrayList<FileEntry>();
            List<String> documentIds = this.getDocumentIds(this.getSession(), folderId, mimeTypes);
            for (String documentId : documentIds) {
                FileEntry fileEntry = this.toFileEntry(documentId);
                fileEntries.add(fileEntry);
            }
            if (mimeTypes == null) {
                fileEntriesCache.put(folderId, fileEntries);
            }
        }
        return this.subList(fileEntries, start, end, obc);
    }

    public int getFileEntriesCount(long folderId) throws SystemException {
        List<FileEntry> fileEntries = this.getFileEntries(folderId);
        return fileEntries.size();
    }

    public int getFileEntriesCount(long folderId, long fileEntryTypeId) {
        List<FileEntry> fileEntries = this.getFileEntries(folderId, fileEntryTypeId);
        return fileEntries.size();
    }

    public int getFileEntriesCount(long folderId, String[] mimeTypes) throws PortalException, SystemException {
        Session session = this.getSession();
        List<String> documentIds = this.getDocumentIds(session, folderId, mimeTypes);
        return documentIds.size();
    }

    public FileEntry getFileEntry(long fileEntryId) throws PortalException, SystemException {
        try {
            Session session = this.getSession();
            Document document = this.getDocument(session, fileEntryId);
            return this.toFileEntry(document);
        }
        catch (PortalException pe) {
            throw pe;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e2) {
            this.processException(e2);
            throw new RepositoryException((Throwable)e2);
        }
    }

    public FileEntry getFileEntry(long folderId, String title) throws PortalException, SystemException {
        try {
            Session session = this.getSession();
            String objectId = this.getObjectId(session, folderId, true, title);
            if (objectId != null) {
                CmisObject cmisObject = session.getObject(objectId);
                Document document = (Document)cmisObject;
                return this.toFileEntry(document);
            }
        }
        catch (CmisObjectNotFoundException confe) {
            throw new NoSuchFileEntryException("No CMIS file entry with {folderId=" + folderId + ", title=" + title + "}", (Throwable)confe);
        }
        catch (PortalException pe) {
            throw pe;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e2) {
            this.processException(e2);
            throw new RepositoryException((Throwable)e2);
        }
        throw new NoSuchFileEntryException("No CMIS file entry with {folderId=" + folderId + ", title=" + title + "}");
    }

    public FileEntry getFileEntryByUuid(String uuid) throws PortalException, SystemException {
        try {
            Session session = this.getSession();
            RepositoryEntry repositoryEntry = RepositoryEntryUtil.findByUUID_G((String)uuid, (long)this.getGroupId());
            String objectId = repositoryEntry.getMappedId();
            return this.toFileEntry((Document)session.getObject(objectId));
        }
        catch (CmisObjectNotFoundException confe) {
            throw new NoSuchFileEntryException("No CMIS file entry with {uuid=" + uuid + "}", (Throwable)confe);
        }
        catch (NoSuchRepositoryEntryException nsree) {
            throw new NoSuchFileEntryException((Throwable)nsree);
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e2) {
            this.processException(e2);
            throw new RepositoryException((Throwable)e2);
        }
    }

    public FileVersion getFileVersion(long fileVersionId) throws PortalException, SystemException {
        try {
            Session session = this.getSession();
            return this.getFileVersion(session, fileVersionId);
        }
        catch (PortalException pe) {
            throw pe;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e2) {
            this.processException(e2);
            throw new RepositoryException((Throwable)e2);
        }
    }

    public Folder getFolder(long folderId) throws PortalException, SystemException {
        try {
            Session session = this.getSession();
            return this.getFolder(session, folderId);
        }
        catch (PortalException pe) {
            throw pe;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e2) {
            this.processException(e2);
            throw new RepositoryException((Throwable)e2);
        }
    }

    public Folder getFolder(long parentFolderId, String title) throws PortalException, SystemException {
        try {
            Session session = this.getSession();
            String objectId = this.getObjectId(session, parentFolderId, false, title);
            if (objectId != null) {
                CmisObject cmisObject = session.getObject(objectId);
                return this.toFolder((org.apache.chemistry.opencmis.client.api.Folder)cmisObject);
            }
        }
        catch (CmisObjectNotFoundException confe) {
            throw new NoSuchFolderException("No CMIS folder with {parentFolderId=" + parentFolderId + ", title=" + title + "}", (Throwable)confe);
        }
        catch (PortalException pe) {
            throw pe;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e2) {
            this.processException(e2);
            throw new RepositoryException((Throwable)e2);
        }
        throw new NoSuchFolderException("No CMIS folder with {parentFolderId=" + parentFolderId + ", title=" + title + "}");
    }

    public List<Folder> getFolders(long parentFolderId, boolean includeMountfolders, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        List<Folder> folders = this.getFolders(parentFolderId);
        return this.subList(folders, start, end, obc);
    }

    public List<Object> getFoldersAndFileEntries(long folderId, int start, int end, OrderByComparator obc) throws SystemException {
        List<Object> foldersAndFileEntries = this.getFoldersAndFileEntries(folderId);
        return this.subList(foldersAndFileEntries, start, end, obc);
    }

    public List<Object> getFoldersAndFileEntries(long folderId, String[] mimeTypes, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        Map<Long, List<Object>> foldersAndFileEntriesCache = _foldersAndFileEntriesCache.get();
        List<Object> foldersAndFileEntries = foldersAndFileEntriesCache.get(folderId);
        if (foldersAndFileEntries == null || mimeTypes != null) {
            foldersAndFileEntries = new ArrayList<Folder>(this.getFolders(folderId));
            List<FileEntry> fileEntries = this.getFileEntries(folderId, mimeTypes, -1, -1, null);
            foldersAndFileEntries.addAll(fileEntries);
            if (mimeTypes == null) {
                foldersAndFileEntriesCache.put(folderId, foldersAndFileEntries);
            }
        }
        return this.subList(foldersAndFileEntries, start, end, obc);
    }

    public int getFoldersAndFileEntriesCount(long folderId) throws SystemException {
        List<Object> foldersAndFileEntries = this.getFoldersAndFileEntries(folderId);
        return foldersAndFileEntries.size();
    }

    public int getFoldersAndFileEntriesCount(long folderId, String[] mimeTypes) throws PortalException, SystemException {
        if (ArrayUtil.isNotEmpty((Object[])mimeTypes)) {
            List<Folder> folders = this.getFolders(folderId);
            Session session = this.getSession();
            List<String> documentIds = this.getDocumentIds(session, folderId, mimeTypes);
            return folders.size() + documentIds.size();
        }
        List<Object> foldersAndFileEntries = this.getFoldersAndFileEntries(folderId);
        return foldersAndFileEntries.size();
    }

    public int getFoldersCount(long parentFolderId, boolean includeMountfolders) throws PortalException, SystemException {
        List<Folder> folders = this.getFolders(parentFolderId);
        return folders.size();
    }

    public int getFoldersFileEntriesCount(List<Long> folderIds, int status) throws SystemException {
        int count = 0;
        for (long folderId : folderIds) {
            List<FileEntry> fileEntries = this.getFileEntries(folderId);
            count += fileEntries.size();
        }
        return count;
    }

    public String getLatestVersionId(String objectId) throws SystemException {
        try {
            Session session = this.getSession();
            Document document = (Document)session.getObject(objectId);
            List documentVersions = document.getAllVersions();
            document = (Document)documentVersions.get(0);
            return document.getId();
        }
        catch (Exception e2) {
            throw new RepositoryException((Throwable)e2);
        }
    }

    public List<Folder> getMountFolders(long parentFolderId, int start, int end, OrderByComparator obc) {
        return new ArrayList<Folder>();
    }

    public int getMountFoldersCount(long parentFolderId) {
        return 0;
    }

    public String getObjectName(String objectId) throws PortalException, SystemException {
        Session session = this.getSession();
        CmisObject cmisObject = session.getObject(objectId);
        return cmisObject.getName();
    }

    public List<String> getObjectPaths(String objectId) throws PortalException, SystemException {
        Session session = this.getSession();
        CmisObject cmisObject = session.getObject(objectId);
        if (cmisObject instanceof FileableCmisObject) {
            FileableCmisObject fileableCmisObject = (FileableCmisObject)cmisObject;
            return fileableCmisObject.getPaths();
        }
        throw new RepositoryException("CMIS object is unfileable for id " + objectId);
    }

    public Session getSession() throws PortalException, SystemException {
        Session session = this.getCachedSession();
        if (session != null) {
            return session;
        }
        SessionImpl sessionImpl = (SessionImpl)this._cmisRepositoryHandler.getSession();
        session = sessionImpl.getSession();
        this.setCachedSession(session);
        return session;
    }

    public void getSubfolderIds(List<Long> folderIds, long folderId) throws SystemException {
        try {
            List<Folder> subfolders = this.getFolders(folderId, false, -1, -1, null);
            this.getSubfolderIds(folderIds, subfolders, true);
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e2) {
            throw new RepositoryException((Throwable)e2);
        }
    }

    public List<Long> getSubfolderIds(long folderId, boolean recurse) throws SystemException {
        try {
            ArrayList<Long> subfolderIds = new ArrayList<Long>();
            List<Folder> subfolders = this.getFolders(folderId, false, -1, -1, null);
            this.getSubfolderIds(subfolderIds, subfolders, recurse);
            return subfolderIds;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e2) {
            throw new RepositoryException((Throwable)e2);
        }
    }

    public String[] getSupportedConfigurations() {
        return this._cmisRepositoryHandler.getSupportedConfigurations();
    }

    public String[][] getSupportedParameters() {
        return this._cmisRepositoryHandler.getSupportedParameters();
    }

    public void initRepository() throws PortalException, SystemException {
        try {
            this._sessionKey = Session.class.getName().concat("#").concat(String.valueOf(this.getRepositoryId()));
            Session session = this.getSession();
            session.getRepositoryInfo();
        }
        catch (PortalException pe) {
            throw pe;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e2) {
            this.processException(e2);
            throw new RepositoryException("Unable to initialize CMIS session for repository with {repositoryId=" + this.getRepositoryId() + "}", (Throwable)e2);
        }
    }

    public boolean isCancelCheckOutAllowable(String objectId) throws PortalException, SystemException {
        return this.isActionAllowable(objectId, Action.CAN_CANCEL_CHECK_OUT);
    }

    public boolean isCheckInAllowable(String objectId) throws PortalException, SystemException {
        return this.isActionAllowable(objectId, Action.CAN_CHECK_IN);
    }

    public boolean isCheckOutAllowable(String objectId) throws PortalException, SystemException {
        return this.isActionAllowable(objectId, Action.CAN_CHECK_OUT);
    }

    public boolean isDocumentRetrievableByVersionSeriesId() {
        return this._cmisRepositoryHandler.isDocumentRetrievableByVersionSeriesId();
    }

    public boolean isRefreshBeforePermissionCheck() {
        return this._cmisRepositoryHandler.isRefreshBeforePermissionCheck();
    }

    public boolean isSupportsMinorVersions() throws PortalException, SystemException {
        try {
            Session session = this.getSession();
            RepositoryInfo repositoryInfo = session.getRepositoryInfo();
            String productName = repositoryInfo.getProductName();
            return this._cmisRepositoryHandler.isSupportsMinorVersions(productName);
        }
        catch (PortalException pe) {
            throw pe;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e2) {
            this.processException(e2);
            throw new RepositoryException((Throwable)e2);
        }
    }

    public Lock lockFolder(long folderId) {
        throw new UnsupportedOperationException();
    }

    public Lock lockFolder(long folderId, String owner, boolean inheritable, long expirationTime) {
        throw new UnsupportedOperationException();
    }

    public FileEntry moveFileEntry(long fileEntryId, long newFolderId, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            String newObjectId;
            Session session = this.getSession();
            String newFolderObjectId = this.toFolderId(session, newFolderId);
            Document document = this.getDocument(session, fileEntryId);
            this.validateTitle(session, newFolderId, document.getName());
            String oldFolderObjectId = ((org.apache.chemistry.opencmis.client.api.Folder)document.getParents().get(0)).getId();
            if (oldFolderObjectId.equals(newFolderObjectId)) {
                return this.toFileEntry(document);
            }
            document = (Document)document.move((ObjectId)new ObjectIdImpl(oldFolderObjectId), (ObjectId)new ObjectIdImpl(newFolderObjectId));
            String versionSeriesId = this.toFileEntryId(fileEntryId);
            if (!versionSeriesId.equals(newObjectId = document.getVersionSeriesId())) {
                document = (Document)session.getObject(newObjectId);
                this.updateMappedId(fileEntryId, document.getVersionSeriesId());
            }
            FileEntry fileEntry = this.toFileEntry(document);
            document = null;
            return fileEntry;
        }
        catch (CmisObjectNotFoundException confe) {
            throw new NoSuchFolderException("No CMIS folder with {folderId=" + newFolderId + "}", (Throwable)confe);
        }
        catch (PortalException pe) {
            throw pe;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e2) {
            this.processException(e2);
            throw new RepositoryException((Throwable)e2);
        }
    }

    public Folder moveFolder(long folderId, long parentFolderId, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            String targetFolderId;
            Session session = this.getSession();
            org.apache.chemistry.opencmis.client.api.Folder cmisFolder = this.getCmisFolder(session, folderId);
            this.validateTitle(session, parentFolderId, cmisFolder.getName());
            org.apache.chemistry.opencmis.client.api.Folder parentCmisFolder = cmisFolder.getFolderParent();
            if (parentCmisFolder == null) {
                throw new RepositoryException("Unable to move CMIS root folder with {folderId=" + folderId + "}");
            }
            String objectId = this.toFolderId(session, folderId);
            String sourceFolderId = parentCmisFolder.getId();
            if (!sourceFolderId.equals(targetFolderId = this.toFolderId(session, parentFolderId)) && !targetFolderId.equals(objectId)) {
                cmisFolder = (org.apache.chemistry.opencmis.client.api.Folder)cmisFolder.move((ObjectId)new ObjectIdImpl(sourceFolderId), (ObjectId)new ObjectIdImpl(targetFolderId));
            }
            return this.toFolder(cmisFolder);
        }
        catch (CmisObjectNotFoundException confe) {
            throw new NoSuchFolderException("No CMIS folder with {folderId=" + parentFolderId + "}", (Throwable)confe);
        }
        catch (PortalException pe) {
            throw pe;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e2) {
            this.processException(e2);
            throw new RepositoryException((Throwable)e2);
        }
    }

    public Lock refreshFileEntryLock(String lockUuid, long companyId, long expirationTime) {
        throw new UnsupportedOperationException();
    }

    public Lock refreshFolderLock(String lockUuid, long companyId, long expirationTime) {
        throw new UnsupportedOperationException();
    }

    public void revertFileEntry(long fileEntryId, String version, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            Session session = this.getSession();
            Document document = this.getDocument(session, fileEntryId);
            Document oldVersion = null;
            List documentVersions = document.getAllVersions();
            for (Document currentVersion : documentVersions) {
                String currentVersionLabel = currentVersion.getVersionLabel();
                if (Validator.isNull((String)currentVersionLabel)) {
                    currentVersionLabel = "1.0";
                }
                if (!currentVersionLabel.equals(version)) continue;
                oldVersion = currentVersion;
                break;
            }
            String mimeType = oldVersion.getContentStreamMimeType();
            String changeLog = "Reverted to " + version;
            String title = oldVersion.getName();
            ContentStream contentStream = oldVersion.getContentStream();
            this.updateFileEntry(fileEntryId, contentStream.getFileName(), mimeType, title, "", changeLog, true, contentStream.getStream(), contentStream.getLength(), serviceContext);
        }
        catch (PortalException pe) {
            throw pe;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e2) {
            this.processException(e2);
            throw new RepositoryException((Throwable)e2);
        }
    }

    public Hits search(long creatorUserId, int status, int start, int end) {
        throw new UnsupportedOperationException();
    }

    public Hits search(long creatorUserId, long folderId, String[] mimeTypes, int status, int start, int end) {
        throw new UnsupportedOperationException();
    }

    public Hits search(SearchContext searchContext, Query query) throws SearchException {
        try {
            QueryConfig queryConfig = searchContext.getQueryConfig();
            queryConfig.setScoreEnabled(false);
            return this.doSearch(searchContext, query);
        }
        catch (Exception e2) {
            throw new SearchException((Throwable)e2);
        }
    }

    public FileEntry toFileEntry(Document document) throws PortalException, SystemException {
        return this.toFileEntry(document, false);
    }

    public FileEntry toFileEntry(String objectId) throws PortalException, SystemException {
        return this.toFileEntry(objectId, false);
    }

    public FileVersion toFileVersion(Document version) throws SystemException {
        Object[] ids = this.getRepositoryEntryIds(version.getId());
        long fileVersionId = (Long)ids[0];
        String uuid = (String)ids[1];
        return new CMISFileVersion(this, uuid, fileVersionId, version);
    }

    public Folder toFolder(org.apache.chemistry.opencmis.client.api.Folder cmisFolder) throws SystemException {
        Object[] ids = this.getRepositoryEntryIds(cmisFolder.getId());
        long folderId = (Long)ids[0];
        String uuid = (String)ids[1];
        return new CMISFolder(this, uuid, folderId, cmisFolder);
    }

    public Folder toFolder(String objectId) throws PortalException, SystemException {
        try {
            Session session = this.getSession();
            org.apache.chemistry.opencmis.client.api.Folder cmisFolder = (org.apache.chemistry.opencmis.client.api.Folder)session.getObject(objectId);
            return this.toFolder(cmisFolder);
        }
        catch (CmisObjectNotFoundException confe) {
            throw new NoSuchFolderException("No CMIS folder with {objectId=" + objectId + "}", (Throwable)confe);
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e2) {
            this.processException(e2);
            throw new RepositoryException((Throwable)e2);
        }
    }

    public void unlockFolder(long folderId, String lockUuid) {
        throw new UnsupportedOperationException();
    }

    public FileEntry updateFileEntry(long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, InputStream is, long size, ServiceContext serviceContext) throws PortalException, SystemException {
        Document document = null;
        ObjectId checkOutDocumentObjectId = null;
        try {
            Session session = this.getSession();
            document = this.getDocument(session, fileEntryId);
            String versionSeriesCheckedOutId = document.getVersionSeriesCheckedOutId();
            if (Validator.isNotNull((String)versionSeriesCheckedOutId)) {
                document = (Document)session.getObject(versionSeriesCheckedOutId);
                document.refresh();
            }
            String currentTitle = document.getName();
            AllowableActions allowableActions = document.getAllowableActions();
            Set allowableActionsSet = allowableActions.getAllowableActions();
            if (allowableActionsSet.contains(Action.CAN_CHECK_OUT)) {
                checkOutDocumentObjectId = document.checkOut();
                document = (Document)session.getObject(checkOutDocumentObjectId);
            }
            HashMap<String, String> properties = null;
            ContentStreamImpl contentStream = null;
            if (Validator.isNotNull((String)title) && !title.equals(currentTitle)) {
                properties = new HashMap<String, String>();
                properties.put("cmis:name", title);
            }
            if (is != null) {
                contentStream = new ContentStreamImpl(sourceFileName, BigInteger.valueOf(size), mimeType, is);
            }
            this.checkUpdatable(allowableActionsSet, (Map<String, Object>)properties, (ContentStream)contentStream);
            if (checkOutDocumentObjectId != null) {
                if (!this.isSupportsMinorVersions()) {
                    majorVersion = true;
                }
                document.checkIn(majorVersion, properties, (ContentStream)contentStream, changeLog);
                checkOutDocumentObjectId = null;
            } else {
                if (properties != null) {
                    document = (Document)document.updateProperties(properties);
                }
                if (contentStream != null) {
                    document.setContentStream((ContentStream)contentStream, true, false);
                }
            }
            String versionSeriesId = this.toFileEntryId(fileEntryId);
            document = (Document)session.getObject(versionSeriesId);
            FileEntry fileEntry = this.toFileEntry(document);
            return fileEntry;
        }
        catch (PortalException pe) {
            throw pe;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e2) {
            this.processException(e2);
            throw new RepositoryException((Throwable)e2);
        }
        finally {
            if (checkOutDocumentObjectId != null) {
                document.cancelCheckOut();
            }
        }
    }

    public FileEntry updateFileEntry(String objectId, String mimeType, Map<String, Object> properties, InputStream is, String sourceFileName, long size, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            Session session = this.getSession();
            Document document = (Document)session.getObject(objectId);
            AllowableActions allowableActions = document.getAllowableActions();
            Set allowableActionsSet = allowableActions.getAllowableActions();
            ContentStreamImpl contentStream = null;
            if (is != null) {
                is = new Base64.InputStream(is, 1);
                contentStream = new ContentStreamImpl(sourceFileName, BigInteger.valueOf(size), mimeType, is);
            }
            this.checkUpdatable(allowableActionsSet, properties, (ContentStream)contentStream);
            if (properties != null) {
                document = (Document)document.updateProperties(properties);
            }
            if (contentStream != null) {
                document.setContentStream(contentStream, true, false);
            }
            return this.toFileEntry(document);
        }
        catch (PortalException pe) {
            throw pe;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e2) {
            this.processException(e2);
            throw new RepositoryException((Throwable)e2);
        }
    }

    public Folder updateFolder(long folderId, String title, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            ObjectId cmisFolderObjectId;
            String newObjectId;
            Session session = this.getSession();
            String objectId = this.toFolderId(session, folderId);
            org.apache.chemistry.opencmis.client.api.Folder cmisFolder = (org.apache.chemistry.opencmis.client.api.Folder)session.getObject(objectId);
            String currentTitle = cmisFolder.getName();
            HashMap<String, String> properties = new HashMap<String, String>();
            if (Validator.isNotNull((String)title) && !title.equals(currentTitle)) {
                properties.put("cmis:name", title);
            }
            if (!objectId.equals(newObjectId = (cmisFolderObjectId = cmisFolder.updateProperties(properties, true)).getId())) {
                cmisFolder = (org.apache.chemistry.opencmis.client.api.Folder)session.getObject(newObjectId);
                this.updateMappedId(folderId, newObjectId);
            }
            return this.toFolder(cmisFolder);
        }
        catch (CmisObjectNotFoundException confe) {
            throw new NoSuchFolderException("No CMIS folder with {folderId=" + folderId + "}", (Throwable)confe);
        }
        catch (PortalException pe) {
            throw pe;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e2) {
            this.processException(e2);
            throw new RepositoryException((Throwable)e2);
        }
    }

    public boolean verifyFileEntryCheckOut(long fileEntryId, String lockUuid) {
        throw new UnsupportedOperationException();
    }

    public boolean verifyInheritableLock(long folderId, String lockUuid) {
        throw new UnsupportedOperationException();
    }

    protected void cacheFoldersAndFileEntries(long folderId) throws SystemException {
        try {
            Map<Long, List<Object>> foldersAndFileEntriesCache = _foldersAndFileEntriesCache.get();
            if (foldersAndFileEntriesCache.containsKey(folderId)) {
                return;
            }
            ArrayList<CMISModel> foldersAndFileEntries = new ArrayList<CMISModel>();
            ArrayList<CMISFolder> folders = new ArrayList<CMISFolder>();
            ArrayList<CMISFileEntry> fileEntries = new ArrayList<CMISFileEntry>();
            Session session = this.getSession();
            org.apache.chemistry.opencmis.client.api.Folder cmisParentFolder = this.getCmisFolder(session, folderId);
            Folder parentFolder = this.toFolder(cmisParentFolder);
            ItemIterable cmisObjects = cmisParentFolder.getChildren();
            for (CmisObject cmisObject : cmisObjects) {
                if (cmisObject instanceof org.apache.chemistry.opencmis.client.api.Folder) {
                    CMISFolder cmisFolder = (CMISFolder)this.toFolder((org.apache.chemistry.opencmis.client.api.Folder)cmisObject);
                    cmisFolder.setParentFolder(parentFolder);
                    foldersAndFileEntries.add(cmisFolder);
                    folders.add(cmisFolder);
                    continue;
                }
                if (!(cmisObject instanceof Document)) continue;
                CMISFileEntry cmisFileEntry = (CMISFileEntry)this.toFileEntry((Document)cmisObject);
                cmisFileEntry.setParentFolder(parentFolder);
                foldersAndFileEntries.add(cmisFileEntry);
                fileEntries.add(cmisFileEntry);
            }
            foldersAndFileEntriesCache.put(folderId, foldersAndFileEntries);
            Map<Long, List<Folder>> foldersCache = _foldersCache.get();
            foldersCache.put(folderId, folders);
            Map<Long, List<FileEntry>> fileEntriesCache = _fileEntriesCache.get();
            fileEntriesCache.put(folderId, fileEntries);
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e2) {
            throw new RepositoryException((Throwable)e2);
        }
    }

    protected void checkUpdatable(Set<Action> allowableActionsSet, Map<String, Object> properties, ContentStream contentStream) throws PrincipalException {
        if (properties != null && !allowableActionsSet.contains(Action.CAN_UPDATE_PROPERTIES)) {
            throw new PrincipalException();
        }
        if (contentStream != null && !allowableActionsSet.contains(Action.CAN_SET_CONTENT_STREAM)) {
            throw new PrincipalException();
        }
    }

    protected void deleteMappedFileEntry(Document document) throws SystemException {
        if (PropsValues.DL_REPOSITORY_CMIS_DELETE_DEPTH == 0) {
            return;
        }
        List documentVersions = document.getAllVersions();
        for (Document version : documentVersions) {
            try {
                RepositoryEntryUtil.removeByR_M((long)this.getRepositoryId(), (String)version.getId());
            }
            catch (NoSuchRepositoryEntryException noSuchRepositoryEntryException) {}
        }
        try {
            RepositoryEntryUtil.removeByR_M((long)this.getRepositoryId(), (String)document.getId());
        }
        catch (NoSuchRepositoryEntryException noSuchRepositoryEntryException) {}
    }

    protected void deleteMappedFolder(org.apache.chemistry.opencmis.client.api.Folder cmisFolder) throws SystemException {
        if (PropsValues.DL_REPOSITORY_CMIS_DELETE_DEPTH == 0) {
            return;
        }
        ItemIterable cmisObjects = cmisFolder.getChildren();
        for (CmisObject cmisObject : cmisObjects) {
            if (cmisObject instanceof Document) {
                Document document = (Document)cmisObject;
                this.deleteMappedFileEntry(document);
                continue;
            }
            if (!(cmisObject instanceof org.apache.chemistry.opencmis.client.api.Folder)) continue;
            org.apache.chemistry.opencmis.client.api.Folder cmisSubfolder = (org.apache.chemistry.opencmis.client.api.Folder)cmisObject;
            try {
                RepositoryEntryUtil.removeByR_M((long)this.getRepositoryId(), (String)cmisObject.getId());
                if (PropsValues.DL_REPOSITORY_CMIS_DELETE_DEPTH != -1) continue;
                this.deleteMappedFolder(cmisSubfolder);
            }
            catch (NoSuchRepositoryEntryException noSuchRepositoryEntryException) {}
        }
    }

    protected Hits doSearch(SearchContext searchContext, Query query) throws Exception {
        long startTime = System.currentTimeMillis();
        Session session = this.getSession();
        RepositoryInfo repositoryInfo = session.getRepositoryInfo();
        RepositoryCapabilities repositoryCapabilities = repositoryInfo.getCapabilities();
        QueryConfig queryConfig = searchContext.getQueryConfig();
        CapabilityQuery capabilityQuery = repositoryCapabilities.getQueryCapability();
        queryConfig.setAttribute("capabilityQuery", (Serializable)((Object)capabilityQuery.value()));
        String productName = repositoryInfo.getProductName();
        String productVersion = repositoryInfo.getProductVersion();
        queryConfig.setAttribute("repositoryProductName", (Serializable)((Object)productName));
        queryConfig.setAttribute("repositoryProductVersion", (Serializable)((Object)productVersion));
        String queryString = CMISSearchQueryBuilderUtil.buildQuery((SearchContext)searchContext, (Query)query);
        if (productName.contains("Nuxeo") && productVersion.contains("5.4")) {
            queryString = String.valueOf(queryString) + " AND (cmis:isLatestVersion = true)";
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("CMIS search query: " + queryString));
        }
        ItemIterable queryResults = session.query(queryString, false);
        int start = searchContext.getStart();
        int end = searchContext.getEnd();
        if (start == -1 && end == -1) {
            start = 0;
        }
        int total = 0;
        ArrayList<DocumentImpl> documents = new ArrayList<DocumentImpl>();
        ArrayList<String> snippets = new ArrayList<String>();
        ArrayList<Float> scores = new ArrayList<Float>();
        for (QueryResult queryResult : queryResults) {
            if (++total <= start || total > end && end != -1) continue;
            DocumentImpl document = new DocumentImpl();
            String objectId = (String)queryResult.getPropertyValueByQueryName("cmis:objectId");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Search result object ID " + objectId));
            }
            FileEntry fileEntry = null;
            try {
                fileEntry = this.toFileEntry(objectId, true);
            }
            catch (Exception e2) {
                if (_log.isDebugEnabled()) {
                    Throwable cause = e2.getCause();
                    if (cause != null) {
                        cause = cause.getCause();
                    }
                    if (cause instanceof CmisObjectNotFoundException) {
                        _log.debug((Object)("Search result ignored for CMIS document which has a version with an invalid object ID " + cause.getMessage()));
                    } else {
                        _log.debug((Object)"Search result ignored for invalid object ID", (Throwable)e2);
                    }
                }
                --total;
                continue;
            }
            document.addKeyword("entryClassName", fileEntry.getModelClassName());
            document.addKeyword("entryClassPK", fileEntry.getFileEntryId());
            document.addKeyword("title", fileEntry.getTitle());
            documents.add(document);
            if (queryConfig.isScoreEnabled()) {
                Object scoreObj = queryResult.getPropertyValueByQueryName("HITS");
                if (scoreObj != null) {
                    scores.add(Float.valueOf(scoreObj.toString()));
                } else {
                    scores.add(Float.valueOf(1.0f));
                }
            } else {
                scores.add(Float.valueOf(1.0f));
            }
            snippets.add("");
        }
        float searchTime = (float)(System.currentTimeMillis() - startTime) / 1000.0f;
        HitsImpl hits = new HitsImpl();
        hits.setDocs(documents.toArray(new com.liferay.portal.kernel.search.Document[documents.size()]));
        hits.setLength(total);
        hits.setQuery(query);
        hits.setQueryTerms(new String[0]);
        hits.setScores(scores.toArray(new Float[scores.size()]));
        hits.setSearchTime(searchTime);
        hits.setSnippets(snippets.toArray(new String[snippets.size()]));
        hits.setStart(startTime);
        return hits;
    }

    protected Session getCachedSession() {
        HttpSession httpSession = PortalSessionThreadLocal.getHttpSession();
        if (httpSession == null) {
            return null;
        }
        TransientValue transientValue = (TransientValue)httpSession.getAttribute(this._sessionKey);
        if (transientValue == null) {
            return null;
        }
        return (Session)transientValue.getValue();
    }

    protected org.apache.chemistry.opencmis.client.api.Folder getCmisFolder(Session session, long folderId) throws PortalException, SystemException {
        Folder folder = this.getFolder(session, folderId);
        org.apache.chemistry.opencmis.client.api.Folder cmisFolder = (org.apache.chemistry.opencmis.client.api.Folder)folder.getModel();
        return cmisFolder;
    }

    protected List<String> getCmisFolderIds(Session session, long folderId) throws PortalException, SystemException {
        StringBundler sb = new StringBundler(4);
        sb.append("SELECT cmis:objectId FROM cmis:folder");
        if (folderId > 0L) {
            sb.append(" WHERE IN_FOLDER(");
            String objectId = this.toFolderId(session, folderId);
            sb.append(StringUtil.quote((String)objectId));
            sb.append(")");
        }
        String query = sb.toString();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Calling query " + query));
        }
        ItemIterable queryResults = session.query(query, this.isAllVersionsSearchableSupported(session));
        ArrayList<String> cmsFolderIds = new ArrayList<String>();
        for (QueryResult queryResult : queryResults) {
            PropertyData propertyData = queryResult.getPropertyById("cmis:objectId");
            List values = propertyData.getValues();
            String value = (String)values.get(0);
            cmsFolderIds.add(value);
        }
        return cmsFolderIds;
    }

    protected Document getDocument(Session session, long fileEntryId) throws PortalException, SystemException {
        try {
            String versionSeriesId = this.toFileEntryId(fileEntryId);
            Document document = (Document)session.getObject(versionSeriesId);
            return document;
        }
        catch (CmisObjectNotFoundException confe) {
            throw new NoSuchFileEntryException("No CMIS file entry with {fileEntryId=" + fileEntryId + "}", (Throwable)confe);
        }
    }

    protected List<String> getDocumentIds(Session session, long folderId, String[] mimeTypes) throws PortalException, SystemException {
        StringBundler sb = new StringBundler();
        sb.append("SELECT cmis:objectId FROM cmis:document");
        if (ArrayUtil.isNotEmpty((Object[])mimeTypes)) {
            sb.append(" WHERE cmis:contentStreamMimeType IN (");
            int i2 = 0;
            while (i2 < mimeTypes.length) {
                sb.append(StringUtil.quote((String)mimeTypes[i2]));
                if (i2 + 1 < mimeTypes.length) {
                    sb.append(", ");
                }
                ++i2;
            }
            sb.append(")");
        }
        if (folderId > 0L) {
            if (ArrayUtil.isNotEmpty((Object[])mimeTypes)) {
                sb.append(" AND ");
            } else {
                sb.append(" WHERE ");
            }
            sb.append("IN_FOLDER(");
            String objectId = this.toFolderId(session, folderId);
            sb.append(StringUtil.quote((String)objectId));
            sb.append(")");
        }
        String query = sb.toString();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Calling query " + query));
        }
        ItemIterable queryResults = session.query(query, false);
        ArrayList<String> cmisDocumentIds = new ArrayList<String>();
        for (QueryResult queryResult : queryResults) {
            String objectId = (String)queryResult.getPropertyValueByQueryName("cmis:objectId");
            cmisDocumentIds.add(objectId);
        }
        return cmisDocumentIds;
    }

    protected List<FileEntry> getFileEntries(long folderId) throws SystemException {
        this.cacheFoldersAndFileEntries(folderId);
        Map<Long, List<FileEntry>> fileEntriesCache = _fileEntriesCache.get();
        return fileEntriesCache.get(folderId);
    }

    protected List<FileEntry> getFileEntries(long folderId, long repositoryId) {
        return new ArrayList<FileEntry>();
    }

    protected FileVersion getFileVersion(Session session, long fileVersionId) throws PortalException, SystemException {
        try {
            String objectId = this.toFileVersionId(fileVersionId);
            return this.toFileVersion((Document)session.getObject(objectId));
        }
        catch (CmisObjectNotFoundException confe) {
            throw new NoSuchFileVersionException("No CMIS file version with {fileVersionId=" + fileVersionId + "}", (Throwable)confe);
        }
    }

    protected Folder getFolder(Session session, long folderId) throws PortalException, SystemException {
        try {
            String objectId = this.toFolderId(session, folderId);
            CmisObject cmisObject = session.getObject(objectId);
            return (Folder)this.toFolderOrFileEntry(cmisObject);
        }
        catch (CmisObjectNotFoundException confe) {
            throw new NoSuchFolderException("No CMIS folder with {folderId=" + folderId + "}", (Throwable)confe);
        }
    }

    protected List<Folder> getFolders(long parentFolderId) throws PortalException, SystemException {
        Map<Long, List<Folder>> foldersCache = _foldersCache.get();
        List<Folder> folders = foldersCache.get(parentFolderId);
        if (folders == null) {
            List<String> folderIds = this.getCmisFolderIds(this.getSession(), parentFolderId);
            folders = new ArrayList<Folder>(folderIds.size());
            for (String folderId : folderIds) {
                folders.add(this.toFolder(folderId));
            }
            foldersCache.put(parentFolderId, folders);
        }
        return folders;
    }

    protected List<Object> getFoldersAndFileEntries(long folderId) throws SystemException {
        this.cacheFoldersAndFileEntries(folderId);
        Map<Long, List<Object>> foldersAndFileEntriesCache = _foldersAndFileEntriesCache.get();
        return foldersAndFileEntriesCache.get(folderId);
    }

    protected String getObjectId(Session session, long folderId, boolean fileEntry, String name) throws PortalException, SystemException {
        ItemIterable queryResults;
        Iterator itr;
        String objectId = this.toFolderId(session, folderId);
        StringBundler sb = new StringBundler(7);
        sb.append("SELECT cmis:objectId FROM ");
        if (fileEntry) {
            sb.append("cmis:document ");
        } else {
            sb.append("cmis:folder ");
        }
        sb.append("WHERE cmis:name = '");
        sb.append(name);
        sb.append("' AND IN_FOLDER('");
        sb.append(objectId);
        sb.append("')");
        String query = sb.toString();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Calling query " + query));
        }
        if ((itr = (queryResults = session.query(query, false)).iterator()).hasNext()) {
            QueryResult queryResult = (QueryResult)itr.next();
            PropertyData propertyData = queryResult.getPropertyById("cmis:objectId");
            List values = propertyData.getValues();
            return (String)values.get(0);
        }
        return null;
    }

    protected void getSubfolderIds(List<Long> subfolderIds, List<Folder> subfolders, boolean recurse) throws PortalException, SystemException {
        for (Folder subfolder : subfolders) {
            long subfolderId = subfolder.getFolderId();
            subfolderIds.add(subfolderId);
            if (!recurse) continue;
            List<Folder> subSubFolders = this.getFolders(subfolderId, false, -1, -1, null);
            this.getSubfolderIds(subfolderIds, subSubFolders, recurse);
        }
    }

    protected boolean isActionAllowable(String objectId, Action action) throws PortalException, SystemException {
        Session session = this.getSession();
        Document document = (Document)session.getObject(objectId);
        AllowableActions allowableActions = document.getAllowableActions();
        Set allowableActionsSet = allowableActions.getAllowableActions();
        return allowableActionsSet.contains(action);
    }

    protected boolean isAllVersionsSearchableSupported(Session session) {
        RepositoryInfo repositoryInfo = session.getRepositoryInfo();
        RepositoryCapabilities repositoryCapabilities = repositoryInfo.getCapabilities();
        return repositoryCapabilities.isAllVersionsSearchableSupported();
    }

    protected void processException(Exception e2) throws PortalException {
        if (e2 instanceof CmisRuntimeException && e2.getMessage().contains("authorized") || e2 instanceof CmisPermissionDeniedException) {
            String message = e2.getMessage();
            try {
                message = "Unable to login with user " + this._cmisRepositoryHandler.getLogin();
            }
            catch (Exception exception) {}
            throw new PrincipalException(message, (Throwable)e2);
        }
    }

    protected void setCachedSession(Session session) {
        HttpSession httpSession = PortalSessionThreadLocal.getHttpSession();
        if (httpSession == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Unable to get HTTP session");
            }
            return;
        }
        httpSession.setAttribute(this._sessionKey, (Object)new TransientValue((Object)session));
    }

    protected <E> List<E> subList(List<E> list, int start, int end, OrderByComparator obc) {
        if (obc != null && (obc instanceof RepositoryModelCreateDateComparator || obc instanceof RepositoryModelModifiedDateComparator || obc instanceof RepositoryModelNameComparator || obc instanceof RepositoryModelSizeComparator)) {
            list = ListUtil.sort(list, (Comparator)obc);
        }
        return ListUtil.subList(list, (int)start, (int)end);
    }

    protected FileEntry toFileEntry(Document document, boolean strict) throws PortalException, SystemException {
        Object[] ids = null;
        ids = this.isDocumentRetrievableByVersionSeriesId() ? this.getRepositoryEntryIds(document.getVersionSeriesId()) : this.getRepositoryEntryIds(document.getId());
        long fileEntryId = (Long)ids[0];
        String uuid = (String)ids[1];
        CMISFileEntry fileEntry = new CMISFileEntry(this, uuid, fileEntryId, document);
        FileVersion fileVersion = null;
        try {
            fileVersion = fileEntry.getFileVersion();
        }
        catch (Exception e2) {
            if (strict) {
                if (((Boolean)ids[2]).booleanValue()) {
                    RepositoryEntryUtil.remove((long)fileEntryId);
                }
                if (e2 instanceof CmisObjectNotFoundException) {
                    throw new NoSuchFileVersionException("No CMIS file version with CMIS file entry {objectId=" + document.getId() + "}", (Throwable)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                this.processException(e2);
                throw new RepositoryException((Throwable)e2);
            }
            _log.error((Object)"Unable to update asset", (Throwable)e2);
        }
        this.dlAppHelperLocalService.checkAssetEntry(PrincipalThreadLocal.getUserId(), (FileEntry)fileEntry, fileVersion);
        return fileEntry;
    }

    protected FileEntry toFileEntry(String objectId, boolean strict) throws PortalException, SystemException {
        try {
            Session session = this.getSession();
            Document document = (Document)session.getObject(objectId);
            return this.toFileEntry(document, strict);
        }
        catch (CmisObjectNotFoundException confe) {
            throw new NoSuchFileEntryException("No CMIS file entry with {objectId=" + objectId + "}", (Throwable)confe);
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e2) {
            this.processException(e2);
            throw new RepositoryException((Throwable)e2);
        }
    }

    protected String toFileEntryId(long fileEntryId) throws PortalException, SystemException {
        RepositoryEntry repositoryEntry = RepositoryEntryUtil.fetchByPrimaryKey((long)fileEntryId);
        if (repositoryEntry == null) {
            throw new NoSuchFileEntryException("No CMIS file entry with {fileEntryId=" + fileEntryId + "}");
        }
        return repositoryEntry.getMappedId();
    }

    protected String toFileVersionId(long fileVersionId) throws PortalException, SystemException {
        RepositoryEntry repositoryEntry = RepositoryEntryUtil.fetchByPrimaryKey((long)fileVersionId);
        if (repositoryEntry == null) {
            throw new NoSuchFileVersionException("No CMIS file version with {fileVersionId=" + fileVersionId + "}");
        }
        return repositoryEntry.getMappedId();
    }

    protected String toFolderId(Session session, long folderId) throws PortalException, SystemException {
        RepositoryEntry repositoryEntry = RepositoryEntryUtil.fetchByPrimaryKey((long)folderId);
        if (repositoryEntry != null) {
            return repositoryEntry.getMappedId();
        }
        DLFolder dlFolder = DLFolderUtil.fetchByPrimaryKey((long)folderId);
        if (dlFolder == null) {
            throw new NoSuchFolderException("No CMIS folder with {folderId=" + folderId + "}");
        }
        if (!dlFolder.isMountPoint()) {
            throw new RepositoryException("CMIS repository should not be used with {folderId=" + folderId + "}");
        }
        RepositoryInfo repositoryInfo = session.getRepositoryInfo();
        String rootFolderId = repositoryInfo.getRootFolderId();
        repositoryEntry = RepositoryEntryUtil.fetchByR_M((long)this.getRepositoryId(), (String)rootFolderId);
        if (repositoryEntry == null) {
            repositoryEntry = RepositoryEntryLocalServiceUtil.addRepositoryEntry((long)dlFolder.getUserId(), (long)this.getGroupId(), (long)this.getRepositoryId(), (String)rootFolderId, (ServiceContext)new ServiceContext());
        }
        return repositoryEntry.getMappedId();
    }

    protected Object toFolderOrFileEntry(CmisObject cmisObject) throws PortalException, SystemException {
        if (cmisObject instanceof Document) {
            FileEntry fileEntry = this.toFileEntry((Document)cmisObject);
            return fileEntry;
        }
        if (cmisObject instanceof org.apache.chemistry.opencmis.client.api.Folder) {
            org.apache.chemistry.opencmis.client.api.Folder cmisFolder = (org.apache.chemistry.opencmis.client.api.Folder)cmisObject;
            Folder folder = this.toFolder(cmisFolder);
            return folder;
        }
        return null;
    }

    protected void updateMappedId(long repositoryEntryId, String mappedId) throws PortalException, SystemException {
        RepositoryEntry repositoryEntry = RepositoryEntryUtil.findByPrimaryKey((long)repositoryEntryId);
        if (!mappedId.equals(repositoryEntry.getMappedId())) {
            RepositoryEntryLocalServiceUtil.updateRepositoryEntry((long)repositoryEntryId, (String)mappedId);
        }
    }

    protected void validateTitle(Session session, long folderId, String title) throws PortalException, SystemException {
        String objectId = this.getObjectId(session, folderId, true, title);
        if (objectId != null) {
            throw new DuplicateFileException(title);
        }
        objectId = this.getObjectId(session, folderId, false, title);
        if (objectId != null) {
            throw new DuplicateFolderNameException(title);
        }
    }
}

