/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.monitoring.jmx;

import com.liferay.portal.kernel.util.HashUtil;
import java.lang.reflect.Method;

public class MethodSignature {
    private String _className;
    private String _methodName;
    private String[] _parameterTypeNames;

    public MethodSignature(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        this._className = clazz.getName();
        this._methodName = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        this._parameterTypeNames = new String[parameterTypes.length];
        int i2 = 0;
        while (i2 < parameterTypes.length) {
            this._parameterTypeNames[i2] = parameterTypes[i2].getName();
            ++i2;
        }
    }

    public MethodSignature(String className, String methodName, String[] parameterTypeNames) {
        this._className = className;
        this._methodName = methodName;
        this._parameterTypeNames = parameterTypeNames;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MethodSignature)) {
            return false;
        }
        MethodSignature methodSignature = (MethodSignature)obj;
        if (this._className.equals(methodSignature._className) && this._methodName.equals(methodSignature._methodName) && this._parameterTypeNames.length == methodSignature._parameterTypeNames.length) {
            int i2 = 0;
            while (i2 < this._parameterTypeNames.length) {
                if (!this._parameterTypeNames[i2].equals(methodSignature._parameterTypeNames[i2])) {
                    return false;
                }
                ++i2;
            }
            return true;
        }
        return false;
    }

    public String getClassName() {
        return this._className;
    }

    public String getMethodName() {
        return this._methodName;
    }

    public String[] getParameterTypeNames() {
        return this._parameterTypeNames;
    }

    public int hashCode() {
        int hashCode = HashUtil.hash((int)0, (Object)this._className);
        hashCode = HashUtil.hash((int)hashCode, (Object)this._methodName);
        String[] stringArray = this._parameterTypeNames;
        int n = this._parameterTypeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String parameterTypeName = stringArray[n2];
            hashCode = HashUtil.hash((int)hashCode, (Object)parameterTypeName);
            ++n2;
        }
        return hashCode;
    }
}

