/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.dao.shard.ShardUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.RemotePreference;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TimeZoneUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Address;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Contact;
import com.liferay.portal.model.EmailAddress;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.PasswordPolicy;
import com.liferay.portal.model.Phone;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.Team;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserConstants;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.model.Website;
import com.liferay.portal.model.impl.UserBaseImpl;
import com.liferay.portal.security.auth.EmailAddressGenerator;
import com.liferay.portal.security.auth.EmailAddressGeneratorFactory;
import com.liferay.portal.security.auth.FullNameGenerator;
import com.liferay.portal.security.auth.FullNameGeneratorFactory;
import com.liferay.portal.service.AddressLocalServiceUtil;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.ContactLocalServiceUtil;
import com.liferay.portal.service.EmailAddressLocalServiceUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.GroupServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.PasswordPolicyLocalServiceUtil;
import com.liferay.portal.service.PhoneLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.TeamLocalServiceUtil;
import com.liferay.portal.service.UserGroupLocalServiceUtil;
import com.liferay.portal.service.WebsiteLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;

public class UserImpl
extends UserBaseImpl {
    private Locale _locale;
    private boolean _passwordModified;
    private PasswordPolicy _passwordPolicy;
    private String _passwordUnencrypted;
    private transient Map<String, RemotePreference> _remotePreferences = new HashMap<String, RemotePreference>();
    private TimeZone _timeZone;

    public void addRemotePreference(RemotePreference remotePreference) {
        this._remotePreferences.put(remotePreference.getName(), remotePreference);
    }

    public List<Address> getAddresses() throws SystemException {
        return AddressLocalServiceUtil.getAddresses((long)this.getCompanyId(), (String)Contact.class.getName(), (long)this.getContactId());
    }

    public Date getBirthday() throws PortalException, SystemException {
        return this.getContact().getBirthday();
    }

    public String getCompanyMx() throws PortalException, SystemException {
        Company company = CompanyLocalServiceUtil.getCompanyById((long)this.getCompanyId());
        return company.getMx();
    }

    public Contact getContact() throws PortalException, SystemException {
        try {
            ShardUtil.pushCompanyService((long)this.getCompanyId());
            Contact contact = ContactLocalServiceUtil.getContact((long)this.getContactId());
            return contact;
        }
        finally {
            ShardUtil.popCompanyService();
        }
    }

    @Override
    public String getDigest() {
        String digest = super.getDigest();
        if (Validator.isNull((String)digest) && !this.isPasswordEncrypted()) {
            digest = this.getDigest(this.getPassword());
        }
        return digest;
    }

    public String getDigest(String password) {
        if (Validator.isNull((String)this.getScreenName())) {
            throw new IllegalStateException("Screen name is null");
        }
        if (Validator.isNull((String)this.getEmailAddress())) {
            throw new IllegalStateException("Email address is null");
        }
        StringBundler sb = new StringBundler(5);
        String digest1 = DigesterUtil.digestHex((String)"MD5", (String[])new String[]{this.getEmailAddress(), "PortalRealm", password});
        sb.append(digest1);
        sb.append(",");
        String digest2 = DigesterUtil.digestHex((String)"MD5", (String[])new String[]{this.getScreenName(), "PortalRealm", password});
        sb.append(digest2);
        sb.append(",");
        String digest3 = DigesterUtil.digestHex((String)"MD5", (String[])new String[]{String.valueOf(this.getUserId()), "PortalRealm", password});
        sb.append(digest3);
        return sb.toString();
    }

    public String getDisplayEmailAddress() {
        String emailAddress = super.getEmailAddress();
        EmailAddressGenerator emailAddressGenerator = EmailAddressGeneratorFactory.getInstance();
        if (emailAddressGenerator.isFake(emailAddress)) {
            emailAddress = "";
        }
        return emailAddress;
    }

    public String getDisplayURL(String portalURL, String mainPath) throws PortalException, SystemException {
        return this.getDisplayURL(portalURL, mainPath, false);
    }

    public String getDisplayURL(String portalURL, String mainPath, boolean privateLayout) throws PortalException, SystemException {
        if (this.isDefaultUser()) {
            return "";
        }
        String profileFriendlyURL = this.getProfileFriendlyURL();
        if (Validator.isNotNull((String)profileFriendlyURL)) {
            return portalURL.concat(PortalUtil.getPathContext()).concat(profileFriendlyURL);
        }
        Group group = this.getGroup();
        int publicLayoutsPageCount = group.getPublicLayoutsPageCount();
        if (publicLayoutsPageCount > 0) {
            StringBundler sb = new StringBundler(5);
            sb.append(portalURL);
            sb.append(mainPath);
            sb.append("/my_sites/view?groupId=");
            sb.append(group.getGroupId());
            if (privateLayout) {
                sb.append("&privateLayout=1");
            } else {
                sb.append("&privateLayout=0");
            }
            return sb.toString();
        }
        return "";
    }

    public String getDisplayURL(ThemeDisplay themeDisplay) throws PortalException, SystemException {
        return this.getDisplayURL(themeDisplay.getPortalURL(), themeDisplay.getPathMain(), false);
    }

    public String getDisplayURL(ThemeDisplay themeDisplay, boolean privateLayout) throws PortalException, SystemException {
        return this.getDisplayURL(themeDisplay.getPortalURL(), themeDisplay.getPathMain(), privateLayout);
    }

    public List<EmailAddress> getEmailAddresses() throws SystemException {
        return EmailAddressLocalServiceUtil.getEmailAddresses((long)this.getCompanyId(), (String)Contact.class.getName(), (long)this.getContactId());
    }

    public boolean getFemale() throws PortalException, SystemException {
        return !this.getMale();
    }

    @AutoEscape
    public String getFullName() {
        FullNameGenerator fullNameGenerator = FullNameGeneratorFactory.getInstance();
        return fullNameGenerator.getFullName(this.getFirstName(), this.getMiddleName(), this.getLastName());
    }

    public Group getGroup() throws PortalException, SystemException {
        return GroupLocalServiceUtil.getUserGroup((long)this.getCompanyId(), (long)this.getUserId());
    }

    public long getGroupId() throws PortalException, SystemException {
        Group group = this.getGroup();
        return group.getGroupId();
    }

    public long[] getGroupIds() throws SystemException {
        List<Group> groups = this.getGroups();
        long[] groupIds = new long[groups.size()];
        int i2 = 0;
        while (i2 < groups.size()) {
            Group group = groups.get(i2);
            groupIds[i2] = group.getGroupId();
            ++i2;
        }
        return groupIds;
    }

    public List<Group> getGroups() throws SystemException {
        return GroupLocalServiceUtil.getUserGroups((long)this.getUserId());
    }

    public Locale getLocale() {
        return this._locale;
    }

    public String getLogin() throws PortalException, SystemException {
        String login = null;
        Company company = CompanyLocalServiceUtil.getCompanyById((long)this.getCompanyId());
        if (company.getAuthType().equals("emailAddress")) {
            login = this.getEmailAddress();
        } else if (company.getAuthType().equals("screenName")) {
            login = this.getScreenName();
        } else if (company.getAuthType().equals("userId")) {
            login = String.valueOf(this.getUserId());
        }
        return login;
    }

    public boolean getMale() throws PortalException, SystemException {
        return this.getContact().getMale();
    }

    public List<Group> getMySiteGroups() throws PortalException, SystemException {
        return this.getMySiteGroups(null, false, -1);
    }

    public List<Group> getMySiteGroups(boolean includeControlPanel, int max) throws PortalException, SystemException {
        return this.getMySiteGroups(null, includeControlPanel, max);
    }

    public List<Group> getMySiteGroups(int max) throws PortalException, SystemException {
        return this.getMySiteGroups(null, false, max);
    }

    public List<Group> getMySiteGroups(String[] classNames, boolean includeControlPanel, int max) throws PortalException, SystemException {
        return GroupServiceUtil.getUserSitesGroups((long)this.getUserId(), (String[])classNames, (boolean)includeControlPanel, (int)max);
    }

    public List<Group> getMySiteGroups(String[] classNames, int max) throws PortalException, SystemException {
        return this.getMySiteGroups(classNames, false, max);
    }

    public List<Group> getMySites() throws PortalException, SystemException {
        return this.getMySiteGroups();
    }

    public List<Group> getMySites(boolean includeControlPanel, int max) throws PortalException, SystemException {
        return this.getMySiteGroups(includeControlPanel, max);
    }

    public List<Group> getMySites(int max) throws PortalException, SystemException {
        return this.getMySiteGroups(max);
    }

    public List<Group> getMySites(String[] classNames, boolean includeControlPanel, int max) throws PortalException, SystemException {
        return this.getMySiteGroups(classNames, includeControlPanel, max);
    }

    public List<Group> getMySites(String[] classNames, int max) throws PortalException, SystemException {
        return this.getMySiteGroups(classNames, max);
    }

    public long[] getOrganizationIds() throws PortalException, SystemException {
        return this.getOrganizationIds(false);
    }

    public long[] getOrganizationIds(boolean includeAdministrative) throws PortalException, SystemException {
        List<Organization> organizations = this.getOrganizations(includeAdministrative);
        long[] organizationIds = new long[organizations.size()];
        int i2 = 0;
        while (i2 < organizations.size()) {
            Organization organization = organizations.get(i2);
            organizationIds[i2] = organization.getOrganizationId();
            ++i2;
        }
        return organizationIds;
    }

    public List<Organization> getOrganizations() throws PortalException, SystemException {
        return this.getOrganizations(false);
    }

    public List<Organization> getOrganizations(boolean includeAdministrative) throws PortalException, SystemException {
        return OrganizationLocalServiceUtil.getUserOrganizations((long)this.getUserId(), (boolean)includeAdministrative);
    }

    public boolean getPasswordModified() {
        return this._passwordModified;
    }

    public PasswordPolicy getPasswordPolicy() throws PortalException, SystemException {
        if (this._passwordPolicy == null) {
            this._passwordPolicy = PasswordPolicyLocalServiceUtil.getPasswordPolicyByUserId((long)this.getUserId());
        }
        return this._passwordPolicy;
    }

    public String getPasswordUnencrypted() {
        return this._passwordUnencrypted;
    }

    public List<Phone> getPhones() throws SystemException {
        return PhoneLocalServiceUtil.getPhones((long)this.getCompanyId(), (String)Contact.class.getName(), (long)this.getContactId());
    }

    public String getPortraitURL(ThemeDisplay themeDisplay) throws PortalException, SystemException {
        return UserConstants.getPortraitURL((String)themeDisplay.getPathImage(), (boolean)this.isMale(), (long)this.getPortraitId());
    }

    public int getPrivateLayoutsPageCount() throws PortalException, SystemException {
        return LayoutLocalServiceUtil.getLayoutsCount((User)this, (boolean)true);
    }

    public int getPublicLayoutsPageCount() throws PortalException, SystemException {
        return LayoutLocalServiceUtil.getLayoutsCount((User)this, (boolean)false);
    }

    public Set<String> getReminderQueryQuestions() throws PortalException, SystemException {
        TreeSet<String> questions = new TreeSet<String>();
        List organizations = OrganizationLocalServiceUtil.getUserOrganizations((long)this.getUserId());
        for (Organization organization : organizations) {
            Set organizationQuestions = organization.getReminderQueryQuestions(this.getLanguageId());
            if (organizationQuestions.size() == 0) {
                Organization parentOrganization = organization.getParentOrganization();
                while (organizationQuestions.size() == 0 && parentOrganization != null) {
                    organizationQuestions = parentOrganization.getReminderQueryQuestions(this.getLanguageId());
                    parentOrganization = parentOrganization.getParentOrganization();
                }
            }
            questions.addAll(organizationQuestions);
        }
        if (questions.size() == 0) {
            Set defaultQuestions = SetUtil.fromArray((Object[])PropsUtil.getArray("users.reminder.queries.questions"));
            questions.addAll(defaultQuestions);
        }
        return questions;
    }

    public RemotePreference getRemotePreference(String name) {
        return this._remotePreferences.get(name);
    }

    public Iterable<RemotePreference> getRemotePreferences() {
        Collection<RemotePreference> values = this._remotePreferences.values();
        return Collections.unmodifiableCollection(values);
    }

    public long[] getRoleIds() throws SystemException {
        List<Role> roles = this.getRoles();
        long[] roleIds = new long[roles.size()];
        int i2 = 0;
        while (i2 < roles.size()) {
            Role role = roles.get(i2);
            roleIds[i2] = role.getRoleId();
            ++i2;
        }
        return roleIds;
    }

    public List<Role> getRoles() throws SystemException {
        return RoleLocalServiceUtil.getUserRoles((long)this.getUserId());
    }

    public List<Group> getSiteGroups() throws PortalException, SystemException {
        return this.getSiteGroups(false);
    }

    public List<Group> getSiteGroups(boolean includeAdministrative) throws PortalException, SystemException {
        return GroupLocalServiceUtil.getUserSitesGroups((long)this.getUserId(), (boolean)includeAdministrative);
    }

    public long[] getTeamIds() throws SystemException {
        List<Team> teams = this.getTeams();
        long[] teamIds = new long[teams.size()];
        int i2 = 0;
        while (i2 < teams.size()) {
            Team team = teams.get(i2);
            teamIds[i2] = team.getTeamId();
            ++i2;
        }
        return teamIds;
    }

    public List<Team> getTeams() throws SystemException {
        return TeamLocalServiceUtil.getUserTeams((long)this.getUserId());
    }

    public TimeZone getTimeZone() {
        return this._timeZone;
    }

    public long[] getUserGroupIds() throws SystemException {
        List<UserGroup> userGroups = this.getUserGroups();
        long[] userGroupIds = new long[userGroups.size()];
        int i2 = 0;
        while (i2 < userGroups.size()) {
            UserGroup userGroup = userGroups.get(i2);
            userGroupIds[i2] = userGroup.getUserGroupId();
            ++i2;
        }
        return userGroupIds;
    }

    public List<UserGroup> getUserGroups() throws SystemException {
        return UserGroupLocalServiceUtil.getUserUserGroups((long)this.getUserId());
    }

    public List<Website> getWebsites() throws SystemException {
        return WebsiteLocalServiceUtil.getWebsites((long)this.getCompanyId(), (String)Contact.class.getName(), (long)this.getContactId());
    }

    public boolean hasCompanyMx() throws PortalException, SystemException {
        return this.hasCompanyMx(this.getEmailAddress());
    }

    public boolean hasCompanyMx(String emailAddress) throws PortalException, SystemException {
        if (Validator.isNull((String)emailAddress)) {
            return false;
        }
        Company company = CompanyLocalServiceUtil.getCompanyById((long)this.getCompanyId());
        return company.hasCompanyMx(emailAddress);
    }

    public boolean hasMySites() throws PortalException, SystemException {
        List<Group> groups;
        if (this.isDefaultUser()) {
            return false;
        }
        int max = PropsValues.MY_SITES_MAX_ELEMENTS;
        if (max == 1) {
            ++max;
        }
        return !(groups = this.getMySiteGroups(true, max)).isEmpty();
    }

    public boolean hasOrganization() throws PortalException, SystemException {
        List<Organization> organizations = this.getOrganizations();
        return !organizations.isEmpty();
    }

    public boolean hasPrivateLayouts() throws PortalException, SystemException {
        return LayoutLocalServiceUtil.hasLayouts((User)this, (boolean)true);
    }

    public boolean hasPublicLayouts() throws PortalException, SystemException {
        return LayoutLocalServiceUtil.hasLayouts((User)this, (boolean)false);
    }

    public boolean hasReminderQuery() {
        return Validator.isNotNull((String)this.getReminderQueryQuestion()) && Validator.isNotNull((String)this.getReminderQueryAnswer());
    }

    public boolean isActive() {
        return this.getStatus() == 0;
    }

    public boolean isFemale() throws PortalException, SystemException {
        return this.getFemale();
    }

    public boolean isMale() throws PortalException, SystemException {
        return this.getMale();
    }

    public boolean isPasswordModified() {
        return this._passwordModified;
    }

    @Override
    public void setLanguageId(String languageId) {
        this._locale = LocaleUtil.fromLanguageId((String)languageId);
        super.setLanguageId(LocaleUtil.toLanguageId((Locale)this._locale));
    }

    public void setPasswordModified(boolean passwordModified) {
        this._passwordModified = passwordModified;
    }

    public void setPasswordUnencrypted(String passwordUnencrypted) {
        this._passwordUnencrypted = passwordUnencrypted;
    }

    @Override
    public void setTimeZoneId(String timeZoneId) {
        if (Validator.isNull((String)timeZoneId)) {
            timeZoneId = TimeZoneUtil.getDefault().getID();
        }
        this._timeZone = TimeZoneUtil.getTimeZone((String)timeZoneId);
        super.setTimeZoneId(timeZoneId);
    }

    protected String getProfileFriendlyURL() {
        if (Validator.isNull((String)PropsValues.USERS_PROFILE_FRIENDLY_URL)) {
            return null;
        }
        return StringUtil.replace((String)PropsValues.USERS_PROFILE_FRIENDLY_URL, (String[])new String[]{"${liferay:screenName}", "${liferay:userId}"}, (String[])new String[]{HtmlUtil.escapeURL((String)this.getScreenName()), String.valueOf(this.getUserId())});
    }
}

