/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model;

import com.liferay.portal.ModelListenerException;
import com.liferay.portal.model.BaseModelListener;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.security.ldap.LDAPOperation;
import com.liferay.portal.security.ldap.LDAPUserTransactionThreadLocal;
import com.liferay.portal.security.ldap.PortalLDAPExporterUtil;

public class UserGroupListener
extends BaseModelListener<UserGroup> {
    public void onAfterAddAssociation(Object userGroupId, String associationClassName, Object associationClassPK) throws ModelListenerException {
        try {
            if (associationClassName.equals(User.class.getName())) {
                this.exportToLDAP((Long)associationClassPK, (Long)userGroupId, LDAPOperation.ADD);
            }
        }
        catch (Exception e2) {
            throw new ModelListenerException((Throwable)e2);
        }
    }

    public void onAfterRemoveAssociation(Object userGroupId, String associationClassName, Object associationClassPK) throws ModelListenerException {
        try {
            if (associationClassName.equals(User.class.getName())) {
                this.exportToLDAP((Long)associationClassPK, (Long)userGroupId, LDAPOperation.REMOVE);
            }
        }
        catch (Exception e2) {
            throw new ModelListenerException((Throwable)e2);
        }
    }

    protected void exportToLDAP(long userId, long userGroupId, LDAPOperation ldapOperation) throws Exception {
        if (LDAPUserTransactionThreadLocal.isOriginatesFromLDAP()) {
            return;
        }
        PortalLDAPExporterUtil.exportToLDAP((long)userId, (long)userGroupId, (LDAPOperation)ldapOperation);
    }
}

