/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar.backgroundtask;

import com.liferay.portal.kernel.backgroundtask.BackgroundTaskResult;
import com.liferay.portal.kernel.backgroundtask.BaseBackgroundTaskExecutor;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.lar.backgroundtask.ExportBackgroundTaskStatusMessageTranslator;
import com.liferay.portal.model.BackgroundTask;
import com.liferay.portal.service.BackgroundTaskLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import java.io.File;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

public class PortletExportBackgroundTaskExecutor
extends BaseBackgroundTaskExecutor {
    public PortletExportBackgroundTaskExecutor() {
        this.setBackgroundTaskStatusMessageTranslator(new ExportBackgroundTaskStatusMessageTranslator());
        this.setSerial(true);
    }

    public BackgroundTaskResult execute(BackgroundTask backgroundTask) throws Exception {
        Map taskContextMap = backgroundTask.getTaskContextMap();
        long userId = MapUtil.getLong((Map)taskContextMap, (String)"userId");
        String fileName = MapUtil.getString((Map)taskContextMap, (String)"fileName");
        long plid = MapUtil.getLong((Map)taskContextMap, (String)"plid");
        long groupId = MapUtil.getLong((Map)taskContextMap, (String)"groupId");
        String portletId = MapUtil.getString((Map)taskContextMap, (String)"portletId");
        Map parameterMap = (Map)taskContextMap.get("parameterMap");
        Date startDate = (Date)taskContextMap.get("startDate");
        Date endDate = (Date)taskContextMap.get("endDate");
        File larFile = LayoutLocalServiceUtil.exportPortletInfoAsFile((long)plid, (long)groupId, (String)portletId, (Map)parameterMap, (Date)startDate, (Date)endDate);
        BackgroundTaskLocalServiceUtil.addBackgroundTaskAttachment((long)userId, (long)backgroundTask.getBackgroundTaskId(), (String)fileName, (File)larFile);
        return BackgroundTaskResult.SUCCESS;
    }

    public String handleException(BackgroundTask backgroundTask, Exception e2) {
        JSONObject jsonObject = StagingUtil.getExceptionMessagesJSONObject((Locale)this.getLocale(backgroundTask), (Exception)e2, (Map)backgroundTask.getTaskContextMap());
        return jsonObject.toString();
    }
}

