/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar.backgroundtask;

import com.liferay.portal.kernel.backgroundtask.BackgroundTaskResult;
import com.liferay.portal.kernel.lar.MissingReferences;
import com.liferay.portal.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.lar.backgroundtask.BaseStagingBackgroundTaskExecutor;
import com.liferay.portal.model.BackgroundTask;
import com.liferay.portal.model.Group;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutSetBranchLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import java.io.File;
import java.util.Date;
import java.util.Map;

public class LayoutStagingBackgroundTaskExecutor
extends BaseStagingBackgroundTaskExecutor {
    public BackgroundTaskResult execute(BackgroundTask backgroundTask) throws Exception {
        Map taskContextMap = backgroundTask.getTaskContextMap();
        long userId = MapUtil.getLong((Map)taskContextMap, (String)"userId");
        long targetGroupId = MapUtil.getLong((Map)taskContextMap, (String)"targetGroupId");
        StagingUtil.lockGroup((long)userId, (long)targetGroupId);
        long sourceGroupId = MapUtil.getLong((Map)taskContextMap, (String)"sourceGroupId");
        boolean privateLayout = MapUtil.getBoolean((Map)taskContextMap, (String)"privateLayout");
        long[] layoutIds = GetterUtil.getLongValues(taskContextMap.get("layoutIds"));
        Map parameterMap = (Map)taskContextMap.get("parameterMap");
        Date startDate = (Date)taskContextMap.get("startDate");
        Date endDate = (Date)taskContextMap.get("endDate");
        this.clearBackgroundTaskStatus(backgroundTask);
        File file = null;
        MissingReferences missingReferences = null;
        try {
            Date lastPublishDate = endDate;
            if (lastPublishDate == null) {
                lastPublishDate = new Date();
            }
            file = LayoutLocalServiceUtil.exportLayoutsAsFile((long)sourceGroupId, (boolean)privateLayout, (long[])layoutIds, (Map)parameterMap, (Date)startDate, (Date)endDate);
            backgroundTask = this.markBackgroundTask(backgroundTask, "exported");
            missingReferences = LayoutLocalServiceUtil.validateImportLayoutsFile((long)userId, (long)targetGroupId, (boolean)privateLayout, (Map)parameterMap, (File)file);
            backgroundTask = this.markBackgroundTask(backgroundTask, "validated");
            LayoutLocalServiceUtil.importLayouts((long)userId, (long)targetGroupId, (boolean)privateLayout, (Map)parameterMap, (File)file);
            this.initLayoutSetBranches(userId, sourceGroupId, targetGroupId);
            boolean updateLastPublishDate = MapUtil.getBoolean((Map)parameterMap, (String)"UPDATE_LAST_PUBLISH_DATE");
            if (updateLastPublishDate) {
                StagingUtil.updateLastPublishDate((long)sourceGroupId, (boolean)privateLayout, (Date)lastPublishDate);
            }
        }
        catch (Throwable throwable) {
            FileUtil.delete(file);
            StagingUtil.unlockGroup((long)targetGroupId);
            throw throwable;
        }
        FileUtil.delete((File)file);
        StagingUtil.unlockGroup((long)targetGroupId);
        return this.processMissingReferences(backgroundTask, missingReferences);
    }

    protected void initLayoutSetBranches(long userId, long sourceGroupId, long targetGroupId) throws Exception {
        Group sourceGroup = GroupLocalServiceUtil.getGroup((long)sourceGroupId);
        if (!sourceGroup.hasStagingGroup()) {
            return;
        }
        LayoutSetBranchLocalServiceUtil.deleteLayoutSetBranches((long)targetGroupId, (boolean)false, (boolean)true);
        LayoutSetBranchLocalServiceUtil.deleteLayoutSetBranches((long)targetGroupId, (boolean)true, (boolean)true);
        UnicodeProperties typeSettingsProperties = sourceGroup.getTypeSettingsProperties();
        boolean branchingPrivate = GetterUtil.getBoolean((String)typeSettingsProperties.getProperty("branchingPrivate"));
        boolean branchingPublic = GetterUtil.getBoolean((String)typeSettingsProperties.getProperty("branchingPublic"));
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setUserId(userId);
        StagingUtil.checkDefaultLayoutSetBranches((long)userId, (Group)sourceGroup, (boolean)branchingPublic, (boolean)branchingPrivate, (boolean)false, (ServiceContext)serviceContext);
    }
}

