/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar.backgroundtask;

import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.RemoteExportException;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskResult;
import com.liferay.portal.kernel.lar.ExportImportHelperUtil;
import com.liferay.portal.kernel.lar.MissingReferences;
import com.liferay.portal.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.lar.backgroundtask.BaseStagingBackgroundTaskExecutor;
import com.liferay.portal.model.BackgroundTask;
import com.liferay.portal.model.Layout;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.http.LayoutServiceHttp;
import com.liferay.portal.service.http.StagingServiceHttp;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class LayoutRemoteStagingBackgroundTaskExecutor
extends BaseStagingBackgroundTaskExecutor {
    public BackgroundTaskResult execute(BackgroundTask backgroundTask) throws Exception {
        Map taskContextMap = backgroundTask.getTaskContextMap();
        long sourceGroupId = MapUtil.getLong((Map)taskContextMap, (String)"groupId");
        boolean privateLayout = MapUtil.getBoolean((Map)taskContextMap, (String)"privateLayout");
        Map layoutIdMap = (Map)taskContextMap.get("layoutIdMap");
        Map parameterMap = (Map)taskContextMap.get("parameterMap");
        long remoteGroupId = MapUtil.getLong((Map)taskContextMap, (String)"remoteGroupId");
        Date startDate = (Date)taskContextMap.get("startDate");
        Date endDate = (Date)taskContextMap.get("endDate");
        HttpPrincipal httpPrincipal = (HttpPrincipal)taskContextMap.get("httpPrincipal");
        this.clearBackgroundTaskStatus(backgroundTask);
        long stagingRequestId = 0L;
        File file = null;
        FileInputStream fileInputStream = null;
        MissingReferences missingReferences = null;
        try {
            Date lastPublishDate = endDate;
            if (lastPublishDate == null) {
                lastPublishDate = new Date();
            }
            file = this.exportLayoutsAsFile(sourceGroupId, privateLayout, layoutIdMap, parameterMap, remoteGroupId, startDate, endDate, httpPrincipal);
            String checksum = FileUtil.getMD5Checksum((File)file);
            fileInputStream = new FileInputStream(file);
            stagingRequestId = StagingServiceHttp.createStagingRequest(httpPrincipal, remoteGroupId, checksum);
            byte[] bytes = new byte[PropsValues.STAGING_REMOTE_TRANSFER_BUFFER_SIZE];
            int i2 = 0;
            while ((i2 = fileInputStream.read(bytes)) >= 0) {
                if (i2 < PropsValues.STAGING_REMOTE_TRANSFER_BUFFER_SIZE) {
                    byte[] tempBytes = new byte[i2];
                    System.arraycopy(bytes, 0, tempBytes, 0, i2);
                    StagingServiceHttp.updateStagingRequest(httpPrincipal, stagingRequestId, file.getName(), tempBytes);
                } else {
                    StagingServiceHttp.updateStagingRequest(httpPrincipal, stagingRequestId, file.getName(), bytes);
                }
                bytes = new byte[PropsValues.STAGING_REMOTE_TRANSFER_BUFFER_SIZE];
            }
            backgroundTask = this.markBackgroundTask(backgroundTask, "exported");
            missingReferences = StagingServiceHttp.validateStagingRequest(httpPrincipal, stagingRequestId, privateLayout, parameterMap);
            backgroundTask = this.markBackgroundTask(backgroundTask, "validated");
            StagingServiceHttp.publishStagingRequest(httpPrincipal, stagingRequestId, privateLayout, parameterMap);
            boolean updateLastPublishDate = MapUtil.getBoolean((Map)parameterMap, (String)"UPDATE_LAST_PUBLISH_DATE");
            if (updateLastPublishDate) {
                StagingUtil.updateLastPublishDate((long)sourceGroupId, (boolean)privateLayout, (Date)lastPublishDate);
            }
        }
        catch (Throwable throwable) {
            StreamUtil.cleanUp(fileInputStream);
            FileUtil.delete(file);
            if (stagingRequestId > 0L) {
                StagingServiceHttp.cleanUpStagingRequest(httpPrincipal, stagingRequestId);
            }
            throw throwable;
        }
        StreamUtil.cleanUp((InputStream)fileInputStream);
        FileUtil.delete((File)file);
        if (stagingRequestId > 0L) {
            StagingServiceHttp.cleanUpStagingRequest(httpPrincipal, stagingRequestId);
        }
        return this.processMissingReferences(backgroundTask, missingReferences);
    }

    protected File exportLayoutsAsFile(long sourceGroupId, boolean privateLayout, Map<Long, Boolean> layoutIdMap, Map<String, String[]> parameterMap, long remoteGroupId, Date startDate, Date endDate, HttpPrincipal httpPrincipal) throws Exception {
        if (layoutIdMap == null || layoutIdMap.isEmpty()) {
            return LayoutLocalServiceUtil.exportLayoutsAsFile((long)sourceGroupId, (boolean)privateLayout, null, parameterMap, (Date)startDate, (Date)endDate);
        }
        ArrayList<Layout> layouts = new ArrayList<Layout>();
        for (Map.Entry<Long, Boolean> entry : layoutIdMap.entrySet()) {
            long plid = GetterUtil.getLong((String)String.valueOf(entry.getKey()));
            boolean includeChildren = entry.getValue();
            Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
            if (!layouts.contains(layout)) {
                layouts.add(layout);
            }
            List<Layout> parentLayouts = this.getMissingRemoteParentLayouts(httpPrincipal, layout, remoteGroupId);
            for (Layout parentLayout : parentLayouts) {
                if (layouts.contains(parentLayout)) continue;
                layouts.add(parentLayout);
            }
            if (!includeChildren) continue;
            for (Layout childLayout : layout.getAllChildren()) {
                if (layouts.contains(childLayout)) continue;
                layouts.add(childLayout);
            }
        }
        long[] layoutIds = ExportImportHelperUtil.getLayoutIds(layouts);
        if (layoutIds.length <= 0) {
            throw new RemoteExportException(3);
        }
        return LayoutLocalServiceUtil.exportLayoutsAsFile((long)sourceGroupId, (boolean)privateLayout, (long[])layoutIds, parameterMap, (Date)startDate, (Date)endDate);
    }

    protected List<Layout> getMissingRemoteParentLayouts(HttpPrincipal httpPrincipal, Layout layout, long remoteGroupId) throws Exception {
        ArrayList<Layout> missingRemoteParentLayouts = new ArrayList<Layout>();
        long parentLayoutId = layout.getParentLayoutId();
        while (parentLayoutId > 0L) {
            Layout parentLayout = LayoutLocalServiceUtil.getLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)parentLayoutId);
            try {
                LayoutServiceHttp.getLayoutByUuidAndGroupId(httpPrincipal, parentLayout.getUuid(), remoteGroupId, parentLayout.getPrivateLayout());
                break;
            }
            catch (NoSuchLayoutException noSuchLayoutException) {
                missingRemoteParentLayouts.add(parentLayout);
                parentLayoutId = parentLayout.getParentLayoutId();
            }
        }
        return missingRemoteParentLayouts;
    }
}

