/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar.backgroundtask;

import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatus;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatusMessageTranslator;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.util.LongWrapper;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class DefaultExportImportBackgroundTaskStatusMessageTranslator
implements BackgroundTaskStatusMessageTranslator {
    public void translate(BackgroundTaskStatus backgroundTaskStatus, Message message) {
        String messageType = message.getString("messageType");
        if (messageType.equals("layout")) {
            this.translateLayoutMessage(backgroundTaskStatus, message);
        } else if (messageType.equals("portlet")) {
            this.translatePortletMessage(backgroundTaskStatus, message);
        } else if (messageType.equals("stagedModel")) {
            this.translateStagedModelMessage(backgroundTaskStatus, message);
        }
    }

    protected long getTotal(Map<String, LongWrapper> modelCounters) {
        if (modelCounters == null) {
            return 0L;
        }
        long total = 0L;
        for (Map.Entry<String, LongWrapper> entry : modelCounters.entrySet()) {
            LongWrapper longWrapper = entry.getValue();
            total += longWrapper.getValue();
        }
        return total;
    }

    protected synchronized void translateLayoutMessage(BackgroundTaskStatus backgroundTaskStatus, Message message) {
        Map modelAdditionCounters = (Map)message.get("modelAdditionCounters");
        backgroundTaskStatus.setAttribute("allModelAdditionCounters", new HashMap(modelAdditionCounters));
        backgroundTaskStatus.setAttribute("allModelAdditionCountersTotal", (Serializable)Long.valueOf(this.getTotal(modelAdditionCounters)));
        Map modelDeletionCounters = (Map)message.get("modelDeletionCounters");
        backgroundTaskStatus.setAttribute("allModelDeletionCounters", new HashMap(modelDeletionCounters));
        backgroundTaskStatus.setAttribute("allModelDeletionCountersTotal", (Serializable)Long.valueOf(this.getTotal(modelDeletionCounters)));
    }

    protected synchronized void translatePortletMessage(BackgroundTaskStatus backgroundTaskStatus, Message message) {
        backgroundTaskStatus.clearAttributes();
        Map modelAdditionCounters = (Map)message.get("modelAdditionCounters");
        backgroundTaskStatus.setAttribute("allModelAdditionCounters", new HashMap(modelAdditionCounters));
        backgroundTaskStatus.setAttribute("allModelAdditionCountersTotal", (Serializable)Long.valueOf(this.getTotal(modelAdditionCounters)));
        Map modelDeletionCounters = (Map)message.get("modelDeletionCounters");
        backgroundTaskStatus.setAttribute("allModelDeletionCounters", new HashMap(modelDeletionCounters));
        backgroundTaskStatus.setAttribute("allModelDeletionCountersTotal", (Serializable)Long.valueOf(this.getTotal(modelDeletionCounters)));
        String portletId = message.getString("portletId");
        backgroundTaskStatus.setAttribute("portletId", (Serializable)((Object)portletId));
    }

    protected synchronized void translateStagedModelMessage(BackgroundTaskStatus backgroundTaskStatus, Message message) {
        String portletId = (String)((Object)backgroundTaskStatus.getAttribute("portletId"));
        if (Validator.isNull((String)portletId)) {
            return;
        }
        Map modelAdditionCounters = (Map)message.get("modelAdditionCounters");
        backgroundTaskStatus.setAttribute("currentModelAdditionCounters", new HashMap(modelAdditionCounters));
        backgroundTaskStatus.setAttribute("currentModelAdditionCountersTotal", (Serializable)Long.valueOf(this.getTotal(modelAdditionCounters)));
        Map modelDeletionCounters = (Map)message.get("modelDeletionCounters");
        backgroundTaskStatus.setAttribute("currentModelDeletionCounters", new HashMap(modelDeletionCounters));
        backgroundTaskStatus.setAttribute("currentModelDeletionCountersTotal", (Serializable)Long.valueOf(this.getTotal(modelDeletionCounters)));
        String stagedModelName = message.getString("stagedModelName");
        backgroundTaskStatus.setAttribute("stagedModelName", (Serializable)((Object)stagedModelName));
        String stagedModelType = message.getString("stagedModelType");
        backgroundTaskStatus.setAttribute("stagedModelType", (Serializable)((Object)stagedModelType));
        String uuid = message.getString("uuid");
        backgroundTaskStatus.setAttribute("uuid", (Serializable)((Object)uuid));
    }
}

