/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar;

import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutSetBranch;
import com.liferay.portlet.layoutsadmin.lar.StagedTheme;
import java.util.Map;

public class ThemeExporter {
    private static Log _log = LogFactoryUtil.getLog(ThemeExporter.class);

    public void exportTheme(PortletDataContext portletDataContext, LayoutSet layoutSet) throws Exception {
        boolean exportThemeSettings = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"THEME_REFERENCE");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Export theme settings " + exportThemeSettings));
        }
        if (!exportThemeSettings) {
            return;
        }
        StagedTheme stagedTheme = new StagedTheme(layoutSet.getTheme());
        if (!portletDataContext.isPerformDirectBinaryImport()) {
            Element layoutSetElement = portletDataContext.getExportDataElement((ClassedModel)layoutSet);
            portletDataContext.addReferenceElement((ClassedModel)layoutSet, layoutSetElement, (ClassedModel)stagedTheme, "dependency", true);
        }
        this.exportThemeSettings(portletDataContext, stagedTheme.getThemeId(), layoutSet.getColorSchemeId(), layoutSet.getCss());
    }

    public void exportTheme(PortletDataContext portletDataContext, LayoutSetBranch layoutSetBranch) throws Exception {
        boolean exportThemeSettings = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"THEME_REFERENCE");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Export theme settings " + exportThemeSettings));
        }
        if (!exportThemeSettings) {
            return;
        }
        StagedTheme stagedTheme = new StagedTheme(layoutSetBranch.getTheme());
        if (!portletDataContext.isPerformDirectBinaryImport()) {
            Element layoutSetBranchElement = portletDataContext.getExportDataElement((ClassedModel)layoutSetBranch);
            portletDataContext.addReferenceElement((ClassedModel)layoutSetBranch, layoutSetBranchElement, (ClassedModel)stagedTheme, "dependency", true);
        }
        this.exportThemeSettings(portletDataContext, stagedTheme.getThemeId(), layoutSetBranch.getColorSchemeId(), layoutSetBranch.getCss());
    }

    protected void exportThemeSettings(PortletDataContext portletDataContext, String themeId, String colorSchemeId, String css) throws Exception {
        Element exportDataRootElement = portletDataContext.getExportDataRootElement();
        Element headerElement = exportDataRootElement.element("header");
        headerElement.addAttribute("theme-id", themeId);
        headerElement.addAttribute("color-scheme-id", colorSchemeId);
        Element cssElement = headerElement.addElement("css");
        cssElement.addCDATA(css);
    }
}

