/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar;

import com.liferay.portal.kernel.backgroundtask.BackgroundTaskThreadLocal;
import com.liferay.portal.kernel.lar.ManifestSummary;
import com.liferay.portal.kernel.lar.PortletDataHandlerStatusMessageSender;
import com.liferay.portal.kernel.lar.StagedModelDataHandler;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerRegistryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.sender.SingleDestinationMessageSender;
import com.liferay.portal.model.StagedModel;
import java.util.Map;

public class PortletDataHandlerStatusMessageSenderImpl
implements PortletDataHandlerStatusMessageSender {
    private SingleDestinationMessageSender _singleDestinationMessageSender;

    public void sendStatusMessage(String messageType, ManifestSummary manifestSummary) {
        if (!BackgroundTaskThreadLocal.hasBackgroundTask()) {
            return;
        }
        Message message = this.createMessage(messageType, manifestSummary);
        this._singleDestinationMessageSender.send(message);
    }

    public void sendStatusMessage(String messageType, String portletId, ManifestSummary manifestSummary) {
        if (!BackgroundTaskThreadLocal.hasBackgroundTask()) {
            return;
        }
        Message message = this.createMessage(messageType, manifestSummary);
        message.put("portletId", (Object)portletId);
        this._singleDestinationMessageSender.send(message);
    }

    public <T extends StagedModel> void sendStatusMessage(String messageType, T stagedModel, ManifestSummary manifestSummary) {
        if (!BackgroundTaskThreadLocal.hasBackgroundTask()) {
            return;
        }
        Message message = this.createMessage(messageType, manifestSummary);
        StagedModelDataHandler stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler((String)stagedModel.getModelClassName());
        message.put("stagedModelName", (Object)stagedModelDataHandler.getDisplayName(stagedModel));
        message.put("stagedModelType", (Object)String.valueOf(stagedModel.getStagedModelType()));
        message.put("uuid", (Object)stagedModel.getUuid());
        this._singleDestinationMessageSender.send(message);
    }

    public void setSingleDestinationMessageSender(SingleDestinationMessageSender singleDestinationMessageSender) {
        this._singleDestinationMessageSender = singleDestinationMessageSender;
    }

    protected Message createMessage(String messageType, ManifestSummary manifestSummary) {
        Message message = new Message();
        message.put("backgroundTaskId", (Object)BackgroundTaskThreadLocal.getBackgroundTaskId());
        message.put("messageType", (Object)messageType);
        Map modelAdditionCounters = manifestSummary.getModelAdditionCounters();
        message.put("modelAdditionCounters", (Object)modelAdditionCounters);
        Map modelDeletionCounters = manifestSummary.getModelDeletionCounters();
        message.put("modelDeletionCounters", (Object)modelDeletionCounters);
        return message;
    }
}

