/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar;

import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataContextFactory;
import com.liferay.portal.kernel.lar.PortletDataException;
import com.liferay.portal.kernel.lar.UserIdStrategy;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.zip.ZipReader;
import com.liferay.portal.kernel.zip.ZipWriter;
import com.liferay.portal.lar.PortletDataContextImpl;
import com.liferay.portal.model.Group;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;

public class PortletDataContextFactoryImpl
implements PortletDataContextFactory {
    public PortletDataContext clonePortletDataContext(PortletDataContext portletDataContext) {
        PortletDataContextImpl clonePortletDataContext = new PortletDataContextImpl();
        clonePortletDataContext.setCompanyId(portletDataContext.getCompanyId());
        clonePortletDataContext.setCompanyGroupId(portletDataContext.getCompanyGroupId());
        clonePortletDataContext.setDataStrategy(portletDataContext.getDataStrategy());
        clonePortletDataContext.setEndDate(portletDataContext.getEndDate());
        clonePortletDataContext.setGroupId(portletDataContext.getGroupId());
        clonePortletDataContext.setNewLayouts(portletDataContext.getNewLayouts());
        clonePortletDataContext.setParameterMap(portletDataContext.getParameterMap());
        clonePortletDataContext.setScopeGroupId(portletDataContext.getScopeGroupId());
        clonePortletDataContext.setStartDate(portletDataContext.getStartDate());
        clonePortletDataContext.setUserIdStrategy(portletDataContext.getUserIdStrategy());
        clonePortletDataContext.setUserPersonalSiteGroupId(portletDataContext.getUserPersonalSiteGroupId());
        return clonePortletDataContext;
    }

    public PortletDataContext createExportPortletDataContext(long companyId, long groupId, Map<String, String[]> parameterMap, Date startDate, Date endDate, ZipWriter zipWriter) throws PortletDataException {
        this.validateDateRange(startDate, endDate);
        PortletDataContext portletDataContext = this.createPortletDataContext(companyId, groupId);
        portletDataContext.setEndDate(endDate);
        portletDataContext.setParameterMap(parameterMap);
        portletDataContext.setStartDate(startDate);
        portletDataContext.setZipWriter(zipWriter);
        return portletDataContext;
    }

    public PortletDataContext createImportPortletDataContext(long companyId, long groupId, Map<String, String[]> parameterMap, UserIdStrategy userIdStrategy, ZipReader zipReader) {
        PortletDataContext portletDataContext = this.createPortletDataContext(companyId, groupId);
        String dataStrategy = MapUtil.getString(parameterMap, (String)"DATA_STRATEGY", (String)"DATA_STRATEGY_MIRROR");
        portletDataContext.setDataStrategy(dataStrategy);
        portletDataContext.setNewLayouts(new ArrayList());
        portletDataContext.setParameterMap(parameterMap);
        portletDataContext.setUserIdStrategy(userIdStrategy);
        portletDataContext.setZipReader(zipReader);
        return portletDataContext;
    }

    public PortletDataContext createPreparePortletDataContext(ThemeDisplay themeDisplay, Date startDate, Date endDate) throws PortletDataException {
        this.validateDateRange(startDate, endDate);
        PortletDataContext portletDataContext = this.createPortletDataContext(themeDisplay.getCompanyId(), themeDisplay.getScopeGroupId());
        portletDataContext.setEndDate(endDate);
        portletDataContext.setStartDate(startDate);
        return portletDataContext;
    }

    protected PortletDataContext createPortletDataContext(long companyId, long groupId) {
        PortletDataContextImpl portletDataContext;
        block5: {
            block4: {
                portletDataContext = new PortletDataContextImpl();
                try {
                    Group companyGroup = GroupLocalServiceUtil.getCompanyGroup((long)companyId);
                    portletDataContext.setCompanyGroupId(companyGroup.getGroupId());
                }
                catch (Exception e2) {
                    if (CompanyThreadLocal.isDeleteInProcess()) break block4;
                    throw new IllegalStateException(e2);
                }
            }
            portletDataContext.setCompanyId(companyId);
            portletDataContext.setGroupId(groupId);
            portletDataContext.setScopeGroupId(groupId);
            try {
                Group userPersonalSiteGroup = GroupLocalServiceUtil.getUserPersonalSiteGroup((long)companyId);
                portletDataContext.setUserPersonalSiteGroupId(userPersonalSiteGroup.getGroupId());
            }
            catch (Exception e3) {
                if (CompanyThreadLocal.isDeleteInProcess()) break block5;
                throw new IllegalStateException(e3);
            }
        }
        return portletDataContext;
    }

    protected void validateDateRange(Date startDate, Date endDate) throws PortletDataException {
        if (startDate == null && endDate != null) {
            throw new PortletDataException(1);
        }
        if (startDate != null && endDate == null) {
            throw new PortletDataException(5);
        }
        if (startDate != null) {
            if (startDate.after(endDate) || startDate.equals(endDate)) {
                throw new PortletDataException(4);
            }
            Date now = new Date();
            if (startDate.after(now)) {
                throw new PortletDataException(3);
            }
            if (endDate.after(now)) {
                throw new PortletDataException(2);
            }
        }
    }
}

