/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar;

import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.PrimitiveLongList;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.lar.LayoutCache;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PermissionExporter {
    public static final String ROLE_TEAM_PREFIX = "ROLE_TEAM_,*";

    protected void exportPermissions(LayoutCache layoutCache, long companyId, long groupId, String resourceName, String resourcePrimKey, Element permissionsElement, boolean portletActions) throws Exception {
        List<Role> roles = layoutCache.getGroupRoles(groupId, resourceName);
        List actionIds = null;
        actionIds = portletActions ? ResourceActionsUtil.getPortletResourceActions((String)resourceName) : ResourceActionsUtil.getModelResourceActions((String)resourceName);
        if (actionIds.isEmpty()) {
            return;
        }
        PrimitiveLongList roleIds = new PrimitiveLongList(roles.size());
        HashMap<Long, Role> roleIdsToRoles = new HashMap<Long, Role>();
        for (Role role : roles) {
            String name = role.getName();
            if (name.equals("Administrator")) continue;
            roleIds.add(role.getRoleId());
            roleIdsToRoles.put(role.getRoleId(), role);
        }
        Map roleIdsToActionIds = ResourcePermissionLocalServiceUtil.getAvailableResourcePermissionActionIds((long)companyId, (String)resourceName, (int)4, (String)resourcePrimKey, (long[])roleIds.getArray(), (Collection)actionIds);
        for (Role role : roleIdsToRoles.values()) {
            Set availableActionIds = (Set)roleIdsToActionIds.get(role.getRoleId());
            Element roleElement = permissionsElement.addElement("role");
            roleElement.addAttribute("name", role.getName());
            roleElement.addAttribute("title", role.getTitle());
            roleElement.addAttribute("description", role.getDescription());
            roleElement.addAttribute("type", String.valueOf(role.getType()));
            roleElement.addAttribute("subtype", role.getSubtype());
            if (availableActionIds == null || availableActionIds.isEmpty()) continue;
            for (String action : availableActionIds) {
                Element actionKeyElement = roleElement.addElement("action-key");
                actionKeyElement.addText(action);
            }
        }
    }

    protected void exportPortletDataPermissions(PortletDataContext portletDataContext) throws Exception {
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("portlet-data-permissions");
        Map permissionsMap = portletDataContext.getPermissions();
        for (Map.Entry entry : permissionsMap.entrySet()) {
            String[] permissionParts = StringUtil.split((String)((String)entry.getKey()), (char)'#');
            String resourceName = permissionParts[0];
            long resourcePK = GetterUtil.getLong((String)permissionParts[1]);
            Element portletDataElement = rootElement.addElement("portlet-data");
            portletDataElement.addAttribute("resource-name", resourceName);
            portletDataElement.addAttribute("resource-pk", String.valueOf(resourcePK));
            List permissions = (List)entry.getValue();
            for (KeyValuePair permission : permissions) {
                String roleName = permission.getKey();
                String actions = permission.getValue();
                Element permissionsElement = portletDataElement.addElement("permissions");
                permissionsElement.addAttribute("role-name", roleName);
                permissionsElement.addAttribute("actions", actions);
            }
        }
        portletDataContext.addZipEntry(String.valueOf(ExportImportPathUtil.getRootPath((PortletDataContext)portletDataContext)) + "/portlet-data-permissions.xml", document.formattedString());
    }

    protected void exportPortletPermissions(PortletDataContext portletDataContext, LayoutCache layoutCache, String portletId, Layout layout, Element portletElement) throws Exception {
        long companyId = portletDataContext.getCompanyId();
        long groupId = portletDataContext.getGroupId();
        String resourceName = PortletConstants.getRootPortletId((String)portletId);
        String resourcePrimKey = PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)portletId);
        Element permissionsElement = portletElement.addElement("permissions");
        this.exportPermissions(layoutCache, companyId, groupId, resourceName, resourcePrimKey, permissionsElement, true);
    }

    protected Element exportRoles(long companyId, String resourceName, int scope, String resourcePrimKey, Element parentElement, String elName, List<Role> roles) throws Exception {
        Element element = parentElement.addElement(elName);
        Map resourceRoles = RoleLocalServiceUtil.getResourceRoles((long)companyId, (String)resourceName, (int)scope, (String)resourcePrimKey);
        for (Map.Entry entry : resourceRoles.entrySet()) {
            String roleName = (String)entry.getKey();
            if (!this.hasRole(roles, roleName)) continue;
            Element roleElement = element.addElement("role");
            roleElement.addAttribute("name", roleName);
            List actions = (List)entry.getValue();
            for (String action : actions) {
                Element actionKeyElement = roleElement.addElement("action-key");
                actionKeyElement.addText(action);
                actionKeyElement.addAttribute("scope", String.valueOf(scope));
            }
        }
        return element;
    }

    protected void exportUserRoles(LayoutCache layoutCache, long companyId, long groupId, String resourceName, Element parentElement) throws Exception {
        Element userRolesElement = SAXReaderUtil.createElement((String)"user-roles");
        List<User> users = layoutCache.getGroupUsers(groupId);
        for (User user : users) {
            long userId = user.getUserId();
            String uuid = user.getUuid();
            List<Role> userRoles = layoutCache.getUserRoles(userId);
            Element userElement = this.exportRoles(companyId, resourceName, 2, String.valueOf(groupId), userRolesElement, "user", userRoles);
            if (userElement.elements().isEmpty()) {
                userRolesElement.remove(userElement);
                continue;
            }
            userElement.addAttribute("uuid", uuid);
        }
        if (!userRolesElement.elements().isEmpty()) {
            parentElement.add(userRolesElement);
        }
    }

    protected boolean hasRole(List<Role> roles, String roleName) {
        if (roles == null || roles.size() == 0) {
            return false;
        }
        for (Role role : roles) {
            if (!roleName.equals(role.getName())) continue;
            return true;
        }
        return false;
    }
}

