/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jsonwebservice;

import com.liferay.portal.action.JSONServiceAction;
import com.liferay.portal.jsonwebservice.action.JSONWebServiceDiscoverAction;
import com.liferay.portal.jsonwebservice.action.JSONWebServiceInvokerAction;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceAction;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceActionsManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upload.UploadException;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.lang.reflect.InvocationTargetException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

public class JSONWebServiceServiceAction
extends JSONServiceAction {
    private static final String _REROUTE_PATH = "/jsonws";
    private static Log _log = LogFactoryUtil.getLog(JSONWebServiceServiceAction.class);

    @Override
    public String getJSON(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        UploadException uploadException = (UploadException)request.getAttribute("UPLOAD_EXCEPTION");
        if (uploadException != null) {
            return JSONFactoryUtil.serializeException((Exception)uploadException);
        }
        JSONWebServiceAction jsonWebServiceAction = null;
        try {
            jsonWebServiceAction = this.getJSONWebServiceAction(request);
            Object returnObj = jsonWebServiceAction.invoke();
            if (returnObj != null) {
                return this.getReturnValue(returnObj);
            }
            return JSONFactoryUtil.getNullJSON();
        }
        catch (InvocationTargetException ite) {
            Throwable throwable = ite.getCause();
            if (throwable instanceof SecurityException) {
                throw (SecurityException)throwable;
            }
            _log.error((Object)throwable, throwable);
            return JSONFactoryUtil.serializeThrowable((Throwable)throwable);
        }
        catch (Exception e2) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e2, (Throwable)e2);
            }
            return JSONFactoryUtil.serializeException((Exception)e2);
        }
    }

    @Override
    protected String getCSRFOrigin(HttpServletRequest request) {
        String uri = request.getRequestURI();
        int x = uri.indexOf("jsonws/");
        if (x < 0) {
            return ClassUtil.getClassName((Object)((Object)this));
        }
        String path = uri.substring(x + 7);
        String[] pathArray = StringUtil.split((String)path, (char)'/');
        if (pathArray.length < 2) {
            return ClassUtil.getClassName((Object)((Object)this));
        }
        StringBundler sb = new StringBundler(6);
        sb.append(ClassUtil.getClassName((Object)((Object)this)));
        sb.append(":");
        sb.append("/");
        String serviceClassName = pathArray[0];
        sb.append(serviceClassName);
        sb.append("/");
        String serviceMethodName = pathArray[1];
        sb.append(serviceMethodName);
        return sb.toString();
    }

    protected JSONWebServiceAction getJSONWebServiceAction(HttpServletRequest request) {
        String path = GetterUtil.getString((String)request.getPathInfo());
        if (path.equals("/invoke")) {
            return new JSONWebServiceInvokerAction(request);
        }
        if (request.getParameter("discover") != null) {
            return new JSONWebServiceDiscoverAction(request);
        }
        return JSONWebServiceActionsManagerUtil.getJSONWebServiceAction((HttpServletRequest)request);
    }

    @Override
    protected String getReroutePath() {
        return _REROUTE_PATH;
    }
}

