/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.increment;

import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.util.PropsUtil;

public class BufferedIncrementConfiguration {
    private static Log _log = LogFactoryUtil.getLog(BufferedIncrementConfiguration.class);
    private final boolean _enabled;
    private final boolean _standbyEnabled;
    private final int _standbyQueueThreshold;
    private final long _standbyTimeUpperLimit;
    private final long _threadpoolKeepAliveTime;
    private final int _threadpoolMaxSize;

    public BufferedIncrementConfiguration(String configuration) {
        Filter filter = new Filter(configuration);
        this._enabled = GetterUtil.getBoolean((String)PropsUtil.get("buffered.increment.enabled", filter));
        this._standbyQueueThreshold = GetterUtil.getInteger((String)PropsUtil.get("buffered.increment.standby.queue.threshold", filter));
        this._standbyTimeUpperLimit = GetterUtil.getLong((String)PropsUtil.get("buffered.increment.standby.time.upper.limit", filter));
        long threadpoolKeepAliveTime = GetterUtil.getLong((String)PropsUtil.get("buffered.increment.threadpool.keep.alive.time", filter));
        if (threadpoolKeepAliveTime < 0L) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("buffered.increment.threadpool.keep.alive.time[" + configuration + "]=" + threadpoolKeepAliveTime + ". Auto reset to 0."));
            }
            threadpoolKeepAliveTime = 0L;
        }
        this._threadpoolKeepAliveTime = threadpoolKeepAliveTime;
        int threadpoolMaxSize = GetterUtil.getInteger((String)PropsUtil.get("buffered.increment.threadpool.max.size", filter));
        if (threadpoolMaxSize < 1) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("buffered.increment.threadpool.max.size[" + configuration + "]=" + threadpoolMaxSize + ". Auto reset to 1."));
            }
            threadpoolMaxSize = 1;
        }
        this._threadpoolMaxSize = threadpoolMaxSize;
        this._standbyEnabled = this._standbyQueueThreshold > 0 && this._standbyTimeUpperLimit > 0L;
    }

    public long calculateStandbyTime(int queueLength) {
        if (queueLength < 0) {
            throw new IllegalArgumentException("Negative queue length " + queueLength);
        }
        if (!this._standbyEnabled) {
            throw new IllegalStateException("Standby is disabled");
        }
        if (queueLength > this._standbyQueueThreshold) {
            return 0L;
        }
        return (long)(this._standbyQueueThreshold - queueLength) * this._standbyTimeUpperLimit * 1000L / (long)this._standbyQueueThreshold;
    }

    public int getStandbyQueueThreshold() {
        return this._standbyQueueThreshold;
    }

    public long getStandbyTimeUpperLimit() {
        return this._standbyTimeUpperLimit;
    }

    public long getThreadpoolKeepAliveTime() {
        return this._threadpoolKeepAliveTime;
    }

    public int getThreadpoolMaxSize() {
        return this._threadpoolMaxSize;
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public boolean isStandbyEnabled() {
        return this._standbyEnabled;
    }
}

