/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.facebook;

import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.BufferCacheServletResponse;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.servlet.filters.gzip.GZipFilter;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.social.util.FacebookUtil;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FacebookServlet
extends HttpServlet {
    private static Log _log = LogFactoryUtil.getLog(FacebookServlet.class);

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            String[] facebookData = FacebookUtil.getFacebookData(request);
            if (facebookData == null || !PortalUtil.isValidResourceId((String)facebookData[1])) {
                PortalUtil.sendError((int)404, (Exception)((Object)new NoSuchLayoutException()), (HttpServletRequest)request, (HttpServletResponse)response);
            } else {
                String facebookCanvasPageURL = facebookData[0];
                String redirect = facebookData[1];
                request.setAttribute("FACEBOOK_CANVAS_PAGE_URL", (Object)facebookCanvasPageURL);
                request.setAttribute(GZipFilter.SKIP_FILTER, (Object)Boolean.TRUE);
                ServletContext servletContext = this.getServletContext();
                RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(redirect);
                BufferCacheServletResponse bufferCacheServletResponse = new BufferCacheServletResponse(response);
                requestDispatcher.forward((ServletRequest)request, (ServletResponse)bufferCacheServletResponse);
                String fbml = bufferCacheServletResponse.getString();
                fbml = this.fixFbml(fbml);
                ServletResponseUtil.write((HttpServletResponse)response, (String)fbml);
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            PortalUtil.sendError((int)500, (Exception)e2, (HttpServletRequest)request, (HttpServletResponse)response);
        }
    }

    protected String fixFbml(String fbml) {
        fbml = StringUtil.replace((String)fbml, (String[])new String[]{"<nobr>", "</nobr>"}, (String[])new String[]{"", ""});
        return fbml;
    }
}

