/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.facebook;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.facebook.FacebookConnect;
import com.liferay.portal.kernel.facebook.FacebookConnectUtil;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

@DoPrivileged
public class FacebookConnectImpl
implements FacebookConnect {
    private static Log _log = LogFactoryUtil.getLog(FacebookConnectImpl.class);

    public String getAccessToken(long companyId, String redirect, String code) throws SystemException {
        String url = HttpUtil.addParameter((String)this.getAccessTokenURL(companyId), (String)"client_id", (String)this.getAppId(companyId));
        url = HttpUtil.addParameter((String)url, (String)"redirect_uri", (String)FacebookConnectUtil.getRedirectURL((long)companyId));
        String facebookConnectRedirectURL = this.getRedirectURL(companyId);
        facebookConnectRedirectURL = HttpUtil.addParameter((String)facebookConnectRedirectURL, (String)"redirect", (String)redirect);
        url = HttpUtil.addParameter((String)url, (String)"redirect_uri", (String)facebookConnectRedirectURL);
        url = HttpUtil.addParameter((String)url, (String)"client_secret", (String)this.getAppSecret(companyId));
        url = HttpUtil.addParameter((String)url, (String)"code", (String)code);
        Http.Options options = new Http.Options();
        options.setLocation(url);
        options.setPost(true);
        try {
            int x;
            String content = HttpUtil.URLtoString((Http.Options)options);
            if (Validator.isNotNull((String)content) && (x = content.indexOf("access_token=")) >= 0) {
                int y = content.indexOf(38, x);
                if (y < x) {
                    y = content.length();
                }
                return content.substring(x + 13, y);
            }
        }
        catch (Exception e2) {
            throw new SystemException("Unable to retrieve Facebook access token", (Throwable)e2);
        }
        return null;
    }

    public String getAccessTokenURL(long companyId) throws SystemException {
        return PrefsPropsUtil.getString(companyId, "facebook.connect.oauth.token.url", PropsValues.FACEBOOK_CONNECT_OAUTH_TOKEN_URL);
    }

    public String getAppId(long companyId) throws SystemException {
        return PrefsPropsUtil.getString(companyId, "facebook.connect.app.id", PropsValues.FACEBOOK_CONNECT_APP_ID);
    }

    public String getAppSecret(long companyId) throws SystemException {
        return PrefsPropsUtil.getString(companyId, "facebook.connect.app.secret", PropsValues.FACEBOOK_CONNECT_APP_SECRET);
    }

    public String getAuthURL(long companyId) throws SystemException {
        return PrefsPropsUtil.getString(companyId, "facebook.connect.oauth.auth.url", PropsValues.FACEBOOK_CONNECT_OAUTH_AUTH_URL);
    }

    public JSONObject getGraphResources(long companyId, String path, String accessToken, String fields) {
        try {
            String url = HttpUtil.addParameter((String)this.getGraphURL(companyId).concat(path), (String)"access_token", (String)accessToken);
            if (Validator.isNotNull((String)fields)) {
                url = HttpUtil.addParameter((String)url, (String)"fields", (String)fields);
            }
            Http.Options options = new Http.Options();
            options.setLocation(url);
            String json = HttpUtil.URLtoString((Http.Options)options);
            return JSONFactoryUtil.createJSONObject((String)json);
        }
        catch (Exception e2) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e2, (Throwable)e2);
            }
            return null;
        }
    }

    public String getGraphURL(long companyId) throws SystemException {
        return PrefsPropsUtil.getString(companyId, "facebook.connect.graph.url", PropsValues.FACEBOOK_CONNECT_GRAPH_URL);
    }

    public String getProfileImageURL(PortletRequest portletRequest) {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        HttpSession session = (request = PortalUtil.getOriginalServletRequest((HttpServletRequest)request)).getSession();
        String facebookId = (String)session.getAttribute("FACEBOOK_USER_ID");
        if (Validator.isNull((String)facebookId)) {
            return null;
        }
        long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
        String token = (String)session.getAttribute("FACEBOOK_ACCESS_TOKEN");
        JSONObject jsonObject = this.getGraphResources(companyId, "/me", token, "id,picture");
        return jsonObject.getString("picture");
    }

    public String getRedirectURL(long companyId) throws SystemException {
        return PrefsPropsUtil.getString(companyId, "facebook.connect.oauth.redirect.url", PropsValues.FACEBOOK_CONNECT_OAUTH_REDIRECT_URL);
    }

    public boolean isEnabled(long companyId) throws SystemException {
        return PrefsPropsUtil.getBoolean(companyId, "facebook.connect.auth.enabled", PropsValues.FACEBOOK_CONNECT_AUTH_ENABLED);
    }

    public boolean isVerifiedAccountRequired(long companyId) throws SystemException {
        return PrefsPropsUtil.getBoolean(companyId, "facebook.connect.verified.account.required", PropsValues.FACEBOOK_CONNECT_VERIFIED_ACCOUNT_REQUIRED);
    }
}

