/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.editor.fckeditor.command;

import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class CommandArgument {
    private String _command;
    private String _currentFolder;
    private String _newFolder;
    private HttpServletRequest _request;
    private ThemeDisplay _themeDisplay;
    private String _type;

    public CommandArgument(String command, String type, String currentFolder, String newFolder, ThemeDisplay themeDisplay, HttpServletRequest request) {
        this._command = command;
        this._type = type;
        this._currentFolder = currentFolder;
        this._newFolder = newFolder;
        this._themeDisplay = themeDisplay;
        this._request = request;
    }

    public String getCommand() {
        return this._command;
    }

    public long getCompanyId() {
        return this._themeDisplay.getCompanyId();
    }

    public String getCurrentFolder() {
        return this._currentFolder;
    }

    public Group getCurrentGroup() throws Exception {
        long groupId;
        Group group;
        String currentGroupName = this.getCurrentGroupName();
        int pos = currentGroupName.indexOf(" - ");
        if (pos > 0 && (group = GroupLocalServiceUtil.getGroup((long)(groupId = GetterUtil.getLong((String)currentGroupName.substring(0, pos))))).getCompanyId() == this.getCompanyId()) {
            return group;
        }
        throw new NoSuchGroupException();
    }

    public String getCurrentGroupName() {
        if (this._currentFolder.equals("/")) {
            return "";
        }
        StringTokenizer st = new StringTokenizer(this._currentFolder, "/");
        return st.nextToken();
    }

    public HttpServletRequest getHttpServletRequest() {
        return this._request;
    }

    public Locale getLocale() {
        return this._themeDisplay.getLocale();
    }

    public String getNewFolder() {
        return this._newFolder;
    }

    public long getPlid() throws Exception {
        long plid = this._themeDisplay.getPlid();
        Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
        Group group = this.getCurrentGroup();
        if (layout.getGroupId() != group.getGroupId()) {
            plid = LayoutLocalServiceUtil.getDefaultPlid((long)group.getGroupId());
        }
        return plid;
    }

    public ThemeDisplay getThemeDisplay() {
        return this._themeDisplay;
    }

    public String getType() {
        return this._type;
    }

    public long getUserId() {
        return this._themeDisplay.getUserId();
    }
}

