/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.hot;

import com.liferay.portal.kernel.deploy.hot.BaseHotDeployListener;
import com.liferay.portal.kernel.deploy.hot.HotDeployEvent;
import com.liferay.portal.kernel.deploy.hot.HotDeployException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.template.TemplateResourceLoaderUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.model.Theme;
import com.liferay.portal.service.ThemeLocalServiceUtil;
import com.liferay.portal.util.ClassLoaderUtil;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;

public class ThemeHotDeployListener
extends BaseHotDeployListener {
    private static Log _log = LogFactoryUtil.getLog(ThemeHotDeployListener.class);
    private static Map<String, List<Theme>> _themes = new HashMap<String, List<Theme>>();

    public void invokeDeploy(HotDeployEvent hotDeployEvent) throws HotDeployException {
        try {
            this.doInvokeDeploy(hotDeployEvent);
        }
        catch (Throwable t) {
            this.throwHotDeployException(hotDeployEvent, "Error registering themes for " + hotDeployEvent.getServletContextName(), t);
        }
    }

    public void invokeUndeploy(HotDeployEvent hotDeployEvent) throws HotDeployException {
        try {
            this.doInvokeUndeploy(hotDeployEvent);
        }
        catch (Throwable t) {
            this.throwHotDeployException(hotDeployEvent, "Error unregistering themes for " + hotDeployEvent.getServletContextName(), t);
        }
    }

    protected void doInvokeDeploy(HotDeployEvent hotDeployEvent) throws Exception {
        String[] xmls;
        ServletContext servletContext = hotDeployEvent.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking deploy for " + servletContextName));
        }
        if ((xmls = new String[]{HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/liferay-look-and-feel.xml"))})[0] == null) {
            return;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Registering themes for " + servletContextName));
        }
        List themes = ThemeLocalServiceUtil.init((String)servletContextName, (ServletContext)servletContext, null, (boolean)true, (String[])xmls, (PluginPackage)hotDeployEvent.getPluginPackage());
        _themes.put(servletContextName, themes);
        servletContext.setAttribute("PLUGIN_THEMES", (Object)themes);
        if (_log.isInfoEnabled()) {
            if (themes.size() == 1) {
                _log.info((Object)("1 theme for " + servletContextName + " is available for use"));
            } else {
                _log.info((Object)(String.valueOf(themes.size()) + " themes for " + servletContextName + " are available for use"));
            }
        }
    }

    protected void doInvokeUndeploy(HotDeployEvent hotDeployEvent) throws Exception {
        List<Theme> themes;
        ServletContext servletContext = hotDeployEvent.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking undeploy for " + servletContextName));
        }
        if ((themes = _themes.remove(servletContextName)) != null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Unregistering themes for " + servletContextName));
            }
            try {
                ThemeLocalServiceUtil.uninstallThemes(themes);
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
            }
        } else {
            return;
        }
        ClassLoader contextClassLoader = ClassLoaderUtil.getContextClassLoader();
        try {
            ClassLoaderUtil.setContextClassLoader(ClassLoaderUtil.getPortalClassLoader());
            TemplateResourceLoaderUtil.clearCache((String)"vm");
        }
        finally {
            ClassLoaderUtil.setContextClassLoader(contextClassLoader);
        }
        if (_log.isInfoEnabled()) {
            if (themes.size() == 1) {
                _log.info((Object)("1 theme for " + servletContextName + " was unregistered"));
            } else {
                _log.info((Object)(String.valueOf(themes.size()) + " themes for " + servletContextName + " were unregistered"));
            }
        }
    }
}

