/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.hot;

import com.liferay.portal.dao.orm.hibernate.region.LiferayEhcacheRegionFactory;
import com.liferay.portal.dao.orm.hibernate.region.SingletonLiferayEhcacheRegionFactory;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.configuration.ConfigurationFactoryUtil;
import com.liferay.portal.kernel.deploy.hot.BaseHotDeployListener;
import com.liferay.portal.kernel.deploy.hot.HotDeployEvent;
import com.liferay.portal.kernel.deploy.hot.HotDeployException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.util.AggregateClassLoader;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.plugin.PluginPackageUtil;
import com.liferay.portal.service.ServiceComponentLocalServiceUtil;
import com.liferay.portal.util.ClassLoaderUtil;
import com.liferay.util.log4j.Log4JUtil;
import com.liferay.util.portlet.PortletProps;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Properties;
import javax.servlet.ServletContext;

public class PluginPackageHotDeployListener
extends BaseHotDeployListener {
    public static final String SERVICE_BUILDER_PROPERTIES = "SERVICE_BUILDER_PROPERTIES";
    private static final String _MULTI_VM_PORTAL_CACHE_MANAGER_BEAN_NAME = "com.liferay.portal.kernel.cache.MultiVMPortalCacheManager";
    private static final String _SINGLE_VM_PORTAL_CACHE_MANAGER_BEAN_NAME = "com.liferay.portal.kernel.cache.SingleVMPortalCacheManager";
    private static Log _log = LogFactoryUtil.getLog(PluginPackageHotDeployListener.class);

    public void invokeDeploy(HotDeployEvent hotDeployEvent) throws HotDeployException {
        try {
            this.doInvokeDeploy(hotDeployEvent);
        }
        catch (Throwable t) {
            this.throwHotDeployException(hotDeployEvent, "Error registering plugins for " + hotDeployEvent.getServletContextName(), t);
        }
    }

    public void invokeUndeploy(HotDeployEvent hotDeployEvent) throws HotDeployException {
        try {
            this.doInvokeUndeploy(hotDeployEvent);
        }
        catch (Throwable t) {
            this.throwHotDeployException(hotDeployEvent, "Error unregistering plugins for " + hotDeployEvent.getServletContextName(), t);
        }
    }

    protected void destroyServiceComponent(ServletContext servletContext, ClassLoader classLoader) throws Exception {
        ServiceComponentLocalServiceUtil.destroyServiceComponent((ServletContext)servletContext, (ClassLoader)classLoader);
    }

    protected void doInvokeDeploy(HotDeployEvent hotDeployEvent) throws Exception {
        PluginPackage pluginPackage;
        ServletContext servletContext = hotDeployEvent.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking deploy for " + servletContextName));
        }
        if ((pluginPackage = PluginPackageUtil.readPluginPackageServletContext(servletContext)) == null) {
            return;
        }
        if (servletContext.getResource("/WEB-INF/liferay-theme-loader.xml") != null) {
            PluginPackageUtil.registerInstalledPluginPackage(pluginPackage);
            return;
        }
        pluginPackage.setContext(servletContextName);
        hotDeployEvent.setPluginPackage(pluginPackage);
        PluginPackageUtil.registerInstalledPluginPackage(pluginPackage);
        ClassLoader classLoader = hotDeployEvent.getContextClassLoader();
        this.initLogger(classLoader);
        this.initPortletProps(classLoader);
        this.initServiceComponent(servletContext, classLoader);
        this.registerClpMessageListeners(servletContext, classLoader);
        this.reconfigureCaches(classLoader);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Plugin package " + pluginPackage.getModuleId() + " registered successfully. It's now ready to be used."));
        }
    }

    protected void doInvokeUndeploy(HotDeployEvent hotDeployEvent) throws Exception {
        PluginPackage pluginPackage;
        ServletContext servletContext = hotDeployEvent.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking deploy for " + servletContextName));
        }
        if ((pluginPackage = PluginPackageUtil.readPluginPackageServletContext(servletContext)) == null) {
            return;
        }
        hotDeployEvent.setPluginPackage(pluginPackage);
        PluginPackageUtil.unregisterInstalledPluginPackage(pluginPackage);
        ServletContextPool.remove((String)servletContextName);
        this.destroyServiceComponent(servletContext, hotDeployEvent.getContextClassLoader());
        this.unregisterClpMessageListeners(servletContext);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Plugin package " + pluginPackage.getModuleId() + " unregistered successfully"));
        }
    }

    protected void initLogger(ClassLoader classLoader) {
        Log4JUtil.configureLog4J((URL)classLoader.getResource("META-INF/portal-log4j.xml"));
    }

    protected void initPortletProps(ClassLoader classLoader) throws Exception {
        if (classLoader.getResourceAsStream("portlet.properties") == null) {
            return;
        }
        Class<?> clazz = classLoader.loadClass(PortletProps.class.getName());
        Method method = clazz.getMethod("get", String.class);
        method.invoke(null, "init");
    }

    protected void initServiceComponent(ServletContext servletContext, ClassLoader classLoader) throws Exception {
        Configuration serviceBuilderPropertiesConfiguration = null;
        try {
            serviceBuilderPropertiesConfiguration = ConfigurationFactoryUtil.getConfiguration((ClassLoader)classLoader, (String)"service");
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to read service.properties");
            }
            return;
        }
        Properties serviceBuilderProperties = serviceBuilderPropertiesConfiguration.getProperties();
        if (serviceBuilderProperties.size() == 0) {
            return;
        }
        servletContext.setAttribute(SERVICE_BUILDER_PROPERTIES, (Object)serviceBuilderProperties);
        String buildNamespace = GetterUtil.getString((String)serviceBuilderProperties.getProperty("build.namespace"));
        long buildNumber = GetterUtil.getLong((String)serviceBuilderProperties.getProperty("build.number"));
        long buildDate = GetterUtil.getLong((String)serviceBuilderProperties.getProperty("build.date"));
        boolean buildAutoUpgrade = GetterUtil.getBoolean((String)serviceBuilderProperties.getProperty("build.auto.upgrade"), (boolean)true);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Build namespace " + buildNamespace));
            _log.debug((Object)("Build number " + buildNumber));
            _log.debug((Object)("Build date " + buildDate));
            _log.debug((Object)("Build auto upgrade " + buildAutoUpgrade));
        }
        if (Validator.isNull((String)buildNamespace)) {
            return;
        }
        ServiceComponentLocalServiceUtil.initServiceComponent((ServletContext)servletContext, (ClassLoader)classLoader, (String)buildNamespace, (long)buildNumber, (long)buildDate, (boolean)buildAutoUpgrade);
    }

    protected void reconfigureCaches(ClassLoader classLoader) throws Exception {
        Configuration portletPropertiesConfiguration = null;
        try {
            portletPropertiesConfiguration = ConfigurationFactoryUtil.getConfiguration((ClassLoader)classLoader, (String)"portlet");
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to read portlet.properties");
            }
            return;
        }
        String cacheConfigurationLocation = portletPropertiesConfiguration.get("ehcache.single.vm.config.location");
        this.reconfigureCaches(classLoader, cacheConfigurationLocation, _SINGLE_VM_PORTAL_CACHE_MANAGER_BEAN_NAME);
        String clusterCacheConfigurationLocation = portletPropertiesConfiguration.get("ehcache.multi.vm.config.location");
        this.reconfigureCaches(classLoader, clusterCacheConfigurationLocation, _MULTI_VM_PORTAL_CACHE_MANAGER_BEAN_NAME);
        String hibernateCacheConfigurationPath = portletPropertiesConfiguration.get("net.sf.ehcache.configurationResourceName");
        this.reconfigureHibernateCache(classLoader, hibernateCacheConfigurationPath);
    }

    protected void reconfigureCaches(ClassLoader classLoader, String cacheConfigurationPath, String portalCacheManagerBeanId) throws Exception {
        if (Validator.isNull((String)cacheConfigurationPath)) {
            return;
        }
        URL cacheConfigurationURL = classLoader.getResource(cacheConfigurationPath);
        if (cacheConfigurationURL == null) {
            return;
        }
        ClassLoader aggregateClassLoader = AggregateClassLoader.getAggregateClassLoader((ClassLoader[])new ClassLoader[]{ClassLoaderUtil.getPortalClassLoader(), classLoader});
        ClassLoader contextClassLoader = ClassLoaderUtil.getContextClassLoader();
        try {
            ClassLoaderUtil.setContextClassLoader(aggregateClassLoader);
            PortalCacheManager portalCacheManager = (PortalCacheManager)PortalBeanLocatorUtil.locate((String)portalCacheManagerBeanId);
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Reconfiguring caches in cache manager " + portalCacheManagerBeanId + " using " + cacheConfigurationURL));
            }
            portalCacheManager.reconfigureCaches(cacheConfigurationURL);
        }
        finally {
            ClassLoaderUtil.setContextClassLoader(contextClassLoader);
        }
    }

    protected void reconfigureHibernateCache(ClassLoader classLoader, String hibernateCacheConfigurationPath) {
        if (Validator.isNull((String)hibernateCacheConfigurationPath)) {
            return;
        }
        LiferayEhcacheRegionFactory liferayEhcacheRegionFactory = SingletonLiferayEhcacheRegionFactory.getInstance();
        URL configurationFile = classLoader.getResource(hibernateCacheConfigurationPath);
        if (Validator.isNotNull((Object)configurationFile)) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Reconfiguring Hibernate caches using " + configurationFile));
            }
            liferayEhcacheRegionFactory.reconfigureCaches(configurationFile);
        }
    }
}

