/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.hot;

import com.liferay.portal.kernel.deploy.hot.HotDeploy;
import com.liferay.portal.kernel.deploy.hot.HotDeployEvent;
import com.liferay.portal.kernel.deploy.hot.HotDeployException;
import com.liferay.portal.kernel.deploy.hot.HotDeployListener;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletClassLoaderUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.util.BasePortalLifecycle;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.PortalLifecycle;
import com.liferay.portal.kernel.util.PortalLifecycleUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.util.ClassLoaderUtil;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.ServletContext;

@DoPrivileged
public class HotDeployImpl
implements HotDeploy {
    private static Log _log = LogFactoryUtil.getLog(HotDeployImpl.class);
    private static PACL _pacl = new NoPACL();
    private boolean _capturePrematureEvents = true;
    private List<HotDeployEvent> _dependentHotDeployEvents;
    private Set<String> _deployedServletContextNames;
    private List<HotDeployListener> _hotDeployListeners;

    public HotDeployImpl() {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Initializing hot deploy manager " + this.hashCode()));
        }
        this._dependentHotDeployEvents = new ArrayList<HotDeployEvent>();
        this._deployedServletContextNames = new HashSet<String>();
        this._hotDeployListeners = new CopyOnWriteArrayList<HotDeployListener>();
    }

    public synchronized void fireDeployEvent(final HotDeployEvent hotDeployEvent) {
        PortalLifecycleUtil.register((PortalLifecycle)new HotDeployPortalLifecycle(hotDeployEvent), (int)2);
        if (this._capturePrematureEvents) {
            BasePortalLifecycle portalLifecycle = new BasePortalLifecycle(){

                protected void doPortalDestroy() {
                }

                protected void doPortalInit() {
                    HotDeployImpl.this.fireDeployEvent(hotDeployEvent);
                }
            };
            PortalLifecycleUtil.register((PortalLifecycle)portalLifecycle, (int)2);
        } else {
            this.doFireDeployEvent(hotDeployEvent);
        }
    }

    public synchronized void fireUndeployEvent(HotDeployEvent hotDeployEvent) {
        int i2 = this._hotDeployListeners.size() - 1;
        while (i2 >= 0) {
            block6: {
                HotDeployListener hotDeployListener = this._hotDeployListeners.get(i2);
                try {
                    try {
                        PortletClassLoaderUtil.setClassLoader((ClassLoader)hotDeployEvent.getContextClassLoader());
                        PortletClassLoaderUtil.setServletContextName((String)hotDeployEvent.getServletContextName());
                        hotDeployListener.invokeUndeploy(hotDeployEvent);
                    }
                    catch (HotDeployException hde) {
                        _log.error((Object)hde, (Throwable)hde);
                        PortletClassLoaderUtil.setClassLoader(null);
                        PortletClassLoaderUtil.setServletContextName(null);
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    PortletClassLoaderUtil.setClassLoader(null);
                    PortletClassLoaderUtil.setServletContextName(null);
                    throw throwable;
                }
                PortletClassLoaderUtil.setClassLoader(null);
                PortletClassLoaderUtil.setServletContextName(null);
            }
            --i2;
        }
        this._deployedServletContextNames.remove(hotDeployEvent.getServletContextName());
        ClassLoader classLoader = hotDeployEvent.getContextClassLoader();
        TemplateManagerUtil.destroy((ClassLoader)classLoader);
        _pacl.unregister(classLoader);
    }

    public void registerListener(HotDeployListener hotDeployListener) {
        this._hotDeployListeners.add(hotDeployListener);
    }

    public synchronized void reset() {
        this._capturePrematureEvents = true;
        this._dependentHotDeployEvents.clear();
        this._deployedServletContextNames.clear();
        this._hotDeployListeners.clear();
    }

    public synchronized void setCapturePrematureEvents(boolean capturePrematureEvents) {
        this._capturePrematureEvents = capturePrematureEvents;
    }

    public void unregisterListener(HotDeployListener hotDeployListener) {
        this._hotDeployListeners.remove(hotDeployListener);
    }

    public void unregisterListeners() {
        this._hotDeployListeners.clear();
    }

    protected void doFireDeployEvent(HotDeployEvent hotDeployEvent) {
        String servletContextName = hotDeployEvent.getServletContextName();
        if (this._deployedServletContextNames.contains(servletContextName)) {
            return;
        }
        boolean hasDependencies = true;
        for (String dependentServletContextName : hotDeployEvent.getDependentServletContextNames()) {
            if (this._deployedServletContextNames.contains(dependentServletContextName)) continue;
            hasDependencies = false;
            break;
        }
        if (hasDependencies) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Deploying " + servletContextName + " from queue"));
            }
            for (HotDeployListener hotDeployListener : this._hotDeployListeners) {
                try {
                    try {
                        PortletClassLoaderUtil.setClassLoader((ClassLoader)hotDeployEvent.getContextClassLoader());
                        PortletClassLoaderUtil.setServletContextName((String)hotDeployEvent.getServletContextName());
                        hotDeployListener.invokeDeploy(hotDeployEvent);
                    }
                    catch (HotDeployException hde) {
                        _log.error((Object)hde, (Throwable)hde);
                        PortletClassLoaderUtil.setClassLoader(null);
                        PortletClassLoaderUtil.setServletContextName(null);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    PortletClassLoaderUtil.setClassLoader(null);
                    PortletClassLoaderUtil.setServletContextName(null);
                    throw throwable;
                }
                PortletClassLoaderUtil.setClassLoader(null);
                PortletClassLoaderUtil.setServletContextName(null);
            }
            this._deployedServletContextNames.add(servletContextName);
            this._dependentHotDeployEvents.remove(hotDeployEvent);
            ClassLoader contextClassLoader = this.getContextClassLoader();
            try {
                this.setContextClassLoader(ClassLoaderUtil.getPortalClassLoader());
                ArrayList<HotDeployEvent> dependentEvents = new ArrayList<HotDeployEvent>(this._dependentHotDeployEvents);
                for (HotDeployEvent dependentEvent : dependentEvents) {
                    this.setContextClassLoader(dependentEvent.getContextClassLoader());
                    this.doFireDeployEvent(dependentEvent);
                }
            }
            finally {
                this.setContextClassLoader(contextClassLoader);
            }
        }
        if (!this._dependentHotDeployEvents.contains(hotDeployEvent)) {
            if (_log.isInfoEnabled()) {
                StringBundler sb = new StringBundler(4);
                sb.append("Queueing ");
                sb.append(servletContextName);
                sb.append(" for deploy because it is missing ");
                sb.append(this.getRequiredServletContextNames(hotDeployEvent));
                _log.info((Object)sb.toString());
            }
            this._dependentHotDeployEvents.add(hotDeployEvent);
        } else if (_log.isInfoEnabled()) {
            for (HotDeployEvent dependentHotDeployEvent : this._dependentHotDeployEvents) {
                StringBundler sb = new StringBundler(3);
                sb.append(servletContextName);
                sb.append(" is still in queue because it is missing ");
                sb.append(this.getRequiredServletContextNames(dependentHotDeployEvent));
                _log.info((Object)sb.toString());
            }
        }
    }

    protected ClassLoader getContextClassLoader() {
        return ClassLoaderUtil.getContextClassLoader();
    }

    protected String getRequiredServletContextNames(HotDeployEvent hotDeployEvent) {
        ArrayList<String> requiredServletContextNames = new ArrayList<String>();
        for (String dependentServletContextName : hotDeployEvent.getDependentServletContextNames()) {
            if (this._deployedServletContextNames.contains(dependentServletContextName)) continue;
            requiredServletContextNames.add(dependentServletContextName);
        }
        Collections.sort(requiredServletContextNames);
        return StringUtil.merge(requiredServletContextNames, (String)", ");
    }

    protected void setContextClassLoader(ClassLoader contextClassLoader) {
        ClassLoaderUtil.setContextClassLoader(contextClassLoader);
    }

    private class HotDeployPortalLifecycle
    extends BasePortalLifecycle {
        private ClassLoader _classLoader;
        private ServletContext _servletContext;

        public HotDeployPortalLifecycle(HotDeployEvent hotDeployEvent) {
            this._servletContext = hotDeployEvent.getServletContext();
            this._classLoader = hotDeployEvent.getContextClassLoader();
            ServletContextPool.put((String)this._servletContext.getServletContextName(), (ServletContext)this._servletContext);
        }

        protected void doPortalDestroy() {
        }

        protected void doPortalInit() throws Exception {
            Properties properties = null;
            String propertiesString = HttpUtil.URLtoString((URL)this._servletContext.getResource("/WEB-INF/liferay-plugin-package.properties"));
            properties = propertiesString != null ? PropertiesUtil.load((String)propertiesString) : new Properties();
            _pacl.initPolicy(this._servletContext.getServletContextName(), this._classLoader, properties);
        }
    }

    private static class NoPACL
    implements PACL {
        private NoPACL() {
        }

        @Override
        public void initPolicy(String servletContextName, ClassLoader classLoader, Properties properties) {
        }

        @Override
        public void unregister(ClassLoader classLoader) {
        }
    }

    public static interface PACL {
        public void initPolicy(String var1, ClassLoader var2, Properties var3);

        public void unregister(ClassLoader var1);
    }
}

