/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration;

import com.germinus.easyconf.ComponentConfiguration;
import com.germinus.easyconf.ComponentProperties;
import com.germinus.easyconf.Filter;
import com.liferay.portal.configuration.easyconf.ClassLoaderAggregateProperties;
import com.liferay.portal.configuration.easyconf.ClassLoaderComponentConfiguration;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Company;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.MapConfiguration;

public class ConfigurationImpl
implements Configuration {
    private static final String _ARRAY_KEY_PREFIX = "ARRAY_";
    private static final boolean _PRINT_DUPLICATE_CALLS_TO_GET = false;
    private static Log _log = LogFactoryUtil.getLog(ConfigurationImpl.class);
    private static String[] _emptyArray = new String[0];
    private static Object _nullValue = new Object();
    private ComponentConfiguration _componentConfiguration;
    private Set<String> _printedSources = new HashSet<String>();
    private Map<String, Object> _values = new ConcurrentHashMap<String, Object>();

    public ConfigurationImpl(ClassLoader classLoader, String name) {
        this(classLoader, name, 0L);
    }

    public ConfigurationImpl(ClassLoader classLoader, String name, long companyId) {
        String webId = null;
        if (companyId > 0L) {
            try {
                Company company = CompanyLocalServiceUtil.getCompanyById((long)companyId);
                webId = company.getWebId();
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
            }
        }
        this._componentConfiguration = new ClassLoaderComponentConfiguration(classLoader, webId, name);
        this.printSources(companyId, webId);
    }

    public void addProperties(Properties properties) {
        try {
            ComponentProperties componentProperties = this._componentConfiguration.getProperties();
            ClassLoaderAggregateProperties classLoaderAggregateProperties = (ClassLoaderAggregateProperties)componentProperties.toConfiguration();
            Field field1 = CompositeConfiguration.class.getDeclaredField("configList");
            field1.setAccessible(true);
            List configurations = (List)field1.get((Object)classLoaderAggregateProperties);
            MapConfiguration newConfiguration = new MapConfiguration((Map)properties);
            configurations.add(0, newConfiguration);
            CompositeConfiguration compositeConfiguration = classLoaderAggregateProperties.getBaseConfiguration();
            configurations = (List)field1.get(compositeConfiguration);
            configurations.add(0, newConfiguration);
            this.clearCache();
        }
        catch (Exception e2) {
            _log.error((Object)"The properties could not be added", (Throwable)e2);
        }
    }

    public void clearCache() {
        this._values.clear();
    }

    public boolean contains(String key) {
        Object value = this._values.get(key);
        if (value == null) {
            ComponentProperties componentProperties = this.getComponentProperties();
            value = componentProperties.getProperty(key);
            if (value == null) {
                value = _nullValue;
            }
            this._values.put(key, value);
        }
        return value != _nullValue;
    }

    public String get(String key) {
        Object value = this._values.get(key);
        if (value == null) {
            ComponentProperties componentProperties = this.getComponentProperties();
            value = componentProperties.getString(key);
            if (value == null) {
                value = _nullValue;
            }
            this._values.put(key, value);
        }
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    public String get(String key, com.liferay.portal.kernel.configuration.Filter filter) {
        String filterCacheKey = this.buildFilterCacheKey(key, filter, false);
        Object value = null;
        if (filterCacheKey != null) {
            value = this._values.get(filterCacheKey);
        }
        if (value == null) {
            ComponentProperties componentProperties = this.getComponentProperties();
            value = componentProperties.getString(key, this.getEasyConfFilter(filter));
            if (filterCacheKey != null) {
                if (value == null) {
                    value = _nullValue;
                }
                this._values.put(filterCacheKey, value);
            }
        }
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    public String[] getArray(String key) {
        String cacheKey = _ARRAY_KEY_PREFIX.concat(key);
        Object value = this._values.get(cacheKey);
        if (value == null) {
            ComponentProperties componentProperties = this.getComponentProperties();
            String[] array = componentProperties.getStringArray(key);
            value = this.fixArrayValue(cacheKey, array);
        }
        if (value instanceof String[]) {
            return (String[])value;
        }
        return _emptyArray;
    }

    public String[] getArray(String key, com.liferay.portal.kernel.configuration.Filter filter) {
        String filterCacheKey = this.buildFilterCacheKey(key, filter, true);
        Object value = null;
        if (filterCacheKey != null) {
            value = this._values.get(filterCacheKey);
        }
        if (value == null) {
            ComponentProperties componentProperties = this.getComponentProperties();
            String[] array = componentProperties.getStringArray(key, this.getEasyConfFilter(filter));
            value = this.fixArrayValue(filterCacheKey, array);
        }
        if (value instanceof String[]) {
            return (String[])value;
        }
        return _emptyArray;
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        ComponentProperties componentProperties = this.getComponentProperties();
        Properties componentPropertiesProperties = componentProperties.getProperties();
        for (Map.Entry<Object, Object> entry : componentPropertiesProperties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            properties.setProperty(key, value);
        }
        return properties;
    }

    public Properties getProperties(String prefix, boolean removePrefix) {
        Properties properties = this.getProperties();
        return PropertiesUtil.getProperties((Properties)properties, (String)prefix, (boolean)removePrefix);
    }

    public void removeProperties(Properties properties) {
        try {
            ComponentProperties componentProperties = this._componentConfiguration.getProperties();
            ClassLoaderAggregateProperties classLoaderAggregateProperties = (ClassLoaderAggregateProperties)componentProperties.toConfiguration();
            CompositeConfiguration compositeConfiguration = classLoaderAggregateProperties.getBaseConfiguration();
            Field field2 = CompositeConfiguration.class.getDeclaredField("configList");
            field2.setAccessible(true);
            List configurations = (List)field2.get(compositeConfiguration);
            Iterator itr = configurations.iterator();
            while (itr.hasNext()) {
                org.apache.commons.configuration.Configuration configuration = (org.apache.commons.configuration.Configuration)itr.next();
                if (!(configuration instanceof MapConfiguration)) break;
                MapConfiguration mapConfiguration = (MapConfiguration)configuration;
                if (mapConfiguration.getMap() != properties) continue;
                itr.remove();
                classLoaderAggregateProperties.removeConfiguration(configuration);
            }
            this.clearCache();
        }
        catch (Exception e2) {
            _log.error((Object)"The properties could not be removed", (Throwable)e2);
        }
    }

    public void set(String key, String value) {
        ComponentProperties componentProperties = this.getComponentProperties();
        componentProperties.setProperty(key, (Object)value);
        this._values.put(key, value);
    }

    protected String buildFilterCacheKey(String key, com.liferay.portal.kernel.configuration.Filter filter, boolean arrayValue) {
        if (filter.getVariables() != null) {
            return null;
        }
        String[] selectors = filter.getSelectors();
        int length = 0;
        length = arrayValue ? selectors.length + 2 : selectors.length + 1;
        StringBundler sb = new StringBundler(length);
        if (arrayValue) {
            sb.append(_ARRAY_KEY_PREFIX);
        }
        sb.append(key);
        sb.append(selectors);
        return sb.toString();
    }

    protected Object fixArrayValue(String cacheKey, String[] array) {
        if (cacheKey == null) {
            return array;
        }
        String[] value = _nullValue;
        if (ArrayUtil.isNotEmpty((Object[])array)) {
            if (Validator.isNull((String)array[array.length - 1])) {
                String[] subArray = new String[array.length - 1];
                System.arraycopy(array, 0, subArray, 0, subArray.length);
                array = subArray;
            }
            if (array.length > 0) {
                value = array;
            }
        }
        this._values.put(cacheKey, value);
        return value;
    }

    protected ComponentProperties getComponentProperties() {
        return this._componentConfiguration.getProperties();
    }

    protected Filter getEasyConfFilter(com.liferay.portal.kernel.configuration.Filter filter) {
        Filter easyConfFilter = Filter.by((String[])filter.getSelectors());
        if (filter.getVariables() != null) {
            easyConfFilter.setVariables(filter.getVariables());
        }
        return easyConfFilter;
    }

    protected void printSources(long companyId, String webId) {
        ComponentProperties componentProperties = this.getComponentProperties();
        List sources = componentProperties.getLoadedSources();
        int i2 = sources.size() - 1;
        while (i2 >= 0) {
            String source = (String)sources.get(i2);
            if (!this._printedSources.contains(source)) {
                this._printedSources.add(source);
                String info = "Loading " + source;
                if (companyId > 0L) {
                    info = String.valueOf(info) + " for {companyId=" + companyId + ", webId=" + webId + "}";
                }
                System.out.println(info);
            }
            --i2;
        }
    }
}

