/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cluster;

import com.liferay.portal.cluster.AddressImpl;
import com.liferay.portal.cluster.BaseReceiver;
import com.liferay.portal.cluster.ClusterExecutorImpl;
import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.cluster.ClusterException;
import com.liferay.portal.kernel.cluster.ClusterInvokeThreadLocal;
import com.liferay.portal.kernel.cluster.ClusterMessageType;
import com.liferay.portal.kernel.cluster.ClusterNodeResponse;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.cluster.FutureClusterResponses;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.View;

public class ClusterRequestReceiver
extends BaseReceiver {
    private static Log _log = LogFactoryUtil.getLog(ClusterRequestReceiver.class);
    private ClusterExecutorImpl _clusterExecutorImpl;
    private CountDownLatch _countDownLatch = new CountDownLatch(1);
    private volatile View _lastView;

    public ClusterRequestReceiver(ClusterExecutorImpl clusterExecutorImpl) {
        this._clusterExecutorImpl = clusterExecutorImpl;
    }

    public void openLatch() {
        this._countDownLatch.countDown();
    }

    @Override
    public void receive(Message message) {
        boolean isProcessed;
        try {
            this._countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            _log.error((Object)"Latch opened prematurely by interruption. Dependence may not be ready.");
        }
        Object obj = message.getObject();
        if (obj == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Message content is null");
            }
            return;
        }
        AddressImpl sourceAddress = new AddressImpl(message.getSrc());
        if (((Object)sourceAddress).equals(this._clusterExecutorImpl.getLocalClusterNodeAddress()) && (isProcessed = this.processLocalMessage(obj))) {
            return;
        }
        if (obj instanceof ClusterRequest) {
            ClusterRequest clusterRequest = (ClusterRequest)obj;
            this.processClusterRequest(clusterRequest, sourceAddress);
        } else if (obj instanceof ClusterNodeResponse) {
            ClusterNodeResponse clusterNodeResponse = (ClusterNodeResponse)obj;
            this.processClusterResponse(clusterNodeResponse, sourceAddress);
        } else if (_log.isWarnEnabled()) {
            _log.warn((Object)("Unable to process message content of type " + obj.getClass()));
        }
    }

    @Override
    public void viewAccepted(View view) {
        super.viewAccepted(view);
        if (this._lastView == null) {
            this._lastView = view;
            return;
        }
        List<Address> departAddresses = this.getDepartAddresses(view);
        List<Address> newAddresses = this.getNewAddresses(view);
        this._lastView = view;
        try {
            this._countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            _log.error((Object)"Latch opened prematurely by interruption. Dependence may not be ready.");
        }
        if (!newAddresses.isEmpty()) {
            this._clusterExecutorImpl.sendNotifyRequest();
        }
        if (!departAddresses.isEmpty()) {
            this._clusterExecutorImpl.memberRemoved(departAddresses);
        }
    }

    protected List<Address> getDepartAddresses(View view) {
        List currentJGroupsAddresses = view.getMembers();
        List lastJGroupsAddresses = this._lastView.getMembers();
        ArrayList departJGroupsAddresses = new ArrayList(lastJGroupsAddresses);
        departJGroupsAddresses.removeAll(currentJGroupsAddresses);
        if (departJGroupsAddresses.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Address> departAddresses = new ArrayList<Address>(departJGroupsAddresses.size());
        for (org.jgroups.Address departJGroupsAddress : departJGroupsAddresses) {
            AddressImpl departAddress = new AddressImpl(departJGroupsAddress);
            departAddresses.add(departAddress);
        }
        return departAddresses;
    }

    protected List<Address> getNewAddresses(View view) {
        List currentJGroupsAddresses = view.getMembers();
        List lastJGroupsAddresses = this._lastView.getMembers();
        ArrayList newJGroupsAddresses = new ArrayList(currentJGroupsAddresses);
        newJGroupsAddresses.removeAll(lastJGroupsAddresses);
        if (newJGroupsAddresses.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Address> newAddresses = new ArrayList<Address>(newJGroupsAddresses.size());
        for (org.jgroups.Address newJGroupsAddress : newJGroupsAddresses) {
            AddressImpl newAddress = new AddressImpl(newJGroupsAddress);
            newAddresses.add(newAddress);
        }
        return newAddresses;
    }

    protected void handleResponse(Address address, ClusterRequest clusterRequest, Object returnValue, Exception exception) {
        ClusterNodeResponse clusterNodeResponse = this._clusterExecutorImpl.generateClusterNodeResponse(clusterRequest, returnValue, exception);
        JChannel channel = this._clusterExecutorImpl.getControlChannel();
        try {
            channel.send((org.jgroups.Address)address.getRealAddress(), (Object)clusterNodeResponse);
        }
        catch (Exception e2) {
            _log.error((Object)("Unable to send response message " + clusterNodeResponse), (Throwable)e2);
        }
        catch (Throwable t) {
            _log.error((Object)t, t);
        }
    }

    protected void processClusterRequest(ClusterRequest clusterRequest, Address sourceAddress) {
        Exception exception;
        Object returnValue;
        block10: {
            ClusterMessageType clusterMessageType = clusterRequest.getClusterMessageType();
            if (clusterMessageType.equals((Object)ClusterMessageType.NOTIFY) || clusterMessageType.equals((Object)ClusterMessageType.UPDATE)) {
                this._clusterExecutorImpl.memberJoined(sourceAddress, clusterRequest.getOriginatingClusterNode());
                if (clusterMessageType.equals((Object)ClusterMessageType.NOTIFY)) {
                    this.handleResponse(sourceAddress, clusterRequest, null, null);
                }
                return;
            }
            MethodHandler methodHandler = clusterRequest.getMethodHandler();
            returnValue = null;
            exception = null;
            if (methodHandler != null) {
                try {
                    try {
                        ClusterInvokeThreadLocal.setEnabled((boolean)false);
                        returnValue = methodHandler.invoke(true);
                    }
                    catch (Exception e2) {
                        exception = e2;
                        _log.error((Object)("Unable to invoke method " + methodHandler), (Throwable)e2);
                        ClusterInvokeThreadLocal.setEnabled((boolean)true);
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    ClusterInvokeThreadLocal.setEnabled((boolean)true);
                    throw throwable;
                }
                ClusterInvokeThreadLocal.setEnabled((boolean)true);
            } else {
                exception = new ClusterException("Payload is not of type " + MethodHandler.class.getName());
            }
        }
        if (!clusterRequest.isFireAndForget()) {
            this.handleResponse(sourceAddress, clusterRequest, returnValue, exception);
        }
    }

    protected void processClusterResponse(ClusterNodeResponse clusterNodeResponse, Address sourceAddress) {
        ClusterMessageType clusterMessageType = clusterNodeResponse.getClusterMessageType();
        if (clusterMessageType.equals((Object)ClusterMessageType.NOTIFY)) {
            this._clusterExecutorImpl.memberJoined(sourceAddress, clusterNodeResponse.getClusterNode());
            return;
        }
        String uuid = clusterNodeResponse.getUuid();
        FutureClusterResponses futureClusterResponses = this._clusterExecutorImpl.getExecutionResults(uuid);
        if (futureClusterResponses == null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Unable to find response container for " + uuid));
            }
            return;
        }
        if (futureClusterResponses.expectsReply(sourceAddress)) {
            futureClusterResponses.addClusterNodeResponse(clusterNodeResponse);
        } else if (_log.isWarnEnabled()) {
            _log.warn((Object)("Unknown uuid " + uuid + " from " + sourceAddress));
        }
    }

    protected boolean processLocalMessage(Object message) {
        ClusterRequest clusterRequest;
        if (message instanceof ClusterRequest && (clusterRequest = (ClusterRequest)message).isSkipLocal()) {
            return true;
        }
        return this._clusterExecutorImpl.isShortcutLocalMethod();
    }
}

