/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.memcached;

import com.liferay.portal.cache.memcached.MemcachedClientFactory;
import com.liferay.portal.kernel.cache.CacheListener;
import com.liferay.portal.kernel.cache.CacheListenerScope;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.MemcachedClientIF;

public class PooledMemcachePortalCache<V>
implements PortalCache<String, V> {
    private static Log _log = LogFactoryUtil.getLog(PooledMemcachePortalCache.class);
    private MemcachedClientFactory _memcachedClientFactory;
    private String _name;
    private int _timeout;
    private TimeUnit _timeoutTimeUnit;
    private int _timeToLive;

    public PooledMemcachePortalCache(String name, MemcachedClientFactory memcachedClientFactory, int timeout, TimeUnit timeoutTimeUnit) {
        this._name = name;
        this._memcachedClientFactory = memcachedClientFactory;
        this._timeout = timeout;
        this._timeoutTimeUnit = timeoutTimeUnit;
    }

    public void destroy() {
        try {
            this._memcachedClientFactory.close();
        }
        catch (Exception exception) {}
    }

    public Collection<V> get(Collection<String> keys) {
        MemcachedClientIF memcachedClient = null;
        try {
            memcachedClient = this._memcachedClientFactory.getMemcachedClient();
        }
        catch (Exception exception) {
            return null;
        }
        ArrayList<String> processedKeys = new ArrayList<String>(keys.size());
        for (String key : keys) {
            String processedKey = this._name.concat(key);
            processedKeys.add(processedKey);
        }
        Map values = null;
        try {
            Future future = null;
            try {
                future = memcachedClient.asyncGetBulk(processedKeys);
            }
            catch (IllegalArgumentException iae) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Error retrieving with keys " + keys), (Throwable)iae);
                }
                future.cancel(true);
            }
            try {
                values = (Map)future.get(this._timeout, this._timeoutTimeUnit);
            }
            catch (Throwable t) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"Memcache operation error", t);
                }
                future.cancel(true);
            }
        }
        finally {
            this.cleanupClient(memcachedClient);
        }
        return values.values();
    }

    public V get(String key) {
        MemcachedClientIF memcachedClient = null;
        try {
            memcachedClient = this._memcachedClientFactory.getMemcachedClient();
        }
        catch (Exception exception) {
            return null;
        }
        String processedKey = this._name.concat(key);
        try {
            Future future;
            block9: {
                future = null;
                try {
                    future = memcachedClient.asyncGet(processedKey);
                }
                catch (IllegalArgumentException iae) {
                    if (!_log.isWarnEnabled()) break block9;
                    _log.warn((Object)("Error retrieving with key " + key), (Throwable)iae);
                }
            }
            V value = null;
            try {
                value = future.get(this._timeout, this._timeoutTimeUnit);
            }
            catch (Exception exception) {
                future.cancel(true);
            }
            V v = value;
            return v;
        }
        finally {
            this.cleanupClient(memcachedClient);
        }
    }

    public String getName() {
        return this._name;
    }

    public void put(String key, V value) {
        this.put(key, value, this._timeToLive);
    }

    public void put(String key, V value, int timeToLive) {
        MemcachedClientIF memcachedClient = null;
        try {
            memcachedClient = this._memcachedClientFactory.getMemcachedClient();
        }
        catch (Exception exception) {
            return;
        }
        String processedKey = this._name.concat(key);
        try {
            try {
                memcachedClient.set(processedKey, timeToLive, value);
            }
            catch (IllegalArgumentException iae) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Error storing value with key " + key), (Throwable)iae);
                }
                this.cleanupClient(memcachedClient);
            }
        }
        finally {
            this.cleanupClient(memcachedClient);
        }
    }

    public void registerCacheListener(CacheListener<String, V> cacheListener) {
        this.registerCacheListener(cacheListener, CacheListenerScope.ALL);
    }

    public void registerCacheListener(CacheListener<String, V> cacheListener, CacheListenerScope cacheListenerScope) {
        throw new UnsupportedOperationException();
    }

    public void remove(String key) {
        MemcachedClientIF memcachedClient = null;
        try {
            memcachedClient = this._memcachedClientFactory.getMemcachedClient();
        }
        catch (Exception exception) {
            return;
        }
        String processedKey = this._name.concat(key);
        try {
            try {
                memcachedClient.delete(processedKey);
            }
            catch (IllegalArgumentException iae) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Unable to delete value with key " + key), (Throwable)iae);
                }
                this.cleanupClient(memcachedClient);
            }
        }
        finally {
            this.cleanupClient(memcachedClient);
        }
    }

    public void removeAll() {
        MemcachedClientIF memcachedClient = null;
        try {
            memcachedClient = this._memcachedClientFactory.getMemcachedClient();
        }
        catch (Exception exception) {
            return;
        }
        try {
            memcachedClient.flush();
        }
        finally {
            this.cleanupClient(memcachedClient);
        }
    }

    public void setTimeToLive(int timeToLive) {
        this._timeToLive = timeToLive;
    }

    public void unregisterCacheListener(CacheListener<String, V> cacheListener) {
    }

    public void unregisterCacheListeners() {
    }

    protected void cleanupClient(MemcachedClientIF memcachedClient) {
        try {
            this._memcachedClientFactory.returnMemcachedObject(memcachedClient);
        }
        catch (Exception exception) {}
    }
}

