/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.ehcache;

import com.liferay.portal.cache.ehcache.EhcachePortalCacheManager;
import com.liferay.portal.cache.ehcache.EhcacheStreamBootstrapCacheLoader;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterLinkUtil;
import com.liferay.portal.kernel.cluster.ClusterNodeResponse;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.AnnotatedObjectInputStream;
import com.liferay.portal.kernel.io.AnnotatedObjectOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.SocketUtil;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.channels.ServerSocketChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;

public class EhcacheStreamBootstrapHelpUtil {
    private static final String _BEAN_NAME_MULTI_VM_PORTAL_CACHE_MANAGER = "com.liferay.portal.kernel.cache.MultiVMPortalCacheManager";
    private static final String _COMMAND_SOCKET_CLOSE = "${SOCKET_CLOSE}";
    private static Log _log = LogFactoryUtil.getLog(EhcacheStreamBootstrapHelpUtil.class);
    private static MethodKey _createServerSocketFromClusterMethodKey = new MethodKey(EhcacheStreamBootstrapHelpUtil.class, "createServerSocketFromCluster", new Class[]{List.class});
    private static SocketUtil.ServerSocketConfigurator _serverSocketConfigurator = new SocketCacheServerSocketConfiguration();

    public static SocketAddress createServerSocketFromCluster(List<String> cacheNames) throws Exception {
        ServerSocketChannel serverSocketChannel = SocketUtil.createServerSocketChannel((InetAddress)ClusterLinkUtil.getBindInetAddress(), (int)PropsValues.EHCACHE_SOCKET_START_PORT, (SocketUtil.ServerSocketConfigurator)_serverSocketConfigurator);
        ServerSocket serverSocket = serverSocketChannel.socket();
        EhcachePortalCacheManager ehcachePortalCacheManager = (EhcachePortalCacheManager)PortalBeanLocatorUtil.locate((String)_BEAN_NAME_MULTI_VM_PORTAL_CACHE_MANAGER);
        CacheManager cacheManager = ehcachePortalCacheManager.getEhcacheManager();
        EhcacheStreamServerThread ehcacheStreamServerThread = new EhcacheStreamServerThread(serverSocket, cacheManager, cacheNames);
        ehcacheStreamServerThread.start();
        return serverSocket.getLocalSocketAddress();
    }

    /*
     * Unable to fully structure code
     */
    protected static void loadCachesFromCluster(Ehcache ... ehcaches) throws Exception {
        block21: {
            clusterNodeAddresses = ClusterExecutorUtil.getClusterNodeAddresses();
            if (EhcacheStreamBootstrapHelpUtil._log.isInfoEnabled()) {
                EhcacheStreamBootstrapHelpUtil._log.info((Object)("Cluster node addresses " + clusterNodeAddresses));
            }
            if (clusterNodeAddresses.size() <= 1) {
                if (EhcacheStreamBootstrapHelpUtil._log.isDebugEnabled()) {
                    EhcacheStreamBootstrapHelpUtil._log.debug((Object)"Not loading cache from cluster because a cluster peer was not found");
                }
                return;
            }
            ehcachePortalCacheManager = (EhcachePortalCacheManager)PortalBeanLocatorUtil.locate((String)"com.liferay.portal.kernel.cache.MultiVMPortalCacheManager");
            cacheManager = ehcachePortalCacheManager.getEhcacheManager();
            cacheNames = new ArrayList<String>();
            var8_5 = ehcaches;
            var7_6 = ehcaches.length;
            var6_8 = 0;
            while (var6_8 < var7_6) {
                ehcache = var8_5[var6_8];
                cacheNames.add(ehcache.getName());
                ++var6_8;
            }
            clusterRequest = ClusterRequest.createMulticastRequest((MethodHandler)new MethodHandler(EhcacheStreamBootstrapHelpUtil._createServerSocketFromClusterMethodKey, new Object[]{cacheNames}), (boolean)true);
            futureClusterResponses = ClusterExecutorUtil.execute((ClusterRequest)clusterRequest);
            clusterNodeResponses = futureClusterResponses.getPartialResults();
            clusterNodeResponse = null;
            try {
                clusterNodeResponse = (ClusterNodeResponse)clusterNodeResponses.poll(PropsValues.CLUSTER_LINK_NODE_BOOTUP_RESPONSE_TIMEOUT, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException v0) {
                return;
            }
            if (clusterNodeResponse == null) {
                if (EhcacheStreamBootstrapHelpUtil._log.isWarnEnabled()) {
                    EhcacheStreamBootstrapHelpUtil._log.warn((Object)"Unable to load cache from the cluster because there was no peer response");
                }
                return;
            }
            socket = null;
            objectInputStream = null;
            try {
                remoteSocketAddress = (SocketAddress)clusterNodeResponse.getResult();
                if (remoteSocketAddress == null) {
                    EhcacheStreamBootstrapHelpUtil._log.error((Object)("Cluster peer " + clusterNodeResponse.getClusterNode() + " responded with a null socket address"));
                    return;
                }
                socket = new Socket();
                socket.connect(remoteSocketAddress);
                socket.shutdownOutput();
                objectInputStream = new AnnotatedObjectInputStream(socket.getInputStream());
                ehcache = null;
                while (true) lbl-1000:
                // 4 sources

                {
                    if ((object = objectInputStream.readObject()) instanceof EhcacheElement) {
                        ehcacheElement = (EhcacheElement)object;
                        element = ehcacheElement.toElement();
                        ehcache.put(element, true);
                        continue;
                    }
                    if (!(object instanceof String)) ** break;
                    if ("${SOCKET_CLOSE}".equals(object)) {
                        break block21;
                    }
                    EhcacheStreamBootstrapCacheLoader.setSkip();
                    try {
                        ehcache = cacheManager.addCacheIfAbsent((String)object);
                    }
                    finally {
                        EhcacheStreamBootstrapCacheLoader.resetSkip();
                        continue;
                    }
                    break;
                }
                ** GOTO lbl-1000
                throw new SystemException("Socket input stream returned invalid object " + object);
            }
            finally {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
                if (socket != null) {
                    socket.close();
                }
            }
        }
    }

    private static class EhcacheElement
    implements Serializable {
        private Serializable _key;
        private Serializable _value;

        public EhcacheElement(Serializable key, Serializable value) {
            this._key = key;
            this._value = value;
        }

        public Element toElement() {
            return new Element(this._key, this._value);
        }
    }

    private static class EhcacheStreamServerThread
    extends Thread {
        private CacheManager _cacheManager;
        private List<String> _cacheNames;
        private ServerSocket _serverSocket;

        public EhcacheStreamServerThread(ServerSocket serverSocket, CacheManager cacheManager, List<String> cacheNames) {
            this._serverSocket = serverSocket;
            this._cacheManager = cacheManager;
            this._cacheNames = cacheNames;
            this.setDaemon(true);
            this.setName(String.valueOf(EhcacheStreamServerThread.class.getName()) + " - " + cacheNames);
            this.setPriority(5);
        }

        @Override
        public void run() {
            Socket socket = null;
            try {
                try {
                    socket = this._serverSocket.accept();
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("Terminating the socket thread " + this.getName() + " that the client requested but never used"));
                    }
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (IOException ioe) {
                            throw new RuntimeException(ioe);
                        }
                    }
                    return;
                }
                try {
                    this._serverSocket.close();
                    socket.shutdownInput();
                    AnnotatedObjectOutputStream objectOutputStream = new AnnotatedObjectOutputStream(socket.getOutputStream());
                    for (String cacheName : this._cacheNames) {
                        Cache ehcache = this._cacheManager.getCache(cacheName);
                        if (ehcache == null) {
                            EhcacheStreamBootstrapCacheLoader.setSkip();
                            try {
                                this._cacheManager.addCache(cacheName);
                                continue;
                            }
                            finally {
                                EhcacheStreamBootstrapCacheLoader.resetSkip();
                            }
                        }
                        objectOutputStream.writeObject(cacheName);
                        List keys = ehcache.getKeys();
                        for (Object key : keys) {
                            if (!(key instanceof Serializable)) {
                                if (!_log.isWarnEnabled()) continue;
                                _log.warn((Object)("Key " + key + " is not serializable"));
                                continue;
                            }
                            Element element = ehcache.get(key);
                            if (element == null) continue;
                            Object value = element.getObjectValue();
                            if (!(value instanceof Serializable)) {
                                if (!_log.isWarnEnabled() || value == null) continue;
                                _log.warn((Object)("Value " + value + " is not serializable"));
                                continue;
                            }
                            EhcacheElement ehcacheElement = new EhcacheElement((Serializable)key, (Serializable)value);
                            objectOutputStream.writeObject(ehcacheElement);
                        }
                    }
                    objectOutputStream.writeObject(EhcacheStreamBootstrapHelpUtil._COMMAND_SOCKET_CLOSE);
                    objectOutputStream.close();
                }
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            }
            finally {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe);
                    }
                }
            }
        }
    }

    private static class SocketCacheServerSocketConfiguration
    implements SocketUtil.ServerSocketConfigurator {
        private SocketCacheServerSocketConfiguration() {
        }

        public void configure(ServerSocket serverSocket) throws SocketException {
            serverSocket.setSoTimeout(PropsValues.EHCACHE_SOCKET_SO_TIMEOUT);
        }
    }
}

