/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.ehcache;

import com.liferay.portal.cache.ehcache.PortalCacheCacheEventListener;
import com.liferay.portal.kernel.cache.CacheListener;
import com.liferay.portal.kernel.cache.CacheListenerScope;
import com.liferay.portal.kernel.cache.PortalCache;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.event.NotificationScope;
import net.sf.ehcache.event.RegisteredEventListeners;

public class EhcachePortalCache<K extends Serializable, V>
implements PortalCache<K, V> {
    private Map<CacheListener<K, V>, CacheEventListener> _cacheEventListeners = new ConcurrentHashMap<CacheListener<K, V>, CacheEventListener>();
    private Ehcache _ehcache;

    public EhcachePortalCache(Ehcache ehcache) {
        this._ehcache = ehcache;
    }

    public void destroy() {
    }

    public Collection<V> get(Collection<K> keys) {
        ArrayList<V> values = new ArrayList<V>(keys.size());
        for (Serializable key : keys) {
            values.add(this.get(key));
        }
        return values;
    }

    public V get(K key) {
        Element element = this._ehcache.get(key);
        if (element == null) {
            return null;
        }
        return (V)element.getObjectValue();
    }

    public String getName() {
        return this._ehcache.getName();
    }

    public void put(K key, V value) {
        Element element = new Element(key, value);
        this._ehcache.put(element);
    }

    public void put(K key, V value, int timeToLive) {
        Element element = new Element(key, value);
        element.setTimeToLive(timeToLive);
        this._ehcache.put(element);
    }

    public void registerCacheListener(CacheListener<K, V> cacheListener) {
        this.registerCacheListener(cacheListener, CacheListenerScope.ALL);
    }

    public void registerCacheListener(CacheListener<K, V> cacheListener, CacheListenerScope cacheListenerScope) {
        if (this._cacheEventListeners.containsKey(cacheListener)) {
            return;
        }
        PortalCacheCacheEventListener<K, V> cacheEventListener = new PortalCacheCacheEventListener<K, V>(cacheListener, this);
        this._cacheEventListeners.put(cacheListener, cacheEventListener);
        NotificationScope notificationScope = this.getNotificationScope(cacheListenerScope);
        RegisteredEventListeners registeredEventListeners = this._ehcache.getCacheEventNotificationService();
        registeredEventListeners.registerListener(cacheEventListener, notificationScope);
    }

    public void remove(K key) {
        this._ehcache.remove(key);
    }

    public void removeAll() {
        this._ehcache.removeAll();
    }

    public void setEhcache(Ehcache ehcache) {
        this._ehcache = ehcache;
    }

    public void unregisterCacheListener(CacheListener<K, V> cacheListener) {
        CacheEventListener cacheEventListener = this._cacheEventListeners.get(cacheListener);
        if (cacheEventListener != null) {
            RegisteredEventListeners registeredEventListeners = this._ehcache.getCacheEventNotificationService();
            registeredEventListeners.unregisterListener(cacheEventListener);
        }
        this._cacheEventListeners.remove(cacheListener);
    }

    public void unregisterCacheListeners() {
        RegisteredEventListeners registeredEventListeners = this._ehcache.getCacheEventNotificationService();
        for (CacheEventListener cacheEventListener : this._cacheEventListeners.values()) {
            registeredEventListeners.unregisterListener(cacheEventListener);
        }
        this._cacheEventListeners.clear();
    }

    protected NotificationScope getNotificationScope(CacheListenerScope cacheListenerScope) {
        if (cacheListenerScope.equals((Object)CacheListenerScope.ALL)) {
            return NotificationScope.ALL;
        }
        if (cacheListenerScope.equals((Object)CacheListenerScope.LOCAL)) {
            return NotificationScope.LOCAL;
        }
        return NotificationScope.REMOTE;
    }
}

