/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.ehcache;

import com.liferay.portal.cache.cluster.EhcachePortalCacheClusterReplicatorFactory;
import com.liferay.portal.cache.ehcache.LiferayCacheEventListenerFactory;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import java.net.URL;
import java.util.List;
import java.util.Map;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;

public class EhcacheConfigurationUtil {
    public static Configuration getConfiguration(String configurationPath) {
        return EhcacheConfigurationUtil.getConfiguration(configurationPath, false);
    }

    public static Configuration getConfiguration(String configurationPath, boolean clusterAware) {
        return EhcacheConfigurationUtil.getConfiguration(configurationPath, clusterAware, false);
    }

    public static Configuration getConfiguration(String configurationPath, boolean clusterAware, boolean usingDefault) {
        if (Validator.isNull((String)configurationPath)) {
            return null;
        }
        URL configurationURL = EhcacheConfigurationUtil.class.getResource(configurationPath);
        return EhcacheConfigurationUtil.getConfiguration(configurationURL, clusterAware, usingDefault);
    }

    public static Configuration getConfiguration(URL configurationURL) {
        return EhcacheConfigurationUtil.getConfiguration(configurationURL, false);
    }

    public static Configuration getConfiguration(URL configurationURL, boolean clusterAware) {
        return EhcacheConfigurationUtil.getConfiguration(configurationURL, clusterAware, false);
    }

    public static Configuration getConfiguration(URL configurationURL, boolean clusterAware, boolean usingDefault) {
        if (Validator.isNull((Object)configurationURL)) {
            return null;
        }
        Configuration configuration = ConfigurationFactory.parseConfiguration((URL)configurationURL);
        boolean enableClusterLinkReplication = false;
        if (PropsValues.CLUSTER_LINK_ENABLED && PropsValues.EHCACHE_CLUSTER_LINK_REPLICATION_ENABLED) {
            enableClusterLinkReplication = true;
        }
        if (clusterAware && (usingDefault || enableClusterLinkReplication)) {
            return EhcacheConfigurationUtil._processDefaultClusterLinkReplication(configuration, usingDefault, enableClusterLinkReplication);
        }
        return configuration;
    }

    private static String _clearCacheEventListenerConfigurations(CacheConfiguration cacheConfiguration) {
        List cacheEventListenerConfigurations = cacheConfiguration.getCacheEventListenerConfigurations();
        String cacheEventListenerProperties = null;
        for (Object cacheEventListenerConfiguration : cacheEventListenerConfigurations) {
            CacheConfiguration.CacheEventListenerFactoryConfiguration cacheEventListenerFactoryConfiguration = (CacheConfiguration.CacheEventListenerFactoryConfiguration)cacheEventListenerConfiguration;
            String fullyQualifiedClassPath = cacheEventListenerFactoryConfiguration.getFullyQualifiedClassPath();
            if (!fullyQualifiedClassPath.contains("LiferayCacheEventListenerFactory") && !fullyQualifiedClassPath.contains("net.sf.ehcache.distribution")) continue;
            cacheEventListenerProperties = cacheEventListenerFactoryConfiguration.getProperties();
            break;
        }
        cacheEventListenerConfigurations.clear();
        return cacheEventListenerProperties;
    }

    private static void _configureCacheEventListeners(boolean enableClusterLinkReplication, boolean clearCachePeerProviderConfigurations, boolean usingDefault, CacheConfiguration cacheConfiguration) {
        if (cacheConfiguration == null) {
            return;
        }
        List cacheEventListenerFactoryConfigurations = cacheConfiguration.getCacheEventListenerConfigurations();
        boolean usingLiferayCacheEventListenerFactory = false;
        for (CacheConfiguration.CacheEventListenerFactoryConfiguration cacheEventListenerFactoryConfiguration : cacheEventListenerFactoryConfigurations) {
            String className = cacheEventListenerFactoryConfiguration.getFullyQualifiedClassPath();
            if (!className.equals(LiferayCacheEventListenerFactory.class.getName())) continue;
            usingLiferayCacheEventListenerFactory = true;
            break;
        }
        if (clearCachePeerProviderConfigurations || !usingDefault && usingLiferayCacheEventListenerFactory) {
            String cacheEventListenerProperties = EhcacheConfigurationUtil._clearCacheEventListenerConfigurations(cacheConfiguration);
            if (enableClusterLinkReplication) {
                EhcacheConfigurationUtil._enableClusterLinkReplication(cacheConfiguration, cacheEventListenerProperties);
            }
        }
    }

    private static void _enableClusterLinkReplication(CacheConfiguration cacheConfiguration, String cacheEventListenerProperties) {
        CacheConfiguration.CacheEventListenerFactoryConfiguration cacheEventListenerFactoryConfiguration = new CacheConfiguration.CacheEventListenerFactoryConfiguration();
        cacheEventListenerFactoryConfiguration.setClass(EhcachePortalCacheClusterReplicatorFactory.class.getName());
        cacheEventListenerFactoryConfiguration.setProperties(cacheEventListenerProperties);
        cacheConfiguration.addCacheEventListenerFactory(cacheEventListenerFactoryConfiguration);
    }

    private static Configuration _processDefaultClusterLinkReplication(Configuration configuration, boolean usingDefault, boolean enableClusterLinkReplication) {
        boolean clearCachePeerProviderConfigurations = false;
        if (usingDefault && enableClusterLinkReplication || usingDefault && !PropsValues.CLUSTER_LINK_ENABLED) {
            clearCachePeerProviderConfigurations = true;
        }
        if (clearCachePeerProviderConfigurations) {
            configuration.getCacheManagerPeerListenerFactoryConfigurations().clear();
            configuration.getCacheManagerPeerProviderFactoryConfiguration().clear();
        }
        CacheConfiguration defaultCacheConfiguration = configuration.getDefaultCacheConfiguration();
        EhcacheConfigurationUtil._configureCacheEventListeners(enableClusterLinkReplication, clearCachePeerProviderConfigurations, usingDefault, defaultCacheConfiguration);
        Map cacheConfigurations = configuration.getCacheConfigurations();
        for (CacheConfiguration cacheConfiguration : cacheConfigurations.values()) {
            EhcacheConfigurationUtil._configureCacheEventListeners(enableClusterLinkReplication, clearCachePeerProviderConfigurations, usingDefault, cacheConfiguration);
        }
        return configuration;
    }
}

