/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.ehcache;

import com.liferay.portal.kernel.util.JavaDetector;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.util.PropsValues;
import java.lang.reflect.Field;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.Configuration;

public class CacheManagerUtil {
    private static Field _statisticsExecutorField;
    private static Field _workQueueField;

    static {
        try {
            _statisticsExecutorField = ReflectionUtil.getDeclaredField(CacheManager.class, (String)"statisticsExecutor");
            if (JavaDetector.isJDK6()) {
                _workQueueField = ReflectionUtil.getDeclaredField(ThreadPoolExecutor.class, (String)"workQueue");
            }
        }
        catch (Exception e2) {
            throw new ExceptionInInitializerError(e2);
        }
    }

    public static CacheManager createCacheManager(Configuration configuration) {
        CacheManager cacheManager = new CacheManager(configuration);
        try {
            ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = (ScheduledThreadPoolExecutor)_statisticsExecutorField.get(cacheManager);
            BlockingQueue blockingQueue = null;
            if (JavaDetector.isJDK6()) {
                blockingQueue = (BlockingQueue)_workQueueField.get(scheduledThreadPoolExecutor);
                _workQueueField.set(scheduledThreadPoolExecutor, new DelayQueue<RunnableScheduledFuture<?>>(){

                    @Override
                    public int remainingCapacity() {
                        return 0;
                    }
                });
            }
            scheduledThreadPoolExecutor.setCorePoolSize(PropsValues.EHCACHE_CACHE_MANAGER_STATISTICS_THREAD_POOL_SIZE);
            if (JavaDetector.isJDK6()) {
                while (scheduledThreadPoolExecutor.getPoolSize() > PropsValues.EHCACHE_CACHE_MANAGER_STATISTICS_THREAD_POOL_SIZE) {
                }
                _workQueueField.set(scheduledThreadPoolExecutor, blockingQueue);
            }
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
        return cacheManager;
    }
}

