/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.aspectj;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.util.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.aspectj.apache.bcel.classfile.ClassParser;
import org.aspectj.apache.bcel.classfile.JavaClass;
import org.aspectj.weaver.CrosscuttingMembersSet;
import org.aspectj.weaver.ReferenceType;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.bcel.BcelObjectType;
import org.aspectj.weaver.tools.GeneratedClassHandler;
import org.aspectj.weaver.tools.WeavingAdaptor;

public class URLWeavingAdaptor
extends WeavingAdaptor {
    private Map<String, byte[]> _generatedClasses = new HashMap<String, byte[]>();

    public URLWeavingAdaptor(URL[] urls, Class<?>[] aspectClasses) {
        super(null, urls, new URL[0]);
        this.generatedClassHandler = new RecordGeneratedClassHandler();
        Class<?>[] classArray = aspectClasses;
        int n = aspectClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> aspectClass = classArray[n2];
            this._addAspectClass(aspectClass);
            ++n2;
        }
        this.weaver.prepareForWeave();
    }

    public byte[] removeGeneratedClassDate(String name) {
        return this._generatedClasses.remove(name);
    }

    private void _addAspectClass(Class<?> aspectClass) {
        Class<?> currentClass = aspectClass;
        while (true) {
            Class<?>[] interfaceClasses;
            Class<?>[] classArray = interfaceClasses = currentClass.getInterfaces();
            int n = interfaceClasses.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> interfaceClass = classArray[n2];
                JavaClass javaClass = this._classToJavaClass(interfaceClass);
                if (javaClass != null) {
                    this.bcelWorld.addSourceObjectType(javaClass, false);
                }
                ++n2;
            }
            if ((currentClass = currentClass.getSuperclass()) == null) break;
            JavaClass javaClass = this._classToJavaClass(currentClass);
            if (javaClass == null) continue;
            this.bcelWorld.addSourceObjectType(javaClass, false);
        }
        JavaClass javaClass = this._classToJavaClass(aspectClass);
        BcelObjectType bcelObjectType = this.bcelWorld.addSourceObjectType(javaClass, false);
        ReferenceType resolvedType = bcelObjectType.getResolvedTypeX();
        if (!resolvedType.isAspect()) {
            throw new IllegalArgumentException("Class object " + aspectClass + " is not an aspect");
        }
        CrosscuttingMembersSet crosscuttingMembersSet = this.bcelWorld.getCrosscuttingMembersSet();
        crosscuttingMembersSet.addOrReplaceAspect((ResolvedType)resolvedType);
    }

    private JavaClass _classToJavaClass(Class<?> aspectClass) {
        ClassLoader aspectClassLoader = aspectClass.getClassLoader();
        if (aspectClassLoader == null) {
            aspectClassLoader = ClassLoader.getSystemClassLoader();
        }
        String resourcePath = aspectClass.getName();
        resourcePath = String.valueOf(resourcePath.replace('.', '/')) + ".class";
        ByteArrayInputStream byteArrayInputStream = null;
        InputStream inputStream = aspectClassLoader.getResourceAsStream(resourcePath);
        if (inputStream instanceof ByteArrayInputStream) {
            byteArrayInputStream = (ByteArrayInputStream)inputStream;
        } else {
            try {
                UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
                StreamUtil.transfer((InputStream)inputStream, (OutputStream)unsyncByteArrayOutputStream, (boolean)true);
                byte[] classData = unsyncByteArrayOutputStream.unsafeGetByteArray();
                byteArrayInputStream = new ByteArrayInputStream(classData, 0, unsyncByteArrayOutputStream.size());
            }
            catch (IOException ioe) {
                throw new RuntimeException("Unable to reload class data", ioe);
            }
        }
        ClassParser classParser = new ClassParser(byteArrayInputStream, String.valueOf(aspectClass.getSimpleName()) + ".class");
        try {
            return classParser.parse();
        }
        catch (Exception e2) {
            throw new RuntimeException("Unable to parse class data", e2);
        }
    }

    private class RecordGeneratedClassHandler
    implements GeneratedClassHandler {
        private RecordGeneratedClassHandler() {
        }

        public void acceptClass(String name, byte[] bytes) {
            URLWeavingAdaptor.this._generatedClasses.put(name, bytes);
        }
    }
}

