/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.action;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.license.util.LicenseManagerUtil;
import com.liferay.portal.license.util.LicenseUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.admin.util.OmniadminUtil;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class UpdateLicenseAction
extends Action {
    public ActionForward execute(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this._isValidRequest(request)) {
            String cmd = ParamUtil.getString((HttpServletRequest)request, (String)"cmd");
            String clusterNodeId = ParamUtil.getString((HttpServletRequest)request, (String)"clusterNodeId");
            if (cmd.equals("licenseProperties")) {
                String licenseProperties = this._getLicenseProperties(clusterNodeId);
                response.setContentType("application/json");
                ServletResponseUtil.write((HttpServletResponse)response, (String)licenseProperties);
                return null;
            }
            if (cmd.equals("serverInfo")) {
                String serverInfo = this._getServerInfo(clusterNodeId);
                response.setContentType("application/json");
                ServletResponseUtil.write((HttpServletResponse)response, (String)serverInfo);
                return null;
            }
            return actionMapping.findForward("portal.license");
        }
        response.sendRedirect(String.valueOf(PortalUtil.getPathContext()) + "/c/portal/layout");
        return null;
    }

    private String _getLicenseProperties(String clusterNodeId) {
        List licenseProperties = LicenseManagerUtil.getClusterLicenseProperties((String)clusterNodeId);
        if (licenseProperties == null) {
            return "";
        }
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (Map propertiesMap : licenseProperties) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            for (Map.Entry entry : propertiesMap.entrySet()) {
                jsonObject.put((String)entry.getKey(), (String)entry.getValue());
            }
            jsonArray.put(jsonObject);
        }
        return jsonArray.toString();
    }

    private String _getServerInfo(String clusterNodeId) throws Exception {
        Map<String, String> serverInfo = LicenseUtil.getClusterServerInfo(clusterNodeId);
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        if (serverInfo != null) {
            for (Map.Entry<String, String> entry : serverInfo.entrySet()) {
                jsonObject.put(entry.getKey(), entry.getValue());
            }
        }
        return jsonObject.toString();
    }

    private boolean _isOmniAdmin(HttpServletRequest request) {
        User user = null;
        try {
            user = PortalUtil.getUser((HttpServletRequest)request);
        }
        catch (Exception exception) {}
        return user != null && OmniadminUtil.isOmniadmin(user);
    }

    private boolean _isValidRequest(HttpServletRequest request) {
        if (this._isOmniAdmin(request)) {
            LicenseUtil.registerOrder(request);
            return true;
        }
        return false;
    }
}

