/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.action;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.ResourceLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class TCKAction
extends Action {
    private static Log _log = LogFactoryUtil.getLog(TCKAction.class);

    public ActionForward execute(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            if (!PropsValues.TCK_URL) {
                throw new PrincipalException("TCK testing is disabled");
            }
            User user = this._getUser(request);
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            String[] portletIds = request.getParameterValues("portletId");
            if (portletIds == null) {
                portletIds = request.getParameterValues("portletName");
            }
            int i2 = 0;
            while (i2 < portletIds.length) {
                String[] nameAndWar = StringUtil.split((String)portletIds[i2], (char)'/');
                portletIds[i2] = PortalUtil.getJsSafePortletId((String)(String.valueOf(nameAndWar[1]) + "_WAR_" + nameAndWar[0]));
                ++i2;
            }
            long userId = user.getUserId();
            long groupId = user.getGroupId();
            ServiceContext serviceContext = new ServiceContext();
            Layout layout = LayoutLocalServiceUtil.addLayout((long)userId, (long)groupId, (boolean)false, (long)0L, (String)"TCKAction", (String)"", (String)"", (String)"portlet", (boolean)false, (String)"", (ServiceContext)serviceContext);
            LayoutTypePortlet layoutType = (LayoutTypePortlet)layout.getLayoutType();
            String[] stringArray = portletIds;
            int n = portletIds.length;
            int n2 = 0;
            while (n2 < n) {
                String portletId = stringArray[n2];
                layoutType.addPortletId(userId, portletId, false);
                String rootPortletId = PortletConstants.getRootPortletId((String)portletId);
                String portletPrimaryKey = PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)portletId);
                ResourceLocalServiceUtil.addResources((long)user.getCompanyId(), (long)groupId, (long)0L, (String)rootPortletId, (String)portletPrimaryKey, (boolean)true, (boolean)true, (boolean)true);
                ++n2;
            }
            LayoutLocalServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)layout.getTypeSettings());
            request.setAttribute("FORWARD_URL", (Object)(String.valueOf(themeDisplay.getPathMain()) + "/portal/layout?p_l_id=" + layout.getPlid()));
            return actionMapping.findForward("/common/forward_jsp.jsp");
        }
        catch (Exception e2) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e2, (Throwable)e2);
            }
            PortalUtil.sendError((Exception)e2, (HttpServletRequest)request, (HttpServletResponse)response);
            return null;
        }
    }

    private User _getUser(HttpServletRequest request) throws Exception {
        long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
        try {
            return UserLocalServiceUtil.getUserByScreenName((long)companyId, (String)"tck");
        }
        catch (Exception exception) {
            String password1;
            long creatorUserId = 0L;
            boolean autoPassword = false;
            String password2 = password1 = "password";
            boolean autoScreenName = false;
            String screenName = "tck";
            String emailAddress = "tck@liferay.com";
            long facebookId = 0L;
            String openId = "";
            Locale locale = LocaleUtil.US;
            String firstName = "TCK";
            String middleName = "";
            String lastName = "User";
            int prefixId = 0;
            int suffixId = 0;
            boolean male = true;
            int birthdayMonth = 0;
            int birthdayDay = 1;
            int birthdayYear = 1970;
            String jobTitle = "";
            long[] groupIds = null;
            long[] organizationIds = null;
            long[] roleIds = null;
            long[] userGroupIds = null;
            boolean sendEmail = false;
            ServiceContext serviceContext = new ServiceContext();
            return UserLocalServiceUtil.addUser((long)creatorUserId, (long)companyId, (boolean)autoPassword, (String)password1, (String)password2, (boolean)autoScreenName, (String)screenName, (String)emailAddress, (long)facebookId, (String)openId, (Locale)locale, (String)firstName, (String)middleName, (String)lastName, (int)prefixId, (int)suffixId, (boolean)male, (int)birthdayMonth, (int)birthdayDay, (int)birthdayYear, (String)jobTitle, (long[])groupIds, (long[])organizationIds, (long[])roleIds, (long[])userGroupIds, (boolean)sendEmail, (ServiceContext)serviceContext);
        }
    }
}

