/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.util;

import com.liferay.mail.model.Filter;
import com.liferay.mail.util.Hook;
import com.liferay.portal.kernel.googleapps.GEmailSettingsManager;
import com.liferay.portal.kernel.googleapps.GNicknameManager;
import com.liferay.portal.kernel.googleapps.GUserManager;
import com.liferay.portal.kernel.googleapps.GoogleAppsFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.FullNameGenerator;
import com.liferay.portal.security.auth.FullNameGeneratorFactory;
import com.liferay.portal.service.UserLocalServiceUtil;
import java.util.List;

public class GoogleHook
implements Hook {
    private static Log _log = LogFactoryUtil.getLog(GoogleHook.class);

    public void addForward(long companyId, long userId, List<Filter> filters, List<String> emailAddresses, boolean leaveCopy) {
    }

    public void addUser(long companyId, long userId, String password, String firstName, String middleName, String lastName, String emailAddress) {
        try {
            String nickname = this._getNickname(emailAddress);
            GUserManager gUserManager = GoogleAppsFactoryUtil.getGUserManager((long)companyId);
            gUserManager.addGUser(userId, password, firstName, lastName);
            GNicknameManager gNicknameManager = GoogleAppsFactoryUtil.getGNicknameManager((long)companyId);
            gNicknameManager.addGNickname(userId, nickname);
            GEmailSettingsManager gEmailSettingsManager = GoogleAppsFactoryUtil.getGEmailSettingsManager((long)companyId);
            FullNameGenerator fullNameGenerator = FullNameGeneratorFactory.getInstance();
            gEmailSettingsManager.addSendAs(userId, fullNameGenerator.getFullName(firstName, middleName, lastName), emailAddress);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    public void addVacationMessage(long companyId, long userId, String emailAddress, String vacationMessage) {
    }

    public void deleteEmailAddress(long companyId, long userId) {
        try {
            User user = UserLocalServiceUtil.getUserById((long)userId);
            String nickname = this._getNickname(user.getEmailAddress());
            GNicknameManager gNicknameManager = GoogleAppsFactoryUtil.getGNicknameManager((long)companyId);
            gNicknameManager.deleteGNickname(nickname);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    public void deleteUser(long companyId, long userId) {
        try {
            GUserManager gUserManager = GoogleAppsFactoryUtil.getGUserManager((long)companyId);
            gUserManager.deleteGUser(userId);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    public void updateBlocked(long companyId, long userId, List<String> blocked) {
    }

    public void updateEmailAddress(long companyId, long userId, String emailAddress) {
        try {
            User user = UserLocalServiceUtil.getUserById((long)userId);
            this.deleteEmailAddress(companyId, userId);
            GNicknameManager gNicknameManager = GoogleAppsFactoryUtil.getGNicknameManager((long)companyId);
            String nickname = this._getNickname(emailAddress);
            gNicknameManager.addGNickname(userId, nickname);
            GEmailSettingsManager gEmailSettingsManager = GoogleAppsFactoryUtil.getGEmailSettingsManager((long)companyId);
            gEmailSettingsManager.addSendAs(userId, user.getFullName(), emailAddress);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    public void updatePassword(long companyId, long userId, String password) {
        try {
            GUserManager gUserManager = GoogleAppsFactoryUtil.getGUserManager((long)companyId);
            gUserManager.updatePassword(userId, password);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    private String _getNickname(String emailAddress) {
        int pos = emailAddress.indexOf(64);
        return emailAddress.substring(0, pos);
    }
}

