/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.util;

import com.liferay.mail.model.Filter;
import com.liferay.mail.service.CyrusServiceUtil;
import com.liferay.mail.util.Hook;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.process.OutputProcessor;
import com.liferay.portal.kernel.process.ProcessUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsUtil;
import java.io.File;
import java.util.List;
import java.util.concurrent.Future;

public class CyrusHook
implements Hook {
    private static Log _log = LogFactoryUtil.getLog(CyrusHook.class);

    public void addForward(long companyId, long userId, List<Filter> filters, List<String> emailAddresses, boolean leaveCopy) {
        try {
            if (emailAddresses != null) {
                String home = PropsUtil.get("mail.hook.cyrus.home");
                File file = new File(String.valueOf(home) + "/" + userId + ".procmail.forward");
                if (filters.size() > 0 || emailAddresses.size() > 0 || leaveCopy) {
                    StringBundler sb = new StringBundler();
                    int i2 = 0;
                    while (i2 < filters.size()) {
                        Filter filter = filters.get(i2);
                        sb.append(":0\n");
                        sb.append("* ^(From|Cc|To).*");
                        sb.append(filter.getEmailAddress());
                        sb.append("\n");
                        sb.append("| $DELIVER -e -a $USER -m user.$USER.");
                        sb.append(filter.getFolder());
                        sb.append("\n\n");
                        ++i2;
                    }
                    if (leaveCopy) {
                        sb.append(":0 c\n");
                        sb.append("| $DELIVER -e -a $USER -m user.$USER\n\n");
                    }
                    if (emailAddresses.size() > 0) {
                        sb.append(":0\n");
                        sb.append("!");
                        for (String emailAddress : emailAddresses) {
                            sb.append(" ");
                            sb.append(emailAddress);
                        }
                    }
                    String content = sb.toString();
                    while (content.endsWith("\n")) {
                        content = content.substring(0, content.length() - 1);
                    }
                    FileUtil.write((File)file, (String)content);
                } else {
                    file.delete();
                }
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    public void addUser(long companyId, long userId, String password, String firstName, String middleName, String lastName, String emailAddress) {
        try {
            CyrusServiceUtil.addUser((long)userId, (String)emailAddress, (String)password);
            String addUserCmd = PropsUtil.get("mail.hook.cyrus.add.user");
            addUserCmd = StringUtil.replace((String)addUserCmd, (String)"%1%", (String)String.valueOf(userId));
            Future future = ProcessUtil.execute((OutputProcessor)ProcessUtil.LOGGING_OUTPUT_PROCESSOR, (String[])new String[]{addUserCmd});
            future.get();
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    public void addVacationMessage(long companyId, long userId, String emailAddress, String vacationMessage) {
        try {
            String home = PropsUtil.get("mail.hook.cyrus.home");
            new File(String.valueOf(home) + "/" + userId + ".vacation.cache").delete();
            File vacation = new File(String.valueOf(home) + "/" + userId + ".vacation");
            if (Validator.isNull((String)vacationMessage)) {
                vacation.delete();
            } else {
                FileUtil.write((File)vacation, (String)(String.valueOf(emailAddress) + "\n" + vacationMessage));
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    public void deleteEmailAddress(long companyId, long userId) {
        try {
            CyrusServiceUtil.deleteEmailAddress((long)companyId, (long)userId);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    public void deleteUser(long companyId, long userId) {
        try {
            CyrusServiceUtil.deleteUser((long)userId);
            String deleteUserCmd = PropsUtil.get("mail.hook.cyrus.delete.user");
            deleteUserCmd = StringUtil.replace((String)deleteUserCmd, (String)"%1%", (String)String.valueOf(userId));
            Future future = ProcessUtil.execute((OutputProcessor)ProcessUtil.LOGGING_OUTPUT_PROCESSOR, (String[])new String[]{deleteUserCmd});
            future.get();
            String home = PropsUtil.get("mail.hook.cyrus.home");
            File file = new File(String.valueOf(home) + "/" + userId + ".procmail.blocked");
            if (file.exists()) {
                file.delete();
            }
            if ((file = new File(String.valueOf(home) + "/" + userId + ".procmail.forward")).exists()) {
                file.delete();
            }
            if ((file = new File(String.valueOf(home) + "/" + userId + ".vacation")).exists()) {
                file.delete();
            }
            if ((file = new File(String.valueOf(home) + "/" + userId + ".vacation.cache")).exists()) {
                file.delete();
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    public void updateBlocked(long companyId, long userId, List<String> blocked) {
        String home = PropsUtil.get("mail.hook.cyrus.home");
        File file = new File(String.valueOf(home) + "/" + userId + ".procmail.blocked");
        if (blocked == null || blocked.size() == 0) {
            file.delete();
            return;
        }
        StringBundler sb = new StringBundler(blocked.size() * 9);
        int i2 = 0;
        while (i2 < blocked.size()) {
            String emailAddress = blocked.get(i2);
            sb.append("\n");
            sb.append(":0\n");
            sb.append("* ^From.*");
            sb.append(emailAddress);
            sb.append("\n");
            sb.append("{\n");
            sb.append(":0\n");
            sb.append("/dev/null\n");
            sb.append("}\n");
            ++i2;
        }
        try {
            FileUtil.write((File)file, (String)sb.toString());
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    public void updateEmailAddress(long companyId, long userId, String emailAddress) {
        try {
            CyrusServiceUtil.updateEmailAddress((long)companyId, (long)userId, (String)emailAddress);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    public void updatePassword(long companyId, long userId, String password) {
        try {
            CyrusServiceUtil.updatePassword((long)companyId, (long)userId, (String)password);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }
}

