/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.util;

import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.WikiNodeServiceUtil;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import com.liferay.portlet.wiki.service.permission.WikiPagePermission;
import com.liferay.portlet.wiki.service.persistence.WikiNodeActionableDynamicQuery;
import com.liferay.portlet.wiki.service.persistence.WikiPageActionableDynamicQuery;
import com.liferay.portlet.wiki.util.WikiPageAttachmentsUtil;
import com.liferay.portlet.wiki.util.WikiUtil;
import java.util.ArrayList;
import java.util.Locale;
import javax.portlet.PortletURL;

public class WikiPageIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{WikiPage.class.getName()};
    public static final String PORTLET_ID = "36";

    public WikiPageIndexer() {
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    public void addRelatedEntryFields(Document document, Object obj) throws Exception {
        WikiPage page = null;
        if (obj instanceof DLFileEntry) {
            DLFileEntry dlFileEntry = (DLFileEntry)obj;
            page = WikiPageAttachmentsUtil.getPage(dlFileEntry.getFileEntryId());
            document.addKeyword("classNameId", PortalUtil.getClassNameId((String)WikiPage.class.getName()));
            document.addKeyword("classPK", page.getResourcePrimKey());
        } else if (obj instanceof MBMessage) {
            MBMessage message = (MBMessage)obj;
            page = WikiPageLocalServiceUtil.getPage((long)message.getClassPK());
        }
        document.addKeyword("nodeId", page.getNodeId());
        document.addKeyword("relatedEntry", true);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getPortletId() {
        return PORTLET_ID;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        WikiPage page = WikiPageLocalServiceUtil.getPage((long)entryClassPK);
        return WikiPagePermission.contains(permissionChecker, page, "VIEW");
    }

    public void postProcessContextQuery(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        long[] nodeIds;
        int status = GetterUtil.getInteger((Object)searchContext.getAttribute("status"), (int)0);
        if (status != -1) {
            contextQuery.addRequiredTerm("status", status);
        }
        if ((nodeIds = searchContext.getNodeIds()) != null && nodeIds.length > 0) {
            BooleanQuery nodeIdsQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
            long[] lArray = nodeIds;
            int n = nodeIds.length;
            int n2 = 0;
            while (n2 < n) {
                block5: {
                    long nodeId = lArray[n2];
                    try {
                        WikiNodeServiceUtil.getNode((long)nodeId);
                    }
                    catch (Exception exception) {
                        break block5;
                    }
                    nodeIdsQuery.addTerm("nodeId", nodeId);
                }
                ++n2;
            }
            contextQuery.add((Query)nodeIdsQuery, BooleanClauseOccur.MUST);
        }
    }

    protected void doDelete(Object obj) throws Exception {
        SearchContext searchContext = new SearchContext();
        searchContext.setSearchEngineId(this.getSearchEngineId());
        if (obj instanceof Object[]) {
            Object[] array = (Object[])obj;
            long companyId = (Long)array[0];
            long nodeId = (Long)array[1];
            String title = (String)array[2];
            DocumentImpl document = new DocumentImpl();
            document.addUID(PORTLET_ID, nodeId, title);
            SearchEngineUtil.deleteDocument((String)this.getSearchEngineId(), (long)companyId, (String)document.get("uid"));
        } else if (obj instanceof WikiNode) {
            WikiNode node = (WikiNode)obj;
            BooleanQuery booleanQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
            booleanQuery.addRequiredTerm("portletId", PORTLET_ID);
            booleanQuery.addRequiredTerm("nodeId", node.getNodeId());
            Hits hits = SearchEngineUtil.search((String)this.getSearchEngineId(), (long)node.getCompanyId(), (Query)booleanQuery, (int)-1, (int)-1);
            int i2 = 0;
            while (i2 < hits.getLength()) {
                Document document = hits.doc(i2);
                SearchEngineUtil.deleteDocument((String)this.getSearchEngineId(), (long)node.getCompanyId(), (String)document.get("uid"));
                ++i2;
            }
        } else if (obj instanceof WikiPage) {
            WikiPage page = (WikiPage)obj;
            DocumentImpl document = new DocumentImpl();
            document.addUID(PORTLET_ID, page.getNodeId(), page.getTitle());
            SearchEngineUtil.deleteDocument((String)this.getSearchEngineId(), (long)page.getCompanyId(), (String)document.get("uid"));
        }
    }

    protected Document doGetDocument(Object obj) throws Exception {
        WikiPage page = (WikiPage)obj;
        Document document = this.getBaseModelDocument(PORTLET_ID, (BaseModel)page);
        document.addUID(PORTLET_ID, page.getNodeId(), page.getTitle());
        String content = HtmlUtil.extractText((String)WikiUtil.convert(page, null, null, null));
        document.addText("content", content);
        document.addKeyword("nodeId", page.getNodeId());
        document.addText("title", page.getTitle());
        if (!page.isInTrash() && page.isInTrashContainer()) {
            this.addTrashFields(document, WikiNode.class.getName(), page.getNodeId(), null, null, "wiki");
            document.addKeyword("rootEntryClassName", WikiNode.class.getName());
            document.addKeyword("rootEntryClassPK", page.getNodeId());
            document.addKeyword("status", 8);
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletURL portletURL) {
        Summary summary = this.createSummary(document, "title", "content");
        summary.setMaxContentLength(200);
        String nodeId = document.get("nodeId");
        portletURL.setParameter("struts_action", "/wiki/view");
        portletURL.setParameter("nodeId", nodeId);
        portletURL.setParameter("title", summary.getTitle());
        summary.setPortletURL(portletURL);
        return summary;
    }

    protected void doReindex(Object obj) throws Exception {
        WikiPage page = (WikiPage)obj;
        if (Validator.isNotNull((String)page.getRedirectTitle())) {
            return;
        }
        Document document = this.getDocument(page);
        SearchEngineUtil.updateDocument((String)this.getSearchEngineId(), (long)page.getCompanyId(), (Document)document);
    }

    protected void doReindex(String className, long classPK) throws Exception {
        WikiPage page = WikiPageLocalServiceUtil.getPage((long)classPK);
        this.doReindex(page);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexNodes(companyId);
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected void reindexNodes(final long companyId) throws PortalException, SystemException {
        WikiNodeActionableDynamicQuery actionableDynamicQuery = new WikiNodeActionableDynamicQuery(){

            protected void performAction(Object object) throws PortalException, SystemException {
                WikiNode node = (WikiNode)object;
                WikiPageIndexer.this.reindexPages(companyId, node.getGroupId(), node.getNodeId());
            }
        };
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.performActions();
    }

    protected void reindexPages(long companyId, long groupId, final long nodeId) throws PortalException, SystemException {
        final ArrayList documents = new ArrayList();
        WikiPageActionableDynamicQuery actionableDynamicQuery = new WikiPageActionableDynamicQuery(){

            protected void addCriteria(DynamicQuery dynamicQuery) {
                Property nodeIdProperty = PropertyFactoryUtil.forName((String)"nodeId");
                dynamicQuery.add(nodeIdProperty.eq((Object)nodeId));
                Property headProperty = PropertyFactoryUtil.forName((String)"head");
                dynamicQuery.add(headProperty.eq((Object)true));
            }

            protected void performAction(Object object) throws PortalException {
                WikiPage page = (WikiPage)object;
                Document document = WikiPageIndexer.this.getDocument(page);
                documents.add(document);
            }
        };
        actionableDynamicQuery.setGroupId(groupId);
        actionableDynamicQuery.performActions();
        SearchEngineUtil.updateDocuments((String)this.getSearchEngineId(), (long)companyId, documents);
    }
}

