/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.util;

import com.liferay.portal.kernel.cache.MultiVMPoolUtil;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portlet.wiki.PageContentException;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.model.WikiPageDisplay;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import com.liferay.portlet.wiki.util.WikiUtil;
import java.io.Serializable;
import java.util.Map;
import javax.portlet.PortletURL;
import org.apache.commons.lang.time.StopWatch;

public class WikiCacheUtil {
    private static final String _CACHE_NAME = WikiCacheUtil.class.getName();
    private static final String _OUTGOING_LINKS = "OUTGOING_LINKS";
    private static Log _log = LogFactoryUtil.getLog(WikiCacheUtil.class);
    private static PortalCache<String, Serializable> _portalCache = MultiVMPoolUtil.getCache((String)_CACHE_NAME);

    public static void clearCache(long nodeId) {
        _portalCache.removeAll();
    }

    public static void clearCache(long nodeId, String title) {
        WikiCacheUtil.clearCache(nodeId);
    }

    public static WikiPageDisplay getDisplay(long nodeId, String title, PortletURL viewPageURL, PortletURL editPageURL, String attachmentURLPrefix) {
        String key;
        WikiPageDisplay pageDisplay;
        StopWatch stopWatch = null;
        if (_log.isDebugEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        if ((pageDisplay = (WikiPageDisplay)_portalCache.get((Serializable)((Object)(key = WikiCacheUtil._encodeKey(nodeId, title, viewPageURL.toString()))))) == null) {
            pageDisplay = WikiCacheUtil._getPageDisplay(nodeId, title, viewPageURL, editPageURL, attachmentURLPrefix);
            _portalCache.put((Serializable)((Object)key), (Object)pageDisplay);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("getDisplay for {" + nodeId + ", " + title + ", " + viewPageURL + ", " + editPageURL + "} takes " + stopWatch.getTime() + " ms"));
        }
        return pageDisplay;
    }

    public static Map<String, Boolean> getOutgoingLinks(WikiPage page) throws PageContentException {
        String key = WikiCacheUtil._encodeKey(page.getNodeId(), page.getTitle(), _OUTGOING_LINKS);
        Map<String, Boolean> links = (Map<String, Boolean>)_portalCache.get((Serializable)((Object)key));
        if (links == null) {
            links = WikiUtil.getLinks(page);
            _portalCache.put((Serializable)((Object)key), (Object)((Serializable)((Object)links)));
        }
        return links;
    }

    private static String _encodeKey(long nodeId, String title, String postfix) {
        StringBundler sb = new StringBundler(6);
        sb.append(_CACHE_NAME);
        sb.append("#");
        sb.append(StringUtil.toHexString((long)nodeId));
        sb.append(title);
        if (postfix != null) {
            sb.append("#");
            sb.append(postfix);
        }
        return sb.toString();
    }

    private static WikiPageDisplay _getPageDisplay(long nodeId, String title, PortletURL viewPageURL, PortletURL editPageURL, String attachmentURLPrefix) {
        try {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Get page display for {" + nodeId + ", " + title + ", " + viewPageURL + ", " + editPageURL + "}"));
            }
            return WikiPageLocalServiceUtil.getPageDisplay((long)nodeId, (String)title, (PortletURL)viewPageURL, (PortletURL)editPageURL, (String)attachmentURLPrefix);
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to get page display for {" + nodeId + ", " + title + ", " + viewPageURL + ", " + editPageURL + "}"));
            }
            return null;
        }
    }
}

