/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.trash;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.trash.BaseTrashHandler;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.ContainerModel;
import com.liferay.portal.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletURLFactoryUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.trash.DuplicateEntryException;
import com.liferay.portlet.trash.model.TrashEntry;
import com.liferay.portlet.wiki.asset.WikiPageAssetRenderer;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.model.WikiPageResource;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import com.liferay.portlet.wiki.service.WikiPageResourceLocalServiceUtil;
import com.liferay.portlet.wiki.service.WikiPageServiceUtil;
import com.liferay.portlet.wiki.service.permission.WikiNodePermission;
import com.liferay.portlet.wiki.service.permission.WikiPagePermission;
import com.liferay.portlet.wiki.util.WikiPageAttachmentsUtil;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletRequest;

public class WikiPageTrashHandler
extends BaseTrashHandler {
    public void checkDuplicateTrashEntry(TrashEntry trashEntry, long containerModelId, String newName) throws PortalException, SystemException {
        WikiPageResource pageResource;
        WikiPage page = WikiPageLocalServiceUtil.getPage((long)trashEntry.getClassPK());
        if (containerModelId == -1L) {
            containerModelId = page.getNodeId();
        }
        String originalTitle = trashEntry.getTypeSettingsProperty("title");
        if (Validator.isNotNull((String)newName)) {
            originalTitle = newName;
        }
        if ((pageResource = WikiPageResourceLocalServiceUtil.fetchPageResource((long)containerModelId, (String)originalTitle)) != null) {
            DuplicateEntryException dee = new DuplicateEntryException();
            WikiPage duplicatePage = WikiPageLocalServiceUtil.getPage((long)pageResource.getResourcePrimKey());
            dee.setDuplicateEntryId(duplicatePage.getResourcePrimKey());
            dee.setOldName(duplicatePage.getTitle());
            dee.setTrashEntryId(trashEntry.getEntryId());
            throw dee;
        }
    }

    public void deleteTrashEntry(long classPK) throws PortalException, SystemException {
        WikiPage page = WikiPageLocalServiceUtil.getPage((long)classPK);
        WikiPageLocalServiceUtil.deletePage((long)page.getNodeId(), (String)page.getTitle());
    }

    public String getClassName() {
        return WikiPage.class.getName();
    }

    public String getContainerModelClassName() {
        return WikiNode.class.getName();
    }

    public String getContainerModelName() {
        return "wiki-node";
    }

    public ContainerModel getParentContainerModel(long classPK) throws PortalException, SystemException {
        WikiPage page = WikiPageLocalServiceUtil.getPage((long)classPK);
        return page.getNode();
    }

    public List<ContainerModel> getParentContainerModels(long classPK) throws PortalException, SystemException {
        ArrayList<ContainerModel> containerModels = new ArrayList<ContainerModel>();
        containerModels.add(this.getParentContainerModel(classPK));
        return containerModels;
    }

    public String getRestoreLink(PortletRequest portletRequest, long classPK) throws PortalException, SystemException {
        String portletId = "36";
        WikiPage page = WikiPageLocalServiceUtil.getPage((long)classPK);
        long plid = PortalUtil.getPlidFromPortletId((long)page.getGroupId(), (String)"36");
        if (plid == 0L) {
            portletId = "154";
            plid = PortalUtil.getControlPanelPlid((PortletRequest)portletRequest);
        }
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)portletRequest, (String)portletId, (long)plid, (String)"RENDER_PHASE");
        WikiNode node = page.getNode();
        if (portletId.equals("36")) {
            portletURL.setParameter("struts_action", "/wiki/view");
        } else {
            portletURL.setParameter("struts_action", "/wiki_admin/view");
        }
        portletURL.setParameter("nodeName", node.getName());
        portletURL.setParameter("title", HtmlUtil.unescape((String)page.getTitle()));
        return portletURL.toString();
    }

    public String getRestoreMessage(PortletRequest portletRequest, long classPK) throws PortalException, SystemException {
        WikiPage page = WikiPageLocalServiceUtil.getPage((long)classPK);
        return page.getTitle();
    }

    public ContainerModel getTrashContainer(long classPK) throws PortalException, SystemException {
        WikiPage page = WikiPageLocalServiceUtil.getPage((long)classPK);
        return page.getTrashContainer();
    }

    public TrashRenderer getTrashRenderer(long classPK) throws PortalException, SystemException {
        WikiPage page = WikiPageLocalServiceUtil.getPage((long)classPK);
        return new WikiPageAssetRenderer(page);
    }

    public boolean hasTrashPermission(PermissionChecker permissionChecker, long groupId, long classPK, String trashActionId) throws PortalException, SystemException {
        if (trashActionId.equals("MOVE")) {
            WikiNodePermission.check(permissionChecker, classPK, "ADD_PAGE");
        }
        return super.hasTrashPermission(permissionChecker, groupId, classPK, trashActionId);
    }

    public boolean isInTrash(long classPK) throws PortalException, SystemException {
        WikiPage page = WikiPageLocalServiceUtil.getPage((long)classPK);
        return page.isInTrash();
    }

    public boolean isInTrashContainer(long classPK) throws PortalException, SystemException {
        WikiPage page = WikiPageLocalServiceUtil.getPage((long)classPK);
        return page.isInTrashContainer();
    }

    public void restoreRelatedTrashEntry(String className, long classPK) throws PortalException, SystemException {
        if (!className.equals(DLFileEntry.class.getName())) {
            return;
        }
        FileEntry fileEntry = PortletFileRepositoryUtil.getPortletFileEntry((long)classPK);
        WikiPage page = WikiPageAttachmentsUtil.getPage(classPK);
        WikiPageServiceUtil.restorePageAttachmentFromTrash((long)page.getNodeId(), (String)page.getTitle(), (String)fileEntry.getTitle());
    }

    public void restoreTrashEntry(long userId, long classPK) throws PortalException, SystemException {
        WikiPage page = WikiPageLocalServiceUtil.getPage((long)classPK);
        WikiPageLocalServiceUtil.restorePageFromTrash((long)userId, (WikiPage)page);
    }

    public void updateTitle(long classPK, String name) throws PortalException, SystemException {
        WikiPage page = WikiPageLocalServiceUtil.getPage((long)classPK);
        page.setTitle(name);
        WikiPageLocalServiceUtil.updateWikiPage((WikiPage)page);
        WikiPageResource pageResource = WikiPageResourceLocalServiceUtil.getPageResource((long)page.getResourcePrimKey());
        pageResource.setTitle(name);
        WikiPageResourceLocalServiceUtil.updateWikiPageResource((WikiPageResource)pageResource);
    }

    protected boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws PortalException, SystemException {
        return WikiPagePermission.contains(permissionChecker, classPK, actionId);
    }
}

