/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.workflow.permission.WorkflowPermissionUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.wiki.NoSuchPageException;
import com.liferay.portlet.wiki.NoSuchPageResourceException;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import com.liferay.portlet.wiki.service.permission.WikiNodePermission;

public class WikiPagePermission {
    public static void check(PermissionChecker permissionChecker, long resourcePrimKey, String actionId) throws PortalException, SystemException {
        if (!WikiPagePermission.contains(permissionChecker, resourcePrimKey, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long nodeId, String title, double version, String actionId) throws PortalException, SystemException {
        if (!WikiPagePermission.contains(permissionChecker, nodeId, title, version, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long nodeId, String title, String actionId) throws PortalException, SystemException {
        if (!WikiPagePermission.contains(permissionChecker, nodeId, title, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, WikiPage page, String actionId) throws PortalException {
        if (!WikiPagePermission.contains(permissionChecker, page, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long resourcePrimKey, String actionId) throws PortalException, SystemException {
        try {
            WikiPage page = WikiPageLocalServiceUtil.getPage((long)resourcePrimKey, null);
            return WikiPagePermission.contains(permissionChecker, page, actionId);
        }
        catch (NoSuchPageResourceException noSuchPageResourceException) {
            return false;
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long nodeId, String title, double version, String actionId) throws PortalException, SystemException {
        try {
            WikiPage page = WikiPageLocalServiceUtil.getPage((long)nodeId, (String)title, (double)version);
            return WikiPagePermission.contains(permissionChecker, page, actionId);
        }
        catch (NoSuchPageException noSuchPageException) {
            return WikiNodePermission.contains(permissionChecker, nodeId, "VIEW");
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long nodeId, String title, String actionId) throws PortalException, SystemException {
        try {
            WikiPage page = WikiPageLocalServiceUtil.getPage((long)nodeId, (String)title, null);
            return WikiPagePermission.contains(permissionChecker, page, actionId);
        }
        catch (NoSuchPageException noSuchPageException) {
            return WikiNodePermission.contains(permissionChecker, nodeId, "VIEW");
        }
    }

    /*
     * Unable to fully structure code
     */
    public static boolean contains(PermissionChecker permissionChecker, WikiPage page, String actionId) {
        block8: {
            if (actionId.equals("VIEW") && (redirectPage = page.getRedirectPage()) != null) {
                page = redirectPage;
            }
            node = page.getNode();
            if (!PropsValues.PERMISSIONS_VIEW_DYNAMIC_INHERITANCE) break block8;
            originalPage = page;
            if (WikiNodePermission.contains(permissionChecker, node, "VIEW")) ** GOTO lbl11
            return false;
lbl-1000:
            // 1 sources

            {
                if (!permissionChecker.hasOwnerPermission(page.getCompanyId(), WikiPage.class.getName(), page.getResourcePrimKey(), page.getUserId(), "VIEW") && !permissionChecker.hasPermission(page.getGroupId(), WikiPage.class.getName(), page.getResourcePrimKey(), "VIEW")) {
                    return false;
                }
                page = page.getParentPage();
lbl11:
                // 2 sources

                ** while (page != null)
            }
lbl12:
            // 1 sources

            if (actionId.equals("VIEW")) {
                return true;
            }
            page = originalPage;
        }
        if (!WikiNodePermission.contains(permissionChecker, node, actionId)) ** GOTO lbl25
        return true;
lbl-1000:
        // 1 sources

        {
            if (page.isPending() && (hasPermission = WorkflowPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)page.getGroupId(), (String)WikiPage.class.getName(), (long)page.getResourcePrimKey(), (String)actionId)) != null && hasPermission.booleanValue()) {
                return true;
            }
            if (page.isDraft() && actionId.equals("DELETE") && page.getStatusByUserId() == permissionChecker.getUserId()) {
                return true;
            }
            if (permissionChecker.hasOwnerPermission(page.getCompanyId(), WikiPage.class.getName(), page.getResourcePrimKey(), page.getUserId(), actionId) || permissionChecker.hasPermission(page.getGroupId(), WikiPage.class.getName(), page.getResourcePrimKey(), actionId)) {
                return true;
            }
            page = page.getParentPage();
lbl25:
            // 2 sources

            ** while (page != null)
        }
lbl26:
        // 1 sources

        return false;
    }
}

