/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.service.base.WikiNodeServiceBaseImpl;
import com.liferay.portlet.wiki.service.permission.WikiNodePermission;
import com.liferay.portlet.wiki.service.permission.WikiPermission;
import java.io.InputStream;
import java.util.Map;

public class WikiNodeServiceImpl
extends WikiNodeServiceBaseImpl {
    public WikiNode addNode(String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        WikiPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "ADD_NODE");
        return this.wikiNodeLocalService.addNode(this.getUserId(), name, description, serviceContext);
    }

    public void deleteNode(long nodeId) throws PortalException, SystemException {
        WikiNodePermission.check(this.getPermissionChecker(), nodeId, "DELETE");
        this.wikiNodeLocalService.deleteNode(nodeId);
    }

    public WikiNode getNode(long nodeId) throws PortalException, SystemException {
        WikiNodePermission.check(this.getPermissionChecker(), nodeId, "VIEW");
        return this.wikiNodeLocalService.getNode(nodeId);
    }

    public WikiNode getNode(long groupId, String name) throws PortalException, SystemException {
        WikiNodePermission.check(this.getPermissionChecker(), groupId, name, "VIEW");
        return this.wikiNodeLocalService.getNode(groupId, name);
    }

    public void importPages(long nodeId, String importer, InputStream[] inputStreams, Map<String, String[]> options) throws PortalException, SystemException {
        WikiNodePermission.check(this.getPermissionChecker(), nodeId, "IMPORT");
        this.wikiNodeLocalService.importPages(this.getUserId(), nodeId, importer, inputStreams, options);
    }

    public WikiNode moveNodeToTrash(long nodeId) throws PortalException, SystemException {
        WikiNodePermission.check(this.getPermissionChecker(), nodeId, "DELETE");
        return this.wikiNodeLocalService.moveNodeToTrash(this.getUserId(), nodeId);
    }

    public void restoreNodeFromTrash(long nodeId) throws PortalException, SystemException {
        WikiNode node = this.wikiNodeLocalService.getNode(nodeId);
        WikiNodePermission.check(this.getPermissionChecker(), nodeId, "DELETE");
        this.wikiNodeLocalService.restoreNodeFromTrash(this.getUserId(), node);
    }

    public void subscribeNode(long nodeId) throws PortalException, SystemException {
        WikiNodePermission.check(this.getPermissionChecker(), nodeId, "SUBSCRIBE");
        this.wikiNodeLocalService.subscribeNode(this.getUserId(), nodeId);
    }

    public void unsubscribeNode(long nodeId) throws PortalException, SystemException {
        WikiNodePermission.check(this.getPermissionChecker(), nodeId, "SUBSCRIBE");
        this.wikiNodeLocalService.unsubscribeNode(this.getUserId(), nodeId);
    }

    public WikiNode updateNode(long nodeId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        WikiNodePermission.check(this.getPermissionChecker(), nodeId, "UPDATE");
        return this.wikiNodeLocalService.updateNode(nodeId, name, description, serviceContext);
    }
}

