/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.service.impl;

import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.trash.model.TrashEntry;
import com.liferay.portlet.trash.util.TrashUtil;
import com.liferay.portlet.wiki.DuplicateNodeNameException;
import com.liferay.portlet.wiki.NodeNameException;
import com.liferay.portlet.wiki.importers.WikiImporter;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.base.WikiNodeLocalServiceBaseImpl;
import com.liferay.portlet.wiki.util.WikiCacheThreadLocal;
import com.liferay.portlet.wiki.util.WikiCacheUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WikiNodeLocalServiceImpl
extends WikiNodeLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(WikiNodeLocalServiceImpl.class);
    private Map<String, WikiImporter> _wikiImporters = new HashMap<String, WikiImporter>();

    public WikiNode addDefaultNode(long userId, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.addNode(userId, PropsValues.WIKI_INITIAL_NODE_NAME, "", serviceContext);
    }

    public WikiNode addNode(long userId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long groupId = serviceContext.getScopeGroupId();
        Date now = new Date();
        this.validate(groupId, name);
        long nodeId = this.counterLocalService.increment();
        WikiNode node = this.wikiNodePersistence.create(nodeId);
        node.setUuid(serviceContext.getUuid());
        node.setGroupId(groupId);
        node.setCompanyId(user.getCompanyId());
        node.setUserId(user.getUserId());
        node.setUserName(user.getFullName());
        node.setCreateDate(serviceContext.getCreateDate(now));
        node.setModifiedDate(serviceContext.getModifiedDate(now));
        node.setName(name);
        node.setDescription(description);
        try {
            this.wikiNodePersistence.update((BaseModel)node);
        }
        catch (SystemException se) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Add failed, fetch {groupId=" + groupId + ", name=" + name + "}"));
            }
            if ((node = this.wikiNodePersistence.fetchByG_N(groupId, name, false)) == null) {
                throw se;
            }
            return node;
        }
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addNodeResources(node, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addNodeResources(node, serviceContext.getGroupPermissions(), serviceContext.getGuestPermissions());
        }
        return node;
    }

    public void addNodeResources(long nodeId, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        WikiNode node = this.wikiNodePersistence.findByPrimaryKey(nodeId);
        this.addNodeResources(node, addGroupPermissions, addGuestPermissions);
    }

    public void addNodeResources(long nodeId, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        WikiNode node = this.wikiNodePersistence.findByPrimaryKey(nodeId);
        this.addNodeResources(node, groupPermissions, guestPermissions);
    }

    public void addNodeResources(WikiNode node, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(node.getCompanyId(), node.getGroupId(), node.getUserId(), WikiNode.class.getName(), node.getNodeId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addNodeResources(WikiNode node, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(node.getCompanyId(), node.getGroupId(), node.getUserId(), WikiNode.class.getName(), node.getNodeId(), groupPermissions, guestPermissions);
    }

    public void deleteNode(long nodeId) throws PortalException, SystemException {
        WikiNode node = this.wikiNodePersistence.findByPrimaryKey(nodeId);
        this.deleteNode(node);
    }

    public void deleteNode(WikiNode node) throws PortalException, SystemException {
        this.wikiPageLocalService.deletePages(node.getNodeId());
        this.wikiNodePersistence.remove((BaseModel)node);
        this.resourceLocalService.deleteResource(node.getCompanyId(), WikiNode.class.getName(), 4, node.getNodeId());
        this.systemEventLocalService.addSystemEvent(node.getGroupId(), WikiNode.class.getName(), node.getNodeId(), node.getUuid(), 1);
        long folderId = node.getAttachmentsFolderId();
        if (folderId != 0L) {
            PortletFileRepositoryUtil.deleteFolder((long)folderId);
        }
        this.subscriptionLocalService.deleteSubscriptions(node.getCompanyId(), WikiNode.class.getName(), node.getNodeId());
        if (node.isInTrash()) {
            node.setName(TrashUtil.getOriginalTitle((String)node.getName()));
            this.trashEntryLocalService.deleteEntry(WikiNode.class.getName(), node.getNodeId());
            Indexer wikiNodeIndexer = IndexerRegistryUtil.nullSafeGetIndexer(WikiNode.class);
            wikiNodeIndexer.delete((Object)node);
        }
        Indexer wikiPageIndexer = IndexerRegistryUtil.nullSafeGetIndexer(WikiPage.class);
        wikiPageIndexer.delete((Object)node);
    }

    public void deleteNodes(long groupId) throws PortalException, SystemException {
        List nodes = this.wikiNodePersistence.findByGroupId(groupId);
        for (WikiNode node : nodes) {
            this.deleteNode(node);
        }
        PortletFileRepositoryUtil.deletePortletRepository((long)groupId, (String)"36");
    }

    public WikiNode fetchWikiNode(long groupId, String name) throws SystemException {
        return this.wikiNodePersistence.fetchByG_N(groupId, name);
    }

    public List<WikiNode> getCompanyNodes(long companyId, int start, int end) throws SystemException {
        return this.wikiNodePersistence.findByC_S(companyId, 0, start, end);
    }

    public List<WikiNode> getCompanyNodes(long companyId, int status, int start, int end) throws SystemException {
        return this.wikiNodePersistence.findByC_S(companyId, status, start, end);
    }

    public int getCompanyNodesCount(long companyId) throws SystemException {
        return this.wikiNodePersistence.countByC_S(companyId, 0);
    }

    public int getCompanyNodesCount(long companyId, int status) throws SystemException {
        return this.wikiNodePersistence.countByC_S(companyId, status);
    }

    public WikiNode getNode(long nodeId) throws PortalException, SystemException {
        return this.wikiNodePersistence.findByPrimaryKey(nodeId);
    }

    public WikiNode getNode(long groupId, String nodeName) throws PortalException, SystemException {
        return this.wikiNodePersistence.findByG_N(groupId, nodeName);
    }

    public List<WikiNode> getNodes(long groupId) throws PortalException, SystemException {
        return this.getNodes(groupId, 0);
    }

    public List<WikiNode> getNodes(long groupId, int status) throws PortalException, SystemException {
        List<WikiNode> nodes = this.wikiNodePersistence.findByG_S(groupId, status);
        if (nodes.isEmpty()) {
            nodes = this.addDefaultNode(groupId);
        }
        return nodes;
    }

    public List<WikiNode> getNodes(long groupId, int start, int end) throws PortalException, SystemException {
        return this.getNodes(groupId, 0, start, end);
    }

    public List<WikiNode> getNodes(long groupId, int status, int start, int end) throws PortalException, SystemException {
        List<WikiNode> nodes = this.wikiNodePersistence.findByG_S(groupId, status, start, end);
        if (nodes.isEmpty()) {
            nodes = this.addDefaultNode(groupId);
        }
        return nodes;
    }

    public int getNodesCount(long groupId) throws SystemException {
        return this.wikiNodePersistence.countByG_S(groupId, 0);
    }

    public int getNodesCount(long groupId, int status) throws SystemException {
        return this.wikiNodePersistence.countByG_S(groupId, status);
    }

    public void importPages(long userId, long nodeId, String importer, InputStream[] inputStreams, Map<String, String[]> options) throws PortalException, SystemException {
        WikiNode node = this.getNode(nodeId);
        WikiImporter wikiImporter = this.getWikiImporter(importer);
        wikiImporter.importPages(userId, node, inputStreams, options);
    }

    public WikiNode moveNodeToTrash(long userId, long nodeId) throws PortalException, SystemException {
        WikiNode node = this.wikiNodePersistence.findByPrimaryKey(nodeId);
        return this.moveNodeToTrash(userId, node);
    }

    public WikiNode moveNodeToTrash(long userId, WikiNode node) throws PortalException, SystemException {
        node = this.updateStatus(userId, node, 8, new ServiceContext());
        TrashEntry trashEntry = this.trashEntryLocalService.getEntry(WikiNode.class.getName(), node.getNodeId());
        String trashTitle = TrashUtil.getTrashTitle((long)trashEntry.getEntryId());
        node.setName(trashTitle);
        return (WikiNode)this.wikiNodePersistence.update((BaseModel)node);
    }

    public void restoreNodeFromTrash(long userId, WikiNode node) throws PortalException, SystemException {
        String name = TrashUtil.getOriginalTitle((String)node.getName());
        node.setName(name);
        this.wikiNodePersistence.update((BaseModel)node);
        TrashEntry trashEntry = this.trashEntryLocalService.getEntry(WikiNode.class.getName(), node.getNodeId());
        this.updateStatus(userId, node, trashEntry.getStatus(), new ServiceContext());
    }

    public void subscribeNode(long userId, long nodeId) throws PortalException, SystemException {
        WikiNode node = this.getNode(nodeId);
        this.subscriptionLocalService.addSubscription(userId, node.getGroupId(), WikiNode.class.getName(), nodeId);
    }

    public void unsubscribeNode(long userId, long nodeId) throws PortalException, SystemException {
        this.subscriptionLocalService.deleteSubscription(userId, WikiNode.class.getName(), nodeId);
    }

    public WikiNode updateNode(long nodeId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        WikiNode node = this.wikiNodePersistence.findByPrimaryKey(nodeId);
        this.validate(nodeId, node.getGroupId(), name);
        node.setModifiedDate(serviceContext.getModifiedDate(null));
        node.setName(name);
        node.setDescription(description);
        this.wikiNodePersistence.update((BaseModel)node);
        return node;
    }

    public WikiNode updateStatus(long userId, WikiNode node, int status, ServiceContext serviceContext) throws PortalException, SystemException {
        int oldStatus = node.getStatus();
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date now = new Date();
        node.setStatus(status);
        node.setStatusByUserId(userId);
        node.setStatusByUserName(user.getFullName());
        node.setStatusDate(now);
        this.wikiNodePersistence.update((BaseModel)node);
        this.updateDependentStatus(node.getNodeId(), status);
        if (oldStatus == 8) {
            this.trashEntryLocalService.deleteEntry(WikiNode.class.getName(), node.getNodeId());
        } else if (status == 8) {
            UnicodeProperties typeSettingsProperties = new UnicodeProperties();
            typeSettingsProperties.put("title", node.getName());
            this.trashEntryLocalService.addTrashEntry(userId, node.getGroupId(), WikiNode.class.getName(), node.getNodeId(), oldStatus, null, typeSettingsProperties);
        }
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(WikiNode.class);
        if (status == 8) {
            indexer.reindex((Object)node);
        } else {
            indexer.delete((Object)node);
        }
        return node;
    }

    protected List<WikiNode> addDefaultNode(long groupId) throws PortalException, SystemException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        long defaultUserId = this.userLocalService.getDefaultUserId(group.getCompanyId());
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setScopeGroupId(groupId);
        WikiNode node = this.wikiNodeLocalService.addDefaultNode(defaultUserId, serviceContext);
        ArrayList<WikiNode> nodes = new ArrayList<WikiNode>(1);
        nodes.add(node);
        return nodes;
    }

    protected WikiImporter getWikiImporter(String importer) throws SystemException {
        WikiImporter wikiImporter = this._wikiImporters.get(importer);
        if (wikiImporter == null) {
            String importerClass = PropsUtil.get("wiki.importers.class", new Filter(importer));
            if (importerClass != null) {
                wikiImporter = (WikiImporter)InstancePool.get((String)importerClass);
                this._wikiImporters.put(importer, wikiImporter);
            }
            if (importer == null) {
                throw new SystemException("Unable to instantiate wiki importer class " + importerClass);
            }
        }
        return wikiImporter;
    }

    protected void updateDependentStatus(long nodeId, int status) throws PortalException, SystemException {
        List pages = this.wikiPagePersistence.findByNodeId(nodeId);
        for (WikiPage page : pages) {
            Indexer indexer;
            if (status == 8) {
                if (page.getStatus() == 0) {
                    this.assetEntryLocalService.updateVisible(WikiPage.class.getName(), page.getResourcePrimKey(), false);
                }
                this.socialActivityCounterLocalService.disableActivityCounters(WikiPage.class.getName(), page.getResourcePrimKey());
                indexer = IndexerRegistryUtil.nullSafeGetIndexer(WikiPage.class);
                indexer.reindex((Object)page);
                if (WikiCacheThreadLocal.isClearCache()) {
                    WikiCacheUtil.clearCache(page.getNodeId());
                }
                if (page.getStatus() != 1) continue;
                page.setStatus(2);
                this.wikiPagePersistence.update((BaseModel)page);
                this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(page.getCompanyId(), page.getGroupId(), WikiPage.class.getName(), page.getResourcePrimKey());
                continue;
            }
            if (page.getStatus() == 0) {
                this.assetEntryLocalService.updateVisible(WikiPage.class.getName(), page.getResourcePrimKey(), true);
            }
            this.socialActivityCounterLocalService.enableActivityCounters(WikiPage.class.getName(), page.getResourcePrimKey());
            indexer = IndexerRegistryUtil.nullSafeGetIndexer(WikiPage.class);
            indexer.reindex((Object)page);
        }
    }

    protected void validate(long nodeId, long groupId, String name) throws PortalException, SystemException {
        if (name.equalsIgnoreCase("tag")) {
            throw new NodeNameException(String.valueOf(name) + " is reserved");
        }
        if (Validator.isNull((String)name)) {
            throw new NodeNameException();
        }
        WikiNode node = this.wikiNodePersistence.fetchByG_N(groupId, name);
        if (node != null && node.getNodeId() != nodeId) {
            throw new DuplicateNodeNameException();
        }
    }

    protected void validate(long groupId, String name) throws PortalException, SystemException {
        this.validate(0L, groupId, name);
    }
}

