/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.http.TunnelUtil;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.service.WikiNodeServiceUtil;
import java.io.InputStream;
import java.util.Map;

public class WikiNodeServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(WikiNodeServiceHttp.class);
    private static final Class<?>[] _addNodeParameterTypes0 = new Class[]{String.class, String.class, ServiceContext.class};
    private static final Class<?>[] _deleteNodeParameterTypes1 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getNodeParameterTypes2 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getNodeParameterTypes3 = new Class[]{Long.TYPE, String.class};
    private static final Class<?>[] _importPagesParameterTypes4 = new Class[]{Long.TYPE, String.class, InputStream[].class, Map.class};
    private static final Class<?>[] _moveNodeToTrashParameterTypes5 = new Class[]{Long.TYPE};
    private static final Class<?>[] _restoreNodeFromTrashParameterTypes6 = new Class[]{Long.TYPE};
    private static final Class<?>[] _subscribeNodeParameterTypes7 = new Class[]{Long.TYPE};
    private static final Class<?>[] _unsubscribeNodeParameterTypes8 = new Class[]{Long.TYPE};
    private static final Class<?>[] _updateNodeParameterTypes9 = new Class[]{Long.TYPE, String.class, String.class, ServiceContext.class};

    public static WikiNode addNode(HttpPrincipal httpPrincipal, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(WikiNodeServiceUtil.class, "addNode", (Class[])_addNodeParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{name, description, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (WikiNode)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteNode(HttpPrincipal httpPrincipal, long nodeId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(WikiNodeServiceUtil.class, "deleteNode", (Class[])_deleteNodeParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static WikiNode getNode(HttpPrincipal httpPrincipal, long nodeId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(WikiNodeServiceUtil.class, "getNode", (Class[])_getNodeParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (WikiNode)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static WikiNode getNode(HttpPrincipal httpPrincipal, long groupId, String name) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(WikiNodeServiceUtil.class, "getNode", (Class[])_getNodeParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, name});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (WikiNode)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void importPages(HttpPrincipal httpPrincipal, long nodeId, String importer, InputStream[] inputStreams, Map<String, String[]> options) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(WikiNodeServiceUtil.class, "importPages", (Class[])_importPagesParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, importer, inputStreams, options});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static WikiNode moveNodeToTrash(HttpPrincipal httpPrincipal, long nodeId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(WikiNodeServiceUtil.class, "moveNodeToTrash", (Class[])_moveNodeToTrashParameterTypes5);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (WikiNode)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void restoreNodeFromTrash(HttpPrincipal httpPrincipal, long nodeId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(WikiNodeServiceUtil.class, "restoreNodeFromTrash", (Class[])_restoreNodeFromTrashParameterTypes6);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void subscribeNode(HttpPrincipal httpPrincipal, long nodeId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(WikiNodeServiceUtil.class, "subscribeNode", (Class[])_subscribeNodeParameterTypes7);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void unsubscribeNode(HttpPrincipal httpPrincipal, long nodeId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(WikiNodeServiceUtil.class, "unsubscribeNode", (Class[])_unsubscribeNodeParameterTypes8);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static WikiNode updateNode(HttpPrincipal httpPrincipal, long nodeId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(WikiNodeServiceUtil.class, "updateNode", (Class[])_updateNodeParameterTypes9);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, name, description, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (WikiNode)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

