/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.lar;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.BasePortletDataHandler;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataException;
import com.liferay.portal.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.WikiNodeLocalServiceUtil;
import com.liferay.portlet.wiki.service.persistence.WikiNodeExportActionableDynamicQuery;
import com.liferay.portlet.wiki.service.persistence.WikiPageExportActionableDynamicQuery;
import com.liferay.portlet.wiki.util.WikiCacheThreadLocal;
import com.liferay.portlet.wiki.util.WikiCacheUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class WikiPortletDataHandler
extends BasePortletDataHandler {
    public static final String NAMESPACE = "wiki";

    public WikiPortletDataHandler() {
        this.setDeletionSystemEventClassNames(new String[]{WikiNode.class.getName(), WikiPage.class.getName()});
        this.setExportControls(new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(NAMESPACE, "wiki-pages", true, false, null, WikiPage.class.getName()), new PortletDataHandlerBoolean(NAMESPACE, "embedded-assets")});
        this.setImportControls(this.getExportControls());
    }

    public PortletPreferences importData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws PortletDataException {
        WikiCacheThreadLocal.setClearCache(false);
        try {
            PortletPreferences portletPreferences2 = super.importData(portletDataContext, portletId, portletPreferences, data);
            return portletPreferences2;
        }
        finally {
            WikiCacheThreadLocal.setClearCache(true);
        }
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (portletDataContext.addPrimaryKey(WikiPortletDataHandler.class, "deleteData")) {
            return portletPreferences;
        }
        WikiNodeLocalServiceUtil.deleteNodes((long)portletDataContext.getScopeGroupId());
        return portletPreferences;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        Element rootElement = this.addExportDataRootElement(portletDataContext);
        if (!portletDataContext.getBooleanParameter(NAMESPACE, "wiki-pages")) {
            return this.getExportDataRootElementString(rootElement);
        }
        portletDataContext.addPermissions("com.liferay.portlet.wiki", portletDataContext.getScopeGroupId());
        rootElement.addAttribute("group-id", String.valueOf(portletDataContext.getScopeGroupId()));
        WikiNodeExportActionableDynamicQuery nodeActionableDynamicQuery = new WikiNodeExportActionableDynamicQuery(portletDataContext);
        nodeActionableDynamicQuery.performActions();
        ActionableDynamicQuery pageActionableDynamicQuery = this.getPageActionableDynamicQuery(portletDataContext);
        pageActionableDynamicQuery.performActions();
        return this.getExportDataRootElementString(rootElement);
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        if (!portletDataContext.getBooleanParameter(NAMESPACE, "wiki-pages")) {
            return null;
        }
        portletDataContext.importPermissions("com.liferay.portlet.wiki", portletDataContext.getSourceGroupId(), portletDataContext.getScopeGroupId());
        Element nodesElement = portletDataContext.getImportDataGroupElement(WikiNode.class);
        List nodeElements = nodesElement.elements();
        for (Element nodeElement : nodeElements) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)nodeElement);
        }
        Element pagesElement = portletDataContext.getImportDataGroupElement(WikiPage.class);
        List pageElements = pagesElement.elements();
        for (Element pageElement : pageElements) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)pageElement);
        }
        Map nodeIds = portletDataContext.getNewPrimaryKeysMap(WikiNode.class);
        Iterator iterator = nodeIds.values().iterator();
        while (iterator.hasNext()) {
            long nodeId = (Long)iterator.next();
            WikiCacheUtil.clearCache(nodeId);
        }
        return null;
    }

    protected void doPrepareManifestSummary(PortletDataContext portletDataContext) throws Exception {
        WikiNodeExportActionableDynamicQuery nodeActionableDynamicQuery = new WikiNodeExportActionableDynamicQuery(portletDataContext);
        nodeActionableDynamicQuery.performCount();
        ActionableDynamicQuery pageExportActionableDynamicQuery = this.getPageActionableDynamicQuery(portletDataContext);
        pageExportActionableDynamicQuery.performCount();
    }

    protected ActionableDynamicQuery getPageActionableDynamicQuery(PortletDataContext portletDataContext) throws SystemException {
        return new WikiPageExportActionableDynamicQuery(portletDataContext){

            protected void addCriteria(DynamicQuery dynamicQuery) {
                super.addCriteria(dynamicQuery);
                Property statusProperty = PropertyFactoryUtil.forName((String)"status");
                dynamicQuery.add(statusProperty.eq((Object)0));
            }
        };
    }
}

