/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.lar;

import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.wiki.NoSuchNodeException;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.service.WikiNodeLocalServiceUtil;
import com.liferay.portlet.wiki.service.persistence.WikiNodeUtil;

public class WikiNodeStagedModelDataHandler
extends BaseStagedModelDataHandler<WikiNode> {
    public static final String[] CLASS_NAMES = new String[]{WikiNode.class.getName()};

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, WikiNode node) throws Exception {
        Element nodeElement = portletDataContext.getExportDataElement((ClassedModel)node);
        portletDataContext.addClassedModel(nodeElement, ExportImportPathUtil.getModelPath((StagedModel)node), (ClassedModel)node, "wiki");
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, WikiNode node) throws Exception {
        long userId = portletDataContext.getUserId(node.getUserUuid());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)node, "wiki");
        WikiNode importedNode = null;
        if (portletDataContext.isDataStrategyMirror()) {
            WikiNode existingNode = WikiNodeUtil.fetchByUUID_G((String)node.getUuid(), (long)portletDataContext.getScopeGroupId());
            String initialNodeName = PropsValues.WIKI_INITIAL_NODE_NAME;
            if (existingNode == null && initialNodeName.equals(node.getName())) {
                try {
                    WikiNodeUtil.removeByG_N((long)portletDataContext.getScopeGroupId(), (String)node.getName());
                }
                catch (NoSuchNodeException noSuchNodeException) {}
            }
            if (existingNode == null) {
                serviceContext.setUuid(node.getUuid());
                importedNode = WikiNodeLocalServiceUtil.addNode((long)userId, (String)node.getName(), (String)node.getDescription(), (ServiceContext)serviceContext);
            } else {
                importedNode = WikiNodeLocalServiceUtil.updateNode((long)existingNode.getNodeId(), (String)node.getName(), (String)node.getDescription(), (ServiceContext)serviceContext);
            }
        } else {
            String initialNodeName = PropsValues.WIKI_INITIAL_NODE_NAME;
            if (initialNodeName.equals(node.getName())) {
                try {
                    WikiNodeUtil.removeByG_N((long)portletDataContext.getScopeGroupId(), (String)node.getName());
                }
                catch (NoSuchNodeException noSuchNodeException) {}
            }
            String nodeName = this.getNodeName(portletDataContext, node, node.getName(), 2);
            importedNode = WikiNodeLocalServiceUtil.addNode((long)userId, (String)nodeName, (String)node.getDescription(), (ServiceContext)serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)node, (ClassedModel)importedNode, "wiki");
    }

    protected String getNodeName(PortletDataContext portletDataContext, WikiNode node, String name, int count) throws Exception {
        WikiNode existingNode = WikiNodeUtil.fetchByG_N((long)portletDataContext.getScopeGroupId(), (String)name);
        if (existingNode == null) {
            return name;
        }
        String nodeName = node.getName();
        return this.getNodeName(portletDataContext, node, nodeName.concat(" ").concat(String.valueOf(count)), ++count);
    }
}

