/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.lar;

import com.liferay.portal.kernel.lar.DataLevel;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.StagedModel;
import com.liferay.portlet.wiki.NoSuchNodeException;
import com.liferay.portlet.wiki.lar.WikiPortletDataHandler;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import com.liferay.portlet.wiki.service.persistence.WikiNodeUtil;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class WikiDisplayPortletDataHandler
extends WikiPortletDataHandler {
    private static Log _log = LogFactoryUtil.getLog(WikiDisplayPortletDataHandler.class);

    public WikiDisplayPortletDataHandler() {
        this.setDataLevel(DataLevel.PORTLET_INSTANCE);
        this.setDataPortletPreferences(new String[]{"title", "nodeId"});
    }

    @Override
    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (portletPreferences == null) {
            return portletPreferences;
        }
        portletPreferences.setValue("title", "");
        portletPreferences.setValue("nodeId", "");
        return portletPreferences;
    }

    @Override
    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        long nodeId = GetterUtil.getLong((String)portletPreferences.getValue("nodeId", ""));
        if (nodeId <= 0L) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No node id found in preferences of portlet " + portletId));
            }
            return "";
        }
        String title = portletPreferences.getValue("title", null);
        if (title == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No title found in preferences of portlet " + portletId));
            }
            return "";
        }
        WikiNode node = null;
        try {
            node = WikiNodeUtil.findByPrimaryKey((long)nodeId);
        }
        catch (NoSuchNodeException nsne) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)nsne, (Throwable)nsne);
            }
            return "";
        }
        portletDataContext.addPermissions("com.liferay.portlet.wiki", portletDataContext.getScopeGroupId());
        Element rootElement = this.addExportDataRootElement(portletDataContext);
        rootElement.addAttribute("group-id", String.valueOf(portletDataContext.getScopeGroupId()));
        StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)node);
        List pages = WikiPageLocalServiceUtil.getPages((long)node.getNodeId(), (int)-1, (int)-1);
        for (WikiPage page : pages) {
            StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)page);
        }
        return this.getExportDataRootElementString(rootElement);
    }

    @Override
    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        portletDataContext.importPermissions("com.liferay.portlet.wiki", portletDataContext.getSourceGroupId(), portletDataContext.getScopeGroupId());
        super.importData(portletDataContext, portletId, portletPreferences, data);
        long nodeId = GetterUtil.getLong((String)portletPreferences.getValue("nodeId", ""));
        if (nodeId > 0L) {
            Map nodeIds = portletDataContext.getNewPrimaryKeysMap(WikiNode.class);
            nodeId = MapUtil.getLong((Map)nodeIds, (long)nodeId, (long)nodeId);
            portletPreferences.setValue("nodeId", String.valueOf(nodeId));
        }
        return portletPreferences;
    }
}

