/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.asset;

import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.model.BaseAssetRenderer;
import com.liferay.portlet.trash.util.TrashUtil;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.permission.WikiPagePermission;
import com.liferay.portlet.wiki.util.WikiUtil;
import java.util.Date;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;

public class WikiPageAssetRenderer
extends BaseAssetRenderer
implements TrashRenderer {
    public static final String TYPE = "wiki_page";
    private WikiPage _page;

    public static long getClassPK(WikiPage page) {
        if (!(page.isApproved() || page.isDraft() || page.isPending() || page.isInTrash() || page.isInTrashContainer() || page.getVersion() == 1.0)) {
            return page.getPageId();
        }
        return page.getResourcePrimKey();
    }

    public WikiPageAssetRenderer(WikiPage page) {
        this._page = page;
    }

    public String getClassName() {
        return WikiPage.class.getName();
    }

    public long getClassPK() {
        return WikiPageAssetRenderer.getClassPK(this._page);
    }

    public String getDiscussionPath() {
        if (PropsValues.WIKI_PAGE_COMMENTS_ENABLED) {
            return "edit_page_discussion";
        }
        return null;
    }

    public Date getDisplayDate() {
        return this._page.getModifiedDate();
    }

    public long getGroupId() {
        return this._page.getGroupId();
    }

    public String getPortletId() {
        return "36";
    }

    public String getSummary(Locale locale) {
        String content = this._page.getContent();
        try {
            content = HtmlUtil.extractText((String)WikiUtil.convert(this._page, null, null, null));
        }
        catch (Exception exception) {}
        return content;
    }

    public String getThumbnailPath(PortletRequest portletRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return String.valueOf(themeDisplay.getPathThemeImages()) + "/file_system/large/wiki_page.png";
    }

    public String getTitle(Locale locale) {
        if (!this._page.isInTrash()) {
            return this._page.getTitle();
        }
        return TrashUtil.getOriginalTitle((String)this._page.getTitle());
    }

    public String getType() {
        return TYPE;
    }

    public PortletURL getURLEdit(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws Exception {
        LiferayPortletURL portletURL = liferayPortletResponse.createLiferayPortletURL(this.getControlPanelPlid(liferayPortletRequest), "36", "RENDER_PHASE");
        portletURL.setParameter("struts_action", "/wiki/edit_page");
        portletURL.setParameter("nodeId", String.valueOf(this._page.getNodeId()));
        portletURL.setParameter("title", this._page.getTitle());
        return portletURL;
    }

    public PortletURL getURLExport(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        PortletURL exportPortletURL = liferayPortletResponse.createActionURL();
        exportPortletURL.setParameter("struts_action", "/asset_publisher/export_wiki_page");
        exportPortletURL.setParameter("nodeId", String.valueOf(this._page.getNodeId()));
        exportPortletURL.setParameter("title", this._page.getTitle());
        return exportPortletURL;
    }

    public PortletURL getURLView(LiferayPortletResponse liferayPortletResponse, WindowState windowState) throws Exception {
        LiferayPortletURL portletURL = liferayPortletResponse.createLiferayPortletURL("36", "RENDER_PHASE");
        portletURL.setParameter("struts_action", "/wiki/view");
        portletURL.setParameter("nodeId", String.valueOf(this._page.getNodeId()));
        portletURL.setParameter("title", this._page.getTitle());
        portletURL.setWindowState(windowState);
        return portletURL;
    }

    public String getURLViewInContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String noSuchEntryRedirect) {
        return this.getURLViewInContext(liferayPortletRequest, noSuchEntryRedirect, "/wiki/find_page", "pageResourcePrimKey", this._page.getResourcePrimKey());
    }

    public long getUserId() {
        return this._page.getUserId();
    }

    public String getUserName() {
        return this._page.getUserName();
    }

    public String getUuid() {
        return this._page.getUuid();
    }

    public boolean hasDeletePermission(PermissionChecker permissionChecker) {
        return WikiPagePermission.contains(permissionChecker, this._page, "DELETE");
    }

    public boolean hasEditPermission(PermissionChecker permissionChecker) {
        return WikiPagePermission.contains(permissionChecker, this._page, "UPDATE");
    }

    public boolean hasViewPermission(PermissionChecker permissionChecker) {
        return WikiPagePermission.contains(permissionChecker, this._page, "VIEW");
    }

    public boolean isConvertible() {
        return true;
    }

    public boolean isPrintable() {
        return true;
    }

    public String render(RenderRequest renderRequest, RenderResponse renderResponse, String template) throws Exception {
        if (template.equals("abstract") || template.equals("full_content")) {
            renderRequest.setAttribute("WIKI_PAGE", (Object)this._page);
            return "/html/portlet/wiki/asset/" + template + ".jsp";
        }
        return null;
    }

    protected String getIconPath(ThemeDisplay themeDisplay) {
        return String.valueOf(themeDisplay.getPathThemeImages()) + "/common/page.png";
    }
}

