/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.action;

import com.liferay.portal.kernel.portlet.LiferayPortletConfig;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.wiki.DuplicateNodeNameException;
import com.liferay.portlet.wiki.NoSuchNodeException;
import com.liferay.portlet.wiki.NodeNameException;
import com.liferay.portlet.wiki.RequiredNodeException;
import com.liferay.portlet.wiki.action.ActionUtil;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.service.WikiNodeLocalServiceUtil;
import com.liferay.portlet.wiki.service.WikiNodeServiceUtil;
import com.liferay.portlet.wiki.util.WikiCacheThreadLocal;
import com.liferay.portlet.wiki.util.WikiCacheUtil;
import java.util.HashMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditNodeAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateNode(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteNode((LiferayPortletConfig)portletConfig, actionRequest, false);
            } else if (cmd.equals("move_to_trash")) {
                this.deleteNode((LiferayPortletConfig)portletConfig, actionRequest, true);
            } else if (cmd.equals("restore")) {
                this.restoreNode(actionRequest);
            } else if (cmd.equals("subscribe")) {
                this.subscribeNode(actionRequest);
            } else if (cmd.equals("unsubscribe")) {
                this.unsubscribeNode(actionRequest);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchNodeException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.wiki.error");
            }
            if (e2 instanceof DuplicateNodeNameException || e2 instanceof NodeNameException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
            }
            throw e2;
        }
    }

    @Override
    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            long nodeId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"nodeId");
            if (nodeId > 0L) {
                ActionUtil.getNode((PortletRequest)renderRequest);
            }
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchNodeException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e2.getClass());
                return mapping.findForward("portlet.wiki.error");
            }
            throw e2;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.wiki.edit_node"));
    }

    protected void deleteNode(LiferayPortletConfig liferayPortletConfig, ActionRequest actionRequest, boolean moveToTrash) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        int nodeCount = WikiNodeLocalServiceUtil.getNodesCount((long)themeDisplay.getScopeGroupId());
        if (nodeCount == 1) {
            SessionErrors.add((PortletRequest)actionRequest, RequiredNodeException.class);
            return;
        }
        long nodeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"nodeId");
        String oldName = this.getNodeName(nodeId);
        WikiCacheThreadLocal.setClearCache(false);
        if (moveToTrash) {
            WikiNodeServiceUtil.moveNodeToTrash((long)nodeId);
        } else {
            WikiNodeServiceUtil.deleteNode((long)nodeId);
        }
        WikiCacheUtil.clearCache(nodeId);
        WikiCacheThreadLocal.setClearCache(true);
        this.updatePreferences(actionRequest, oldName, "");
        if (moveToTrash) {
            HashMap<String, String[]> data = new HashMap<String, String[]>();
            data.put("restoreEntryIds", new String[]{String.valueOf(nodeId)});
            SessionMessages.add((PortletRequest)actionRequest, (String)(String.valueOf(liferayPortletConfig.getPortletId()) + ".deleteSuccessData"), data);
            SessionMessages.add((PortletRequest)actionRequest, (String)(String.valueOf(liferayPortletConfig.getPortletId()) + ".hideDefaultSuccessMessage"));
        }
    }

    protected String getNodeName(long nodeId) throws Exception {
        WikiNode node = WikiNodeServiceUtil.getNode((long)nodeId);
        return node.getName();
    }

    protected void restoreNode(ActionRequest actionRequest) throws Exception {
        long[] restoreEntryIds;
        long[] lArray = restoreEntryIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"restoreEntryIds"), (long)0L);
        int n = restoreEntryIds.length;
        int n2 = 0;
        while (n2 < n) {
            long restoreEntryId = lArray[n2];
            WikiNodeServiceUtil.restoreNodeFromTrash((long)restoreEntryId);
            ++n2;
        }
    }

    protected void subscribeNode(ActionRequest actionRequest) throws Exception {
        long nodeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"nodeId");
        WikiNodeServiceUtil.subscribeNode((long)nodeId);
    }

    protected void unsubscribeNode(ActionRequest actionRequest) throws Exception {
        long nodeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"nodeId");
        WikiNodeServiceUtil.unsubscribeNode((long)nodeId);
    }

    protected void updateNode(ActionRequest actionRequest) throws Exception {
        long nodeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"nodeId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)WikiNode.class.getName(), (PortletRequest)actionRequest);
        if (nodeId <= 0L) {
            WikiNodeServiceUtil.addNode((String)name, (String)description, (ServiceContext)serviceContext);
        } else {
            String oldName = this.getNodeName(nodeId);
            WikiNodeServiceUtil.updateNode((long)nodeId, (String)name, (String)description, (ServiceContext)serviceContext);
            this.updatePreferences(actionRequest, oldName, name);
        }
    }

    protected void updatePreferences(ActionRequest actionRequest, String oldName, String newName) throws Exception {
        PortletPreferences preferences = actionRequest.getPreferences();
        String hiddenNodes = preferences.getValue("hiddenNodes", "");
        String visibleNodes = preferences.getValue("visibleNodes", "");
        String regex = String.valueOf(oldName) + ",?";
        preferences.setValue("hiddenNodes", hiddenNodes.replaceFirst(regex, newName));
        preferences.setValue("visibleNodes", visibleNodes.replaceFirst(regex, newName));
        preferences.store();
    }
}

